/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.felectronica;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import server.webserver.felectronica.AuthFElectronica;

public class JSONCloseConnection
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private HttpServletResponse response;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.response = response;
        BufferedReader reader = request.getReader();
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject json = new JSONObject(tokener);
        String apikey = json.getString("apikey");
        try {
            Claims claim = this.validToken(apikey);
            AuthFElectronica.closeConnection();
            JSONObject close = new JSONObject();
            close.put("message", (Object)"Connection Closed");
            response.setStatus(200);
            this.responseJson(close);
        }
        catch (MalformedJwtException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SignatureException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
    }

    private void responseJson(JSONObject ret) {
        try {
            PrintWriter out = this.response.getWriter();
            this.response.setContentType("application/json");
            this.response.setCharacterEncoding("UTF-8");
            System.out.println("response: " + ret.toString());
            out.print(ret.toString());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Claims validToken(String jwt) throws SignatureException {
        Claims claims = (Claims)Jwts.parser().setSigningKey(AuthFElectronica.KEY).parseClaimsJws(jwt).getBody();
        return claims;
    }
}

