/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.rndc;

import common.misc.settings.ServerConfigFileHandler;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.ParseException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import server.businessrules.RunTransaction;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.webserver.rndc.ConsumerRNDCWS;

public class RequestRNDC
extends Thread {
    private SocketChannel sock;
    private int idTipo = 0;
    private int idProceso = 0;
    private String idTransaction;
    private Element subargs;
    private Element raiz;
    private final int PR_REGISTRO_INFO_CARGA = 1;
    private final int PR_EXPIDE_REMESA = 3;
    private final int PR_EXPIDE_MANIFIESTO = 4;
    private final int PR_CUMPLIR_REMESA = 5;
    private final int PR_CUMPLIR_MANIFIESTO = 6;
    private final int PR_ANULA_INFO_CARGA = 7;
    private final int PR_ANULA_INFO_VIAJE = 8;
    private final int PR_ANULA_REMESA = 9;
    private final int PR_UDPATE_TERCERO = 11;
    private final int PR_UPDATE_VEHICULO = 12;
    private final int PR_DICCIONARIO_DATOS = 17;
    private final int PR_DICCIONARIO_ERRORES = 27;
    private final int PR_ANULA_MANIFIESTO = 32;

    public RequestRNDC(Element raiz, SocketChannel sock) {
        this.sock = sock;
        this.raiz = raiz;
    }

    @Override
    public void run() {
        this.idTipo = Integer.parseInt(this.raiz.getChild("idtipo").getValue());
        this.idProceso = Integer.parseInt(this.raiz.getChild("idproceso").getValue());
        this.idTransaction = this.raiz.getChild("idtransaction").getValue();
        this.subargs = this.raiz.getChild("subargs");
        ConsumerRNDCWS rndc = new ConsumerRNDCWS(ServerConfigFileHandler.getDbWeb(), this.subargs, this.sock, this.idTransaction);
        try {
            switch (this.idProceso) {
                case 1: {
                    rndc.sendInfoCarga();
                    break;
                }
                case 3: {
                    rndc.sendRemesaTerrestre();
                    break;
                }
                case 4: {
                    rndc.sendManifiestoCarga();
                    break;
                }
                case 5: {
                    rndc.sendCumplirRemesaTerrestre();
                    break;
                }
                case 6: {
                    rndc.sendCumplirManifiestoCarga();
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    rndc.sendAnulaRemesaTerrestre();
                    break;
                }
                case 11: {
                    rndc.sendUpdateTercero();
                    break;
                }
                case 12: {
                    rndc.sendUpdateVehiculo();
                    break;
                }
                case 17: {
                    break;
                }
                case 27: {
                    break;
                }
                case 32: {
                    rndc.sendAnulaManifiestoCarga();
                }
            }
        }
        catch (IOException | SQLException | java.text.ParseException | ParserConfigurationException | ParseException | JDOMException | SAXException | SQLBadArgumentsException | SQLNotFoundException e) {
            e.printStackTrace();
            System.out.println("Error registrando el tercero en RNDC....");
            RunTransaction.errorMessage(this.sock, "00", e.getMessage());
        }
    }
}

