/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JTextFieldDateEditor;
import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.Couplable;
import common.gui.components.VoidPackageException;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.InstanceFinishingListener;
import common.gui.forms.NotFoundComponentException;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLDateField
extends JDateChooser
implements Couplable,
KeyListener,
DocumentListener,
AnswerListener,
InstanceFinishingListener,
FocusListener {
    private static final long serialVersionUID = -156496730279770021L;
    private GenericForm GFforma;
    private Vector<String> driverEvent;
    private Vector<String> keySQL;
    private Vector<String> importValue = null;
    private String exportValue = null;
    private JPanel panel;
    private String dateFormatString = "yyyy/MM/dd HH:mm:ss";
    private JTextFieldDateEditor editor;
    private boolean onPanel = true;
    private Vector<String> sqlCode = null;
    private Vector<String> constantValue = null;
    private Vector<AnswerListener> answerListener = new Vector();

    public XMLDateField(GenericForm GFforma, Document doc) {
        super("yyyy/MM/dd HH:mm:ss", "####/##/## ##:##:##", '_');
        this.GFforma = GFforma;
        this.driverEvent = new Vector();
        this.keySQL = new Vector();
        this.importValue = new Vector();
        this.sqlCode = new Vector();
        Element parameters = doc.getRootElement();
        for (Element subargs : parameters.getChildren()) {
            String value = subargs.getValue();
            if ("dateFormatString".equals(subargs.getAttributeValue("attribute"))) {
                this.dateFormatString = value;
            } else if ("maskPattern".equals(subargs.getAttributeValue("attribute")) || "placeholder".equals(subargs.getAttributeValue("attribute"))) {
                // empty if block
            }
            if ("enabled".equals(subargs.getAttributeValue("attribute"))) {
                this.setEnabled(Boolean.parseBoolean(value));
                continue;
            }
            if ("keySQL".equals(subargs.getAttributeValue("attribute"))) {
                this.keySQL.addElement(value);
                continue;
            }
            if ("driverEvent".equals(subargs.getAttributeValue("attribute"))) {
                String id = "";
                if (subargs.getAttributeValue("id") != null) {
                    id = subargs.getAttributeValue("id");
                }
                if (this.driverEvent.contains(value + id)) continue;
                this.driverEvent.addElement(value + id);
                continue;
            }
            if ("importValue".equals(subargs.getAttributeValue("attribute"))) {
                this.importValue.add(value);
                continue;
            }
            if ("exportValue".equals(subargs.getAttributeValue("attribute"))) {
                this.exportValue = value;
                continue;
            }
            if ("panel".equals(subargs.getAttributeValue("panel"))) {
                this.onPanel = Boolean.parseBoolean(value);
                continue;
            }
            if ("sqlCode".equals(subargs.getAttributeValue("attribute"))) {
                this.sqlCode.add(subargs.getValue());
                continue;
            }
            if (!"constantValue".equals(subargs.getAttributeValue("attribute"))) continue;
            if (this.constantValue == null) {
                this.constantValue = new Vector();
            }
            this.constantValue.addElement(subargs.getValue());
        }
        if (this.onPanel) {
            this.panel = new JPanel(new FlowLayout(3));
            this.panel.add((Component)((Object)this));
        }
        this.editor = (JTextFieldDateEditor)this.getComponent(1);
        this.editor.getDocument().addDocumentListener(this);
        this.editor.setColumns(20);
        this.editor.addFocusListener((FocusListener)this);
        this.editor.addKeyListener((KeyListener)this);
        this.GFforma.addInitiateFinishListener(this);
    }

    @Override
    public Component getPanel() {
        if (this.onPanel) {
            return this.panel;
        }
        return this;
    }

    @Override
    public Element getPrintPackage() {
        Element pack = new Element("package");
        if (!this.getDate().equals("")) {
            Element field = new Element("field");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
            field.setText(sdf.format(this.getDate()));
            pack.addContent((Content)field);
        }
        return pack;
    }

    @Override
    public Element getPackage() throws VoidPackageException {
        Element pack = new Element("package");
        if (this.getDate() != null && !this.getDate().equals("")) {
            Element field = new Element("field");
            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormatString());
            field.setText(sdf.format(this.getDate()));
            pack.addContent((Content)field);
        }
        return pack;
    }

    public Element getOnlyDatePackage() throws VoidPackageException {
        Element pack = new Element("package");
        if (this.getDate() != null && !this.getDate().equals("")) {
            Element field = new Element("field");
            SimpleDateFormat sdf = new SimpleDateFormat(this.getDateFormatString());
            field.setText(sdf.format(this.getDate()).substring(0, 11));
            pack.addContent((Content)field);
        }
        return pack;
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent AEe) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String date = "";
        try {
            Document doc = AEe.getDocument();
            date = doc.getRootElement().getChild("row").getChildText("col");
            this.setDate(df.parse(date));
            this.exportar();
        }
        catch (NullPointerException NPEe) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void exportar() {
        if (this.exportValue != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatString);
                this.GFforma.setExternalValues((Object)this.exportValue, sdf.format(this.getDate()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        try {
            for (int i = 0; i < this.driverEvent.size(); ++i) {
                this.GFforma.invokeMethod(this.driverEvent.get(i), "addAnswerListener", new Class[]{AnswerListener.class}, new Object[]{this});
            }
        }
        catch (NotFoundComponentException NFCEe) {
            NFCEe.printStackTrace();
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
        }
    }

    @Override
    public boolean containData() {
        try {
            Element elm = this.getPackage();
            if (elm.getChildren().size() > 0) {
                return true;
            }
        }
        catch (VoidPackageException e) {
            return false;
        }
        return false;
    }

    @Override
    public void clean() {
        this.editor.setText("");
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.exportar();
        if (this.sqlCode.size() > 0) {
            this.searchOthersSqls();
        }
    }

    private void searchOthersSqls() {
        int sizeConstantValue = 0;
        if (this.constantValue != null) {
            sizeConstantValue = this.constantValue.size();
        }
        String[] argumentos = new String[this.importValue.size() + sizeConstantValue + 1];
        String[] XMLimpValues = this.importValue.toArray(new String[this.importValue.size()]);
        int i = 0;
        for (i = 0; i < sizeConstantValue; ++i) {
            argumentos[i] = this.constantValue.get(i);
        }
        while (i < this.importValue.size()) {
            argumentos[i] = this.GFforma.getExternalValueString(XMLimpValues[i]);
            ++i;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatString);
        if (this.getDate() != null) {
            argumentos[i] = sdf.format(this.getDate());
            class SearchingSQL
            extends Thread {
                private String[] args;

                public SearchingSQL(String[] args) {
                    this.args = args;
                }

                @Override
                public void run() {
                    for (int i = 0; i < XMLDateField.this.sqlCode.size(); ++i) {
                        Document doc = null;
                        String sql = (String)XMLDateField.this.sqlCode.get(i);
                        try {
                            doc = TransactionServerResultSet.getResultSetST(sql, this.args);
                        }
                        catch (TransactionServerException e) {
                            e.printStackTrace();
                        }
                        AnswerEvent event = new AnswerEvent(this, sql, doc);
                        XMLDateField.this.notificando(event);
                    }
                }
            }
            new SearchingSQL(argumentos).start();
        }
    }

    public void addAnswerListener(AnswerListener listener) {
        this.answerListener.addElement(listener);
    }

    public void removeAnswerListener(AnswerListener listener) {
        this.answerListener.removeElement(listener);
    }

    private void notificando(AnswerEvent event) {
        for (AnswerListener l : this.answerListener) {
            if (!l.containSqlCode(event.getSqlCode())) continue;
            l.arriveAnswerEvent(event);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.exportar();
        if (this.sqlCode.size() > 0) {
            this.searchOthersSqls();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10 || keyCode == 9) {
            this.editor.transferFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return this.keySQL.contains(sqlCode);
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public void validPackage(Element args) throws Exception {
    }
}

