/*
 * Decompiled with CFR 0.152.
 */
package common.gui.forms;

import common.control.ClientHeaderValidator;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.gui.forms.GenericForm;
import common.misc.ZipHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import org.jdom.Element;

public class XLSReceiver
extends JInternalFrame
implements ReportListener {
    private static final long serialVersionUID = 1L;
    private String idReport;
    private JProgressBar progressBar;
    private ByteArrayInputStream bin;

    public XLSReceiver(GenericForm fforma, String idReport) {
        super("Reporte");
        ClientHeaderValidator.addReportListener(this);
        this.idReport = idReport;
        this.setLayout(new BorderLayout());
        this.setSize(200, 45);
        this.setClosable(false);
        this.setDefaultCloseOperation(2);
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(new SoftBevelBorder(1));
        this.progressBar.setStringPainted(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setForeground(new Color(255, 162, 0));
        this.add((Component)this.progressBar, "Center");
    }

    @Override
    public void arriveReport(ReportEvent e) {
        if (!e.getIdReport().equals(this.idReport)) {
            return;
        }
        Element element = e.getData();
        this.setTitle(e.getTitleReport());
        ZipHandler zh = new ZipHandler();
        try {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(10);
            this.progressBar.setValue(10);
            this.setVisible(false);
            this.bin = zh.getDataDecodeInputStream(element.getText());
            String str = "El reporte no a sido guardado";
            String title = "Reporte";
            int typeMessage = 0;
            if (this.save()) {
                str = "Reporte guardado";
                typeMessage = 1;
            }
            JOptionPane.showMessageDialog(this, str, title, typeMessage);
            this.bin.close();
            this.bin = null;
            this.dispose();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private boolean save() {
        File home = new File(System.getProperty("user.home") + File.separator + "reporte.xls");
        JFileChooser fch = new JFileChooser(home);
        fch.setFileSelectionMode(0);
        fch.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Formato XLS / Excel";
            }

            @Override
            public boolean accept(File f) {
                String ext = null;
                String s = f.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return "xls".equals(ext) || f.isDirectory();
            }
        });
        int op = fch.showSaveDialog(this);
        boolean ret = false;
        if (op == 0) {
            File file = fch.getSelectedFile();
            try {
                FileOutputStream fos = new FileOutputStream(file);
                byte[] buffer = new byte[255];
                int len = 0;
                while ((len = this.bin.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ret = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = false;
            }
        }
        return ret;
    }
}

