/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.gui;

import common.pdf.pdfviewer.gui.SwingGUI;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultTransferHandler
extends TransferHandler {
    private Commands currentCommands;
    private SwingGUI currentGUI;
    private GUIThumbnailPanel thumbnails;
    private Values commonValues;

    public DefaultTransferHandler(Values commonValues, GUIThumbnailPanel thumbnails, SwingGUI currentGUI, Commands currentCommands) {
        this.commonValues = commonValues;
        this.thumbnails = thumbnails;
        this.currentGUI = currentGUI;
        this.currentCommands = currentCommands;
    }

    @Override
    public boolean canImport(JComponent dest, DataFlavor[] flavors) {
        return true;
    }

    @Override
    public boolean importData(JComponent src, Transferable transferable) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        DataFlavor listFlavor = null;
        int lastFlavor = flavors.length - 1;
        for (int f = 0; f <= lastFlavor; ++f) {
            if (!flavors[f].isFlavorJavaFileListType()) continue;
            listFlavor = flavors[f];
        }
        try {
            DataFlavor bestTextFlavor = DataFlavor.selectBestTextFlavor(flavors);
            if (bestTextFlavor != null) {
                Reader r = bestTextFlavor.getReaderForText(transferable);
                String textData = this.readTextDate(r);
                String url = this.getURL(textData = this.removeChar(textData, '\u0000'));
                if (url.indexOf("file:/") != url.lastIndexOf("file:/")) {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                } else {
                    this.openFile(url);
                }
            } else if (listFlavor != null) {
                List list = (List)transferable.getTransferData(listFlavor);
                if (list.size() == 1) {
                    File file = (File)list.get(0);
                    this.openFile(file.getAbsolutePath());
                } else {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void openFile(String file) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (file != null) {
            File testExists = new File(file);
            boolean isURL = false;
            if (file.startsWith("http:") || file.startsWith("file:")) {
                LogWriter.writeLog((String)"Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(file + '\n' + Messages.getMessage((String)"PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(file + '\n' + Messages.getMessage((String)"PdfViewerFileIsDirectory.message"));
            } else {
                boolean isValid;
                boolean bl = isValid = file.endsWith(".pdf") || file.endsWith(".fdf") || file.endsWith(".tif") || file.endsWith(".tiff") || file.endsWith(".png") || file.endsWith(".jpg") || file.endsWith(".jpeg");
                if (isValid) {
                    this.commonValues.setSelectedFile(file);
                    this.commonValues.setFileSize(testExists.length() >> 10);
                    this.currentGUI.setViewerTitle(null);
                    this.currentCommands.openFile(file);
                } else {
                    this.currentGUI.showMessageDialog("You may only import a valid PDF or image");
                }
            }
        }
    }

    private String removeChar(String s, char c) {
        String r = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r = r + s.charAt(i);
        }
        return r;
    }

    private String getURL(String textData) throws ParserConfigurationException, SAXException, IOException {
        if (!textData.startsWith("http://") && !textData.startsWith("file://")) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(textData.getBytes()));
            Element a = (Element)doc.getElementsByTagName("a").item(0);
            textData = this.getHrefAttribute(a);
        }
        return textData;
    }

    private String readTextDate(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        String textData = "";
        String line = br.readLine();
        while (line != null) {
            textData = textData + line;
            line = br.readLine();
        }
        br.close();
        return textData;
    }

    private String getHrefAttribute(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        Node nameNode = attrs.getNamedItem("href");
        if (nameNode != null) {
            return nameNode.getNodeValue();
        }
        return null;
    }
}

