/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.gui.swing;

import common.misc.language.Language;
import common.pdf.pdfviewer.Commands;
import common.pdf.pdfviewer.Values;
import common.pdf.pdfviewer.gui.GUIFactory;
import common.pdf.pdfviewer.utils.Printer;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.jpedal.PdfDecoder;

public class FrameCloser
implements InternalFrameListener {
    private Commands currentCommands;
    GUIFactory currentGUI;
    PdfDecoder decode_pdf;
    private Printer currentPrinter;
    Values commonValues;

    public FrameCloser(Commands currentCommands, GUIFactory currentGUI, PdfDecoder decode_pdf, Printer currentPrinter, Values commonValues) {
        this.currentCommands = currentCommands;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.currentPrinter = currentPrinter;
        this.commonValues = commonValues;
    }

    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.currentCommands.flush();
        if (this.currentPrinter.isPrinting()) {
            this.currentGUI.showMessageDialog(Language.getWord("CURRENT_WINDOW_BUSY"));
        } else if (this.commonValues.isProcessing()) {
            int confirm = JOptionPane.showInternalConfirmDialog(this.currentGUI.getFrame(), Language.getWord("CLOSE_CURRENT_WINDOW"), "", 0);
            if (confirm == 0) {
                this.decode_pdf.closePdfFile();
                this.currentGUI.getFrame().dispose();
            }
        } else {
            this.currentGUI.getFrame().dispose();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }
}

