/*
 * Decompiled with CFR 0.152.
 */
package common.printer;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import common.control.ClientHeaderValidator;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.misc.text.NumberToLetterConversor;
import common.printer.AbstractManager;
import common.printer.PrintingManager;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PostScriptManager
implements AbstractManager,
SuccessListener {
    private static final long serialVersionUID = 3641816256967941893L;
    private Graphics2D g2d;
    private boolean successful;
    private PrintingManager.ImpresionType impresionType = PrintingManager.ImpresionType.PDF;
    private String ndocument = "";
    private boolean success = false;
    private Element rootTemplate;
    private int width;
    private int height;
    private Element rootTransact;
    private String idTransaction = "";
    private int rowNextPage = 0;
    private com.lowagie.text.Document document;
    private ByteArrayOutputStream outPut = new ByteArrayOutputStream();
    private PdfContentByte cb;
    private PdfWriter pdfWriter;
    private ArrayList<Graphics2D> objects = new ArrayList();
    private int pageCount = 1;
    private Vector<Query> sqlData = new Vector();
    private String documentPrefix;
    private int currentRow = 1;
    private int rowAcum = 0;
    static final BasicStroke stroke = new BasicStroke(0.3f);

    public PostScriptManager() {
        ClientHeaderValidator.addSuccessListener(this);
    }

    public PostScriptManager(String iddoc) {
        ClientHeaderValidator.addSuccessListener(this);
        this.ndocument = iddoc;
    }

    public void process() {
        try {
            Attribute ATTRequesNumeration = this.rootTemplate.getAttribute("requestNumeration");
            if (ATTRequesNumeration != null && ATTRequesNumeration.getBooleanValue()) {
                int times = 0;
                while (!this.success) {
                    try {
                        if (times > 100) {
                            System.out.println("No se pudo obtner la numeracion de " + this.rootTemplate.getAttributeValue("name"));
                            return;
                        }
                        Thread.sleep(100L);
                        ++times;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Calendar calendar = Calendar.getInstance();
            long init = calendar.getTimeInMillis();
            Element settings = this.rootTemplate.getChild("settings");
            this.width = settings.getAttribute("width").getIntValue();
            this.height = settings.getAttribute("height").getIntValue();
            Attribute ATorientation = this.rootTemplate.getAttribute("orientation");
            String orientation = ATorientation != null ? ATorientation.getValue() : null;
            Rectangle pageSize = new Rectangle((float)this.width, (float)this.height);
            this.document = new com.lowagie.text.Document(pageSize);
            try {
                this.pdfWriter = PdfWriter.getInstance((com.lowagie.text.Document)this.document, (OutputStream)this.outPut);
                this.document.addTitle("outout.pdf");
                this.document.open();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            this.cb = this.pdfWriter.getDirectContent();
            this.g2d = this.cb.createGraphicsShapes((float)this.width, (float)this.height);
            if (orientation != null && "LANDSCAPE".equals(orientation)) {
                this.g2d.translate(this.width - 10, 0);
                this.g2d.rotate(1.5707963267948966);
            }
            this.objects.add(this.g2d);
            this.processMetadata(this.rootTemplate.getChild("metadata"));
            Iterator itTemplate = this.rootTemplate.getChildren("package").iterator();
            Iterator itTransact = this.rootTransact.getChildren("package").iterator();
            int countPacks = 0;
            while (itTemplate.hasNext() && itTransact.hasNext()) {
                boolean validate;
                Element elmTemplate = (Element)itTemplate.next();
                Element elmTransact = (Element)itTransact.next();
                Attribute attr = elmTemplate.getAttribute("validate");
                countPacks += elmTransact.getChildren().size();
                boolean bl = validate = attr != null ? attr.getBooleanValue() : false;
                if (validate) {
                    if (elmTransact.getChildren().size() <= 0) continue;
                    this.processElement(elmTemplate, elmTransact);
                    continue;
                }
                this.processElement(elmTemplate, elmTransact);
            }
            if (countPacks > 0) {
                this.successful = true;
                calendar = Calendar.getInstance();
                long end = calendar.getTimeInMillis();
                System.out.println("Generador en " + (end - init) + " milisegundos ");
            }
        }
        catch (DataConversionException e) {
            e.printStackTrace();
        }
        this.g2d.dispose();
        try {
            this.outPut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.document.close();
    }

    private void processMetadata(Element element) throws DataConversionException {
        for (Element e : element.getChildren()) {
            String name = e.getName();
            Iterator itAttribs = e.getAttributes().iterator();
            HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
            while (itAttribs.hasNext()) {
                Attribute attribute = (Attribute)itAttribs.next();
                attribs.put(attribute.getName(), attribute);
            }
            Attribute attr = (Attribute)attribs.get("row");
            boolean lrow = true;
            try {
                lrow = ((Attribute)attribs.get("incrementRow")).getBooleanValue();
            }
            catch (NullPointerException NPEe) {
                // empty catch block
            }
            int row = 0;
            String srow = attr.getValue();
            row = srow.equals("last") ? this.currentRow : Integer.valueOf(srow);
            int col = ((Attribute)attribs.get("col")).getIntValue();
            this.g2d.setStroke(stroke);
            if ("line".equals(name)) {
                int row2 = 0;
                String srow2 = ((Attribute)attribs.get("row2")).getValue();
                row2 = srow2.equals("last") ? row : Integer.parseInt(srow2);
                int col2 = ((Attribute)attribs.get("col2")).getIntValue();
                this.g2d.drawLine(col, row, col2, row2);
            } else if ("roundedRectangle".equals(name)) {
                int width = ((Attribute)attribs.get("width")).getIntValue();
                int height = ((Attribute)attribs.get("height")).getIntValue();
                this.g2d.draw(new RoundRectangle2D.Double(col, row, width, height, 10.0, 10.0));
            } else if ("rectangle".equals(name)) {
                int width = ((Attribute)attribs.get("width")).getIntValue();
                int height = ((Attribute)attribs.get("height")).getIntValue();
                this.g2d.drawRect(col, row, width, height);
            } else if ("field".equals(name)) {
                String value = e.getTextTrim();
                value = " ".equals(value) || "".equals(value) ? "  " : value;
                this.g2d.drawString(value, col, row);
            } else if ("ndocument".equals(name)) {
                String value = this.ndocument == null ? "" : this.ndocument;
                this.g2d.drawString(value, col, row);
            } else if ("pagenumber".equals(name)) {
                String value = String.valueOf(this.pageCount);
                this.g2d.drawString(value, col, row);
            } else if ("font".equals(name)) {
                this.g2d.setFont(new Font(((Attribute)attribs.get("name")).getValue(), 0, ((Attribute)attribs.get("size")).getIntValue()));
            } else if ("documentPrefix".equals(name)) {
                this.documentPrefix = e.getValue();
            } else if ("sqlData".equals(name)) {
                this.sqlData.add(new Query(e.getTextTrim(), col, row));
            }
            if (lrow) {
                this.currentRow = row + this.rowAcum;
                continue;
            }
            this.currentRow = row;
        }
        Iterator<Query> sqls = this.sqlData.iterator();
        if (this.ndocument != null) {
            System.out.println("ndocumento NO es nulo");
            Document request = null;
            while (sqls.hasNext()) {
                Query query = sqls.next();
                String sql = query.getSql();
                String[] args = new String[]{this.ndocument, this.documentPrefix};
                try {
                    request = TransactionServerResultSet.getResultSetST(sql, args);
                    Element rootElement = request.getRootElement();
                    Element row = rootElement.getChild("row");
                    String strVal = row.getChildText("col");
                    this.g2d.drawString(strVal, query.getX(), query.getY());
                    request = null;
                }
                catch (TransactionServerException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("ndocumento es nulo");
        }
    }

    private void processElement(Element pack_template, Element pack_transaction) throws DataConversionException {
        XMLOutputter xmlOutputter;
        System.out.println("template: ");
        try {
            xmlOutputter = new XMLOutputter();
            xmlOutputter.setFormat(Format.getPrettyFormat());
            xmlOutputter.output(pack_template, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("transaccion: ");
        try {
            xmlOutputter = new XMLOutputter();
            xmlOutputter.setFormat(Format.getPrettyFormat());
            xmlOutputter.output(pack_transaction, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator it_template = pack_template.getChildren().iterator();
        Iterator it_transaction = pack_transaction.getChildren().iterator();
        while (it_template.hasNext() && it_transaction.hasNext()) {
            Element el_template = (Element)it_template.next();
            if (el_template.getName().equals("subpackage")) {
                Element element;
                int rowInit = 0;
                String srowInit = el_template.getAttribute("rowInit").getValue();
                this.rowAcum = el_template.getAttribute("rowAcum").getIntValue();
                rowInit = srowInit.equals("last") ? this.currentRow + this.rowAcum : Integer.valueOf(srowInit);
                Attribute attMaxAcum = el_template.getAttribute("maxRowsAcum");
                int maxAcum = attMaxAcum != null ? attMaxAcum.getIntValue() : -1;
                Attribute attrowInitNewPage = el_template.getAttribute("rowInitNewPage");
                int rowInitNewPage = attrowInitNewPage != null ? attrowInitNewPage.getIntValue() : -1;
                Attribute attmaxRowsAcumNewPage = el_template.getAttribute("maxRowsAcumNewPage");
                int maxRowsAcumNewPage = attmaxRowsAcumNewPage != null ? attmaxRowsAcumNewPage.getIntValue() : -1;
                for (Element element2 : el_template.getChildren("metadata")) {
                    this.processMetadata(element2);
                    rowInit = this.currentRow;
                }
                Iterator it = el_template.getChildren("field").iterator();
                ArrayList AttCols = new ArrayList();
                while (it.hasNext()) {
                    HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
                    element = (Element)it.next();
                    for (Attribute attribute : element.getAttributes()) {
                        attribs.put(attribute.getName(), attribute);
                    }
                    AttCols.add(attribs);
                }
                while (it_transaction.hasNext() && maxAcum == -1 || rowInit < maxAcum) {
                    Element element3 = (Element)it_transaction.next();
                    Iterator iterator = element3.getChildren().iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        Element elmt = (Element)iterator.next();
                        Attribute att = new Attribute("row", String.valueOf(rowInit));
                        ((HashMap)AttCols.get(i)).put("row", att);
                        this.addValue(elmt.getValue(), (HashMap)AttCols.get(i));
                        ++i;
                    }
                    this.currentRow = rowInit += this.rowAcum;
                }
                if (!it_transaction.hasNext()) continue;
                System.out.println("Hojas Separadas por maximo numero de filas: " + maxAcum);
                int index = 0;
                while (it_transaction.hasNext()) {
                    ++index;
                    element = (Element)it_transaction.next();
                    Iterator iterator = element.getChildren().iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        Element elmt = (Element)iterator.next();
                        Attribute att = new Attribute("row", String.valueOf(rowInit));
                        ((HashMap)AttCols.get(i)).put("row", att);
                        this.addValue(elmt.getValue(), (HashMap)AttCols.get(i));
                        ++i;
                    }
                    this.currentRow = rowInit += this.rowAcum;
                    if (index != maxAcum) continue;
                    this.document.newPage();
                    rowInit = rowInitNewPage;
                    maxAcum = maxRowsAcumNewPage;
                    this.g2d = this.cb.createGraphicsShapes((float)this.width, (float)this.height);
                    this.processMetadata(this.rootTemplate.getChild("newpage"));
                    ++this.pageCount;
                    index = 0;
                }
                continue;
            }
            Element el_transaction = (Element)it_transaction.next();
            Iterator itAttribs = el_template.getAttributes().iterator();
            HashMap<String, Attribute> attribs = new HashMap<String, Attribute>();
            while (itAttribs.hasNext()) {
                Attribute attribute = (Attribute)itAttribs.next();
                attribs.put(attribute.getName(), attribute);
            }
            this.addValue(el_transaction.getValue(), attribs);
        }
    }

    private void addValue(String value, HashMap<String, Attribute> attribs) throws DataConversionException {
        String mask;
        Font newFont;
        if (attribs.size() == 0) {
            return;
        }
        int row = attribs.get("row").getIntValue() + this.rowNextPage;
        int col = attribs.get("col").getIntValue();
        Attribute attribute = attribs.get("type");
        Attribute fontSize = attribs.get("fontSize");
        Attribute fontName = attribs.get("fontName");
        String type = attribute != null ? attribute.getValue() : null;
        value = !"NULL".equals(value) && !"".equals(value) ? value : "";
        Font currentFont = this.g2d.getFont();
        if (fontSize != null && fontName != null) {
            newFont = new Font(fontName.getValue(), 0, fontSize.getIntValue());
            this.g2d.setFont(newFont);
        } else if (fontSize != null && fontName == null) {
            newFont = new Font(currentFont.getFamily(), 0, currentFont.getSize());
            this.g2d.setFont(newFont);
        }
        if ("TEXT".equals(type)) {
            int width = attribs.get("width").getIntValue();
            int height = attribs.get("height").getIntValue();
            int rowAcum = attribs.get("rowAcum").getIntValue();
            value = value.replaceAll("\n", " ");
            StringBuffer buf = new StringBuffer(value);
            int lastspace = -1;
            int linestart = 0;
            for (int i = 0; i < buf.length(); ++i) {
                if (buf.charAt(i) == ' ') {
                    lastspace = i;
                }
                if (buf.charAt(i) == '\n') {
                    lastspace = -1;
                    linestart = i + 1;
                }
                if (i <= linestart + width) continue;
                if (lastspace != -1) {
                    buf.delete(lastspace, lastspace + 1);
                    buf.insert(lastspace, "\n");
                    linestart = lastspace;
                    lastspace = -1;
                    continue;
                }
                buf.insert(i, '\n');
                linestart = i + 1;
            }
            StringTokenizer st = new StringTokenizer(buf.toString(), "\n");
            for (int j = 0; j < height && st.hasMoreElements(); ++j) {
                String tok = st.nextToken();
                this.g2d.drawString(tok, col, row);
                row += rowAcum;
            }
        } else if ("STRING".equals(type)) {
            Attribute atl = attribs.get("lengthFill");
            Attribute atf = attribs.get("charFill");
            if (atl != null && atf != null) {
                int lengthFill = atl.getIntValue();
                while (value.length() < lengthFill) {
                    value = value + atf.getValue();
                }
            }
            this.g2d.drawString(value, col, row);
        } else if ("DATE".equals(type)) {
            mask = attribs.get("mask").getValue();
            SimpleDateFormat sdf = new SimpleDateFormat(mask);
            Calendar c = Calendar.getInstance();
            int year = Integer.valueOf(value.substring(0, 4));
            int month = Integer.valueOf(value.substring(5, 7));
            int day = Integer.valueOf(value.substring(8, 10));
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, day);
            value = sdf.format(c.getTime());
            this.g2d.drawString(value, col, row);
        } else if ("NUMERIC".equals(type)) {
            mask = attribs.get("mask").getValue();
            DecimalFormat formatter = new DecimalFormat(mask);
            value = !"NULL".equals(value) && !"".equals(value) ? formatter.format(Double.parseDouble(value)) : "";
            FontMetrics m = this.g2d.getFontMetrics();
            this.g2d.drawString(value, col - m.stringWidth(value), row);
        } else if ("NUMTOLETTERS".equals(type)) {
            try {
                int width = attribs.get("width").getIntValue();
                int height = attribs.get("height").getIntValue();
                Double d = Double.parseDouble(value);
                String letters = String.valueOf(d.intValue());
                letters = NumberToLetterConversor.letters(letters, null);
                int rowAcum = attribs.get("rowAcum").getIntValue();
                value = value.replaceAll("\n", " ");
                StringBuffer buf = new StringBuffer(letters);
                int lastspace = -1;
                int linestart = 0;
                for (int i = 0; i < buf.length(); ++i) {
                    if (buf.charAt(i) == ' ') {
                        lastspace = i;
                    }
                    if (buf.charAt(i) == '\n') {
                        lastspace = -1;
                        linestart = i + 1;
                    }
                    if (i <= linestart + width) continue;
                    if (lastspace != -1) {
                        buf.delete(lastspace, lastspace + 1);
                        buf.insert(lastspace, "\n");
                        linestart = lastspace;
                        lastspace = -1;
                        continue;
                    }
                    buf.insert(i, '\n');
                    linestart = i + 1;
                }
                StringTokenizer st = new StringTokenizer(buf.toString(), "\n");
                for (int j = 0; j < height && st.hasMoreElements(); ++j) {
                    String tok = st.nextToken();
                    this.g2d.drawString(tok, col, row);
                    row += rowAcum;
                }
            }
            catch (NumberFormatException NFE) {
                System.out.printf("No se puede convertir %s  a letras\n%s", value, NFE.getMessage());
            }
        }
        this.g2d.setFont(currentFont);
    }

    @Override
    public synchronized void cathSuccesEvent(SuccessEvent e) {
        String numeration = e.getNdocument();
        if (numeration != null && !"".equals(numeration) && this.idTransaction.equals(e.getIdPackage())) {
            this.success = true;
            this.ndocument = numeration;
        }
    }

    @Override
    public PrintingManager.ImpresionType getImpresionType() {
        return this.impresionType;
    }

    @Override
    public ByteArrayInputStream getStream() {
        ByteArrayInputStream in = new ByteArrayInputStream(this.outPut.toByteArray());
        return in;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public void process(Element template, Element packages) {
        this.rootTemplate = template;
        this.rootTransact = packages;
        this.currentRow = 1;
        this.process();
    }

    public void setIdTransaction(String idTransaction) {
        this.idTransaction = idTransaction;
    }

    public String getNdocument() {
        return this.ndocument;
    }

    public void setNdocument(String lastNumber) {
        this.ndocument = lastNumber;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    class Query {
        private int x;
        private int y;
        private String sql;

        Query(String sql, int x, int y) {
            this.x = x;
            this.y = y;
            this.sql = sql;
        }

        protected String getSql() {
            return this.sql;
        }

        protected int getX() {
            return this.x;
        }

        protected int getY() {
            return this.y;
        }
    }
}

