/*
 * Decompiled with CFR 0.152.
 */
package common.printer;

import common.misc.CommonConstants;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TextPrinterBuffer {
    private ArrayList<StringBuilder> buffer = new ArrayList();

    public void insertTextArea(String text, int row, int col, Integer width, Integer height, boolean trim) {
        if (trim) {
            text = text.replaceAll("\n", " ");
        }
        StringBuffer buf = new StringBuffer(trim ? text.trim() : text);
        int lastspace = -1;
        int linestart = 0;
        if (trim) {
            for (int i = 0; i < buf.length(); ++i) {
                if (buf.charAt(i) == ' ') {
                    lastspace = i;
                }
                if (buf.charAt(i) == '\n') {
                    lastspace = -1;
                    linestart = i + 1;
                }
                if (i <= linestart + width) continue;
                if (lastspace != -1) {
                    buf.delete(lastspace, lastspace + 1);
                    buf.insert(lastspace, "\n");
                    linestart = lastspace;
                    lastspace = -1;
                    continue;
                }
                buf.insert(i, '\n');
                linestart = i + 1;
            }
        }
        StringTokenizer st = new StringTokenizer(buf.toString(), "\n");
        for (int j = 0; j < height && st.hasMoreElements(); ++j) {
            String tok = st.nextToken();
            this.insertString(tok, row++, col, null);
        }
    }

    public void insertString(String str, int row, int col, Integer width) throws ArrayIndexOutOfBoundsException {
        int i;
        if (row == 0 || col == 0 || str == null || "".equals(str)) {
            return;
        }
        if (row > this.buffer.size()) {
            while (row > this.buffer.size()) {
                this.buffer.add(new StringBuilder());
            }
        }
        if (col - 1 > this.buffer.get(row - 1).length()) {
            String string = "";
            for (i = 0; i < col - 1 - this.buffer.get(row - 1).length(); ++i) {
                string = string + " ";
            }
            this.buffer.get(row - 1).insert(this.buffer.get(row - 1).length(), string);
        }
        String fill = "";
        if (width != null) {
            for (i = 0; i < width - str.length(); ++i) {
                fill = fill + " ";
            }
        }
        str = fill + str;
        if (row < this.buffer.size() && col - 1 < this.buffer.get(row - 1).length()) {
            this.buffer.get(row - 1).replace(col - 1, str.length() + (col - 1), str);
        } else {
            this.buffer.get(row - 1).insert(col - 1, str);
        }
    }

    public String getBufferString() {
        return this.getBufferString(true);
    }

    public String getBufferString(boolean endofline) {
        StringBuilder string = new StringBuilder();
        if (endofline) {
            int i;
            for (i = 0; i < this.buffer.size() - 1; ++i) {
                string.append(this.buffer.get(i) + "\n");
            }
            if (this.buffer.size() > 0) {
                string.append((CharSequence)this.buffer.get(i));
            }
        }
        return string.toString();
    }

    public ByteArrayInputStream getStream() {
        return new ByteArrayInputStream(this.getBufferString().getBytes());
    }

    public String Convert(String key) {
        try {
            int Int = CommonConstants.ScpCodes.containsKey(key) ? CommonConstants.ScpCodes.get(key) : Integer.parseInt(key);
            return String.valueOf((char)Int);
        }
        catch (NumberFormatException NFEe) {
            NFEe.printStackTrace();
            return null;
        }
    }

    public void clear() {
        this.buffer.clear();
        this.buffer = null;
        this.buffer = new ArrayList();
    }
}

