/*
 * Decompiled with CFR 0.152.
 */
package common.printer.plainViewer;

import common.gui.forms.GenericForm;
import common.misc.CommonConstants;
import common.misc.language.Language;
import common.printer.PrintingManager;
import common.printer.plainViewer.TextReportUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PlainReportPrinterDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -2549815723035494574L;
    JComboBox printers;
    Vector<String> printerNames;
    JTextField pages;
    JTextField copiesTF;
    JRadioButton all;
    JRadioButton range;
    Vector<ByteArrayOutputStream> printerViews;
    int pagesTotal = 0;
    int copiesTotal = 0;
    String printer;
    int charactersPerLine;

    public PlainReportPrinterDialog(GenericForm parent, int pagesTotal, Vector<ByteArrayOutputStream> printerViews, int charactersPerLine) {
        this.printerViews = printerViews;
        this.pagesTotal = pagesTotal;
        this.charactersPerLine = charactersPerLine;
        this.setTitle(Language.getWord("PRINTER_OP"));
        this.setAlwaysOnTop(true);
        this.printerNames = new Vector();
        for (PrintService ps : PrintServiceLookup.lookupPrintServices(null, null)) {
            this.printerNames.add(ps.getName());
        }
        CommonConstants.lookupDefaultPrintService();
        JLabel printerName = new JLabel(Language.getWord("PRINTER_NAME"));
        this.printers = new JComboBox<String>(this.printerNames);
        JButton accept = new JButton(Language.getWord("ACCEPT"));
        accept.addActionListener(this);
        accept.setActionCommand("PRINT");
        JButton cancel = new JButton(Language.getWord("CANCEL"));
        cancel.addActionListener(this);
        cancel.setActionCommand("CLOSE");
        ButtonGroup rangeGroup = new ButtonGroup();
        this.all = new JRadioButton(Language.getWord("ALL"));
        this.all.setSelected(true);
        this.range = new JRadioButton(Language.getWord("RANGE"));
        rangeGroup.add(this.all);
        rangeGroup.add(this.range);
        this.pages = new JTextField(14);
        JLabel copies = new JLabel(Language.getWord("COPIES"));
        this.copiesTF = new JTextField("1", 2);
        JPanel base = new JPanel();
        base.setLayout(new BorderLayout());
        JPanel upSide = new JPanel();
        upSide.setLayout(new FlowLayout());
        upSide.add(printerName);
        upSide.add(this.printers);
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new BorderLayout());
        westPanel.add((Component)upSide, "West");
        JPanel rangeLinePanel = new JPanel();
        rangeLinePanel.setLayout(new FlowLayout());
        rangeLinePanel.add(this.pages);
        JLabel proof = new JLabel(" ");
        JPanel panel = new JPanel();
        panel.add(proof);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.add(panel);
        rightPanel.add(rangeLinePanel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(this.all);
        leftPanel.add(this.range);
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new FlowLayout());
        gridPanel.add(leftPanel);
        gridPanel.add(rightPanel);
        JPanel copiesPanel = new JPanel();
        copiesPanel.setLayout(new FlowLayout());
        copiesPanel.add(copies);
        copiesPanel.add(this.copiesTF);
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BorderLayout());
        eastPanel.add((Component)copiesPanel, "East");
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout());
        center.add((Component)gridPanel, "Center");
        center.add((Component)eastPanel, "South");
        center.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Language.getWord("PRINTING_AREA")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), center.getBorder()));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(accept);
        buttons.add(cancel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BorderLayout());
        buttonsPanel.add((Component)buttons, "East");
        base.add((Component)westPanel, "North");
        base.add((Component)center, "Center");
        base.add((Component)buttonsPanel, "South");
        this.add(base);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("CLOSE")) {
            this.setVisible(false);
            return;
        }
        if (e.getActionCommand().equals("PRINT")) {
            String errorMessage = Language.getWord("BAD_RANGE");
            this.printer = (String)this.printers.getSelectedItem();
            String copiesNum = this.copiesTF.getText();
            if (!TextReportUtils.isNumber(copiesNum)) {
                this.copiesTF.setText("1");
                this.copiesTF.requestFocus();
                JOptionPane.showMessageDialog(this, Language.getWord("BAD_COPIES"), Language.getWord("ERROR"), 0);
                return;
            }
            this.copiesTotal = Integer.parseInt(copiesNum);
            if (this.all.isSelected()) {
                this.setVisible(false);
                for (int i = 0; i < this.copiesTotal; ++i) {
                    this.printPagesRange(0, this.pagesTotal - 1);
                }
            } else {
                String secuence = this.pages.getText();
                if (secuence.length() == 0) {
                    this.pages.setText("");
                    this.pages.requestFocus();
                    JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                    return;
                }
                StringTokenizer tokens = new StringTokenizer(secuence, ",");
                int parameters = tokens.countTokens();
                Vector<int[]> pairs = new Vector<int[]>();
                if (parameters > 0) {
                    while (tokens.hasMoreTokens()) {
                        String miniRange = tokens.nextToken();
                        int[] numbers = new int[2];
                        if (miniRange.indexOf("-") != -1) {
                            StringTokenizer split = new StringTokenizer(miniRange, "-");
                            int j = 0;
                            while (split.hasMoreTokens()) {
                                String limit = split.nextToken();
                                if (limit.length() > 0) {
                                    if (TextReportUtils.isNumber(limit)) {
                                        numbers[j] = Integer.parseInt(limit);
                                        ++j;
                                        continue;
                                    }
                                    JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                                    return;
                                }
                                JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                                return;
                            }
                            if (j > 2) {
                                JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                                return;
                            }
                            if (numbers[0] > numbers[1]) {
                                JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                                return;
                            }
                            pairs.add(numbers);
                            continue;
                        }
                        if (TextReportUtils.isNumber(miniRange)) {
                            int index;
                            numbers[0] = index = Integer.parseInt(miniRange);
                            numbers[1] = index;
                            pairs.add(numbers);
                            continue;
                        }
                        JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                        return;
                    }
                    for (int i = 0; i < pairs.size(); ++i) {
                        int[] indexes = (int[])pairs.get(i);
                        if (indexes[0] == indexes[1]) {
                            this.printOnePage(indexes[0] - 1);
                            continue;
                        }
                        this.printPagesRange(indexes[0] - 1, indexes[1] - 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, errorMessage, Language.getWord("ERROR"), 0);
                    return;
                }
            }
            return;
        }
    }

    public void printPagesRange(int firstPage, int lastPage) {
        for (int i = firstPage; i <= lastPage; ++i) {
            this.printOnePage(i);
        }
    }

    public void printOnePage(int index) {
        ByteArrayOutputStream byteArray = this.printerViews.elementAt(index);
        String text = byteArray.toString();
        String pageFooter = TextReportUtils.getRightAlignedString(Language.getWord("PAGE") + " " + (index + 1) + " " + Language.getWord("OF") + " " + this.pagesTotal, this.charactersPerLine);
        text = text + pageFooter;
        ByteArrayInputStream currentPage = new ByteArrayInputStream(text.getBytes());
        try {
            new PrintingManager(PrintingManager.ImpresionType.PLAIN, currentPage, true, 1, this.printer, 0, 0);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
    }
}

