/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;
import server.businessrules.CacheKeys;
import server.businessrules.LNDocuments;
import server.businessrules.LNErrorProcecuteException;
import server.businessrules.LNUndoSaldos;
import server.database.sql.DontHaveKeyException;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNContabilidad {
    private Vector<String> colData;
    private Vector<String> colAccount;
    private int colIdProdServ = -1;
    private Vector<String> accountFields;
    private Vector<String> typeRegister;
    private int accountData;
    private int accountKey = -1;
    private int accountTh = -1;
    private int accountPS = -1;
    private Boolean naturaleza;
    private String bd;
    private String codeAPS;
    private String concepto = "SOY UN LAMER QUE NO DEFINI EL CONCEPTO";
    private String tercero;
    private String inventario;
    private String centroCosto;
    private double base;
    private int colCost = -1;
    private boolean debug;
    private final boolean LIBRO_AUX_INV = false;
    private final boolean LIBRO_AUX_TER = true;

    public LNContabilidad(String bd) {
        this.bd = bd;
    }

    public LNContabilidad(Element parameters, String bd) {
        this.bd = bd;
        this.colData = new Vector();
        this.colAccount = new Vector();
        this.accountFields = new Vector();
        this.typeRegister = new Vector();
        for (Element e : parameters.getChildren()) {
            String attribute = e.getAttributeValue("attribute");
            if (attribute != null) {
                attribute = attribute.toLowerCase();
            }
            if ("codeaps".equals(attribute)) {
                this.codeAPS = e.getValue();
                continue;
            }
            if ("base".equals(attribute)) {
                try {
                    this.base = 0.0;
                }
                catch (NumberFormatException NFEe) {
                    this.base = 0.0;
                }
                continue;
            }
            if ("concepto".equals(attribute)) {
                this.concepto = e.getValue().trim();
                continue;
            }
            if ("naturaleza".equals(attribute)) {
                if ("d".equals(e.getValue()) || "D".equals(e.getValue())) {
                    this.naturaleza = new Boolean("true");
                    continue;
                }
                if (!"c".equals(e.getValue()) && !"C".equals(e.getValue())) continue;
                this.naturaleza = new Boolean("false");
                continue;
            }
            if ("debuging".equals(attribute)) {
                this.debug = Boolean.parseBoolean(e.getValue());
                continue;
            }
            if ("tercero".equals(attribute)) {
                this.tercero = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("inventario".equals(attribute)) {
                this.inventario = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("centrocosto".equals(attribute)) {
                this.centroCosto = e.getValue().toLowerCase().trim();
                continue;
            }
            if (!"subarg".equals(e.getName())) continue;
            for (Element f : e.getChildren()) {
                String col;
                String account;
                StringTokenizer STval;
                if ("accountCol".equals(f.getAttributeValue("attribute"))) {
                    try {
                        STval = new StringTokenizer(f.getValue(), ",");
                        account = STval.nextToken();
                        col = STval.nextToken();
                        this.colData.addElement(col);
                        System.out.println("Account: " + col);
                        if (account.equals("getName")) {
                            System.out.println("Desde getName " + CacheKeys.getKey("account"));
                            this.colAccount.addElement(CacheKeys.getKey("account"));
                            continue;
                        }
                        System.out.println("Su valor...");
                        this.colAccount.addElement(account);
                    }
                    catch (NoSuchElementException NSEEe) {
                        NSEEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountCostCol".equals(f.getAttributeValue("attribute"))) {
                    try {
                        STval = new StringTokenizer(f.getValue(), ",");
                        account = STval.nextToken();
                        col = STval.nextToken();
                        this.colData.addElement(col);
                        this.colAccount.addElement(account);
                        try {
                            this.colCost = Integer.parseInt(col);
                        }
                        catch (NumberFormatException NFEe) {
                            this.colCost = -1;
                        }
                    }
                    catch (NoSuchElementException NSEEe) {
                        NSEEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountField".equals(f.getAttributeValue("attribute"))) {
                    try {
                        STval = new StringTokenizer(f.getValue(), ",");
                        account = STval.nextToken();
                        String register = STval.nextToken();
                        this.accountFields.addElement(account);
                        this.typeRegister.addElement(register);
                    }
                    catch (NoSuchElementException NSEEe) {
                        NSEEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountKey".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountKey = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountKey = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountTh".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountTh = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountTh = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountPS".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountPS = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountPS = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if (!"accountData".equals(f.getAttributeValue("attribute"))) continue;
                try {
                    this.accountData = Integer.parseInt(f.getValue());
                }
                catch (NumberFormatException NFEe) {
                    this.accountData = 0;
                    NFEe.printStackTrace();
                }
            }
        }
    }

    public double fieldData(Element pack) throws DontHaveKeyException, SQLNotFoundException, SQLBadArgumentsException, SQLException {
        double partidaDoble = 0.0;
        Iterator ipack = pack.getChildren().iterator();
        for (int i = 0; i < this.accountFields.size(); ++i) {
            double baseAccount;
            double valueAccount;
            String account = this.accountFields.get(i);
            Element element = (Element)ipack.next();
            String value = element.getValue();
            try {
                valueAccount = Double.parseDouble(value);
            }
            catch (NumberFormatException NFEe) {
                valueAccount = 0.0;
            }
            if (valueAccount == 0.0 || !((baseAccount = LinkingCache.getPCBase(this.bd, account.trim())) >= this.base)) continue;
            String type = this.typeRegister.get(i);
            boolean debito = type.equals("D") || type.equals("d");
            if (valueAccount < 0.0) {
                valueAccount = Math.abs(valueAccount);
                debito = !debito;
            }
            String idCta = LinkingCache.getPCIdCta(this.bd, account);
            if (LinkingCache.isPCTerceros(this.bd, account)) {
                this.asientosConTipo(idCta, valueAccount, CacheKeys.getKey("idTercero"), debito, true, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCInventarios(this.bd, account)) {
                this.asientosConTipo(idCta, valueAccount, CacheKeys.getKey("idProdServ"), debito, false, LinkingCache.isPCNaturaleza(this.bd, account));
            } else {
                this.asientosDetalle(idCta, valueAccount, debito, LinkingCache.isPCNaturaleza(this.bd, account));
            }
            if (debito) {
                partidaDoble += valueAccount;
                continue;
            }
            partidaDoble -= valueAccount;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(partidaDoble);
            bigDecimal = bigDecimal.setScale(2, 4);
            partidaDoble = bigDecimal.doubleValue();
        }
        catch (NumberFormatException NFEe) {
            // empty catch block
        }
        return partidaDoble;
    }

    public double rowDataAccount(Element pack) throws DontHaveKeyException, SQLException, SQLNotFoundException, SQLBadArgumentsException {
        double valor;
        double partidaDoble = 0.0;
        Iterator i = pack.getChildren().iterator();
        String[] asiento = new String[10];
        asiento[0] = CacheKeys.getKey("ndocumento");
        asiento[1] = CacheKeys.getDate();
        asiento[2] = this.concepto;
        for (int k = 3; i.hasNext() && k < asiento.length; ++k) {
            Element elm2;
            if (k == 3 && this.centroCosto != null) {
                asiento[k] = this.centroCosto.equals("getname") && CacheKeys.getKey("centrocosto") != null ? CacheKeys.getKey("centrocosto") : (this.centroCosto.equals("notdata") ? "NULL" : "NULL");
            } else if (k == 5) {
                elm2 = (Element)i.next();
                asiento[k] = "NULL";
                if (LinkingCache.isPCTerceros(this.bd, asiento[4])) {
                    if (!"".equals(elm2.getText())) {
                        asiento[k] = elm2.getText().trim();
                    } else if ("getname".equals(this.tercero) && CacheKeys.getKey("idTercero") != null) {
                        asiento[k] = CacheKeys.getKey("idTercero");
                    } else if (this.tercero.equals("notdata")) {
                        asiento[k] = "NULL";
                    }
                }
            } else if (k == 6 && this.inventario != null) {
                asiento[k] = this.inventario.equals("getname") && CacheKeys.getKey("inventario") != null && LinkingCache.isPCInventarios(this.bd, asiento[4]) ? CacheKeys.getKey("inventario") : (this.inventario.equals("notdata") ? "NULL" : "NULL");
            } else {
                elm2 = (Element)i.next();
                asiento[k] = elm2.getText().trim();
            }
            if (!this.debug) continue;
            System.out.println("asiento[" + k + "] = " + asiento[k]);
        }
        double debito = Double.parseDouble(asiento[7]);
        double credito = Double.parseDouble(asiento[8]);
        if (debito < 0.0) {
            asiento[7] = "0";
            asiento[8] = String.valueOf(this.roundValue(Math.abs(debito)));
        } else if (credito < 0.0) {
            asiento[7] = String.valueOf(this.roundValue(Math.abs(credito)));
            asiento[8] = "0";
        }
        if (this.debug) {
            System.out.println("debito: [" + asiento[7] + "]  credito: [" + asiento[8] + "]");
        }
        if ((valor = Double.parseDouble(asiento[7]) + Double.parseDouble(asiento[8])) > 0.0) {
            if (this.debug) {
                System.out.println("generando ...");
            }
            asiento[4] = LinkingCache.getPCIdCta(this.bd, asiento[4]);
            double saldo = LinkingCache.getSaldoLibroAux(this.bd, asiento[3].equals("NULL") ? "" : asiento[3], asiento[4], asiento[5].equals("NULL") ? "" : asiento[5], asiento[6].equals("NULL") ? "" : asiento[6]);
            double movimiento = 0.0;
            if (Double.parseDouble(asiento[7]) != 0.0) {
                movimiento = Double.parseDouble(asiento[7]);
                double nsaldo = saldo + movimiento;
                asiento[9] = String.valueOf(nsaldo);
                partidaDoble += movimiento;
                LNUndoSaldos.setSaldoAntLibroAux(this.bd, asiento[3].equals("NULL") ? "" : asiento[3], asiento[4], asiento[5].equals("NULL") ? "" : asiento[5], asiento[6].equals("NULL") ? "" : asiento[6], new Double(saldo));
                LinkingCache.setSaldoLibroAux(this.bd, asiento[3].equals("NULL") ? "" : asiento[3], asiento[4], asiento[5].equals("NULL") ? "" : asiento[5], asiento[6].equals("NULL") ? "" : asiento[6], new Double(nsaldo));
            } else {
                movimiento = Double.parseDouble(asiento[8]);
                double nsaldo = saldo - movimiento;
                asiento[9] = String.valueOf(nsaldo);
                partidaDoble -= movimiento;
                try {
                    BigDecimal bigDecimal = new BigDecimal(partidaDoble);
                    bigDecimal = bigDecimal.setScale(2, 4);
                    partidaDoble = bigDecimal.doubleValue();
                }
                catch (NumberFormatException NFEe) {
                    // empty catch block
                }
                if (this.debug) {
                    System.out.println("Movimiento: " + movimiento + " Partida doble rowDataAccount: " + partidaDoble);
                }
                LNUndoSaldos.setSaldoAntLibroAux(this.bd, asiento[3].equals("NULL") ? "" : asiento[3], asiento[4], asiento[5].equals("NULL") ? "" : asiento[5], asiento[6].equals("NULL") ? "" : asiento[6], new Double(saldo));
                LinkingCache.setSaldoLibroAux(this.bd, asiento[3].equals("NULL") ? "" : asiento[3], asiento[4], asiento[5].equals("NULL") ? "" : asiento[5], asiento[6].equals("NULL") ? "" : asiento[6], new Double(nsaldo));
            }
            new QueryRunner(this.bd, "SCI0014", asiento).ejecutarSQL();
        }
        return partidaDoble;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double columDataAccount(Element pack) throws DontHaveKeyException, SQLNotFoundException, SQLBadArgumentsException, SQLException, LNErrorProcecuteException {
        double partidaDoble = 0.0;
        String idCta = "";
        String value = "";
        double valueAccount = 0.0;
        List lpack = pack.getChildren();
        this.naturaleza.booleanValue();
        if (this.accountKey == -1) throw new LNErrorProcecuteException("");
        String charCta = ((Element)lpack.get(this.accountKey)).getValue();
        value = ((Element)lpack.get(this.accountData)).getValue();
        idCta = LinkingCache.getPCIdCta(this.bd, charCta.trim());
        try {
            valueAccount = Double.parseDouble(value);
        }
        catch (NumberFormatException NFEe) {
            valueAccount = 0.0;
        }
        if (valueAccount != 0.0) {
            if (valueAccount < 0.0) {
                valueAccount = Math.abs(valueAccount);
                this.naturaleza = this.naturaleza == false;
            }
            if (LinkingCache.isPCTerceros(this.bd, charCta.trim())) {
                if (this.accountTh >= 0) {
                    this.asientosConTipo(idCta, valueAccount, ((Element)lpack.get(this.accountTh)).getValue(), this.naturaleza, true, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
                } else {
                    if (!"getname".equals(this.tercero)) throw new LNErrorProcecuteException("");
                    if (CacheKeys.getKey("idTercero") == null) throw new LNErrorProcecuteException("");
                    this.asientosConTipo(idCta, valueAccount, CacheKeys.getKey("idTercero"), this.naturaleza, true, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
                }
            } else if (LinkingCache.isPCInventarios(this.bd, charCta.trim())) {
                if (this.accountPS < 0) throw new LNErrorProcecuteException("");
                this.asientosConTipo(idCta, valueAccount, ((Element)lpack.get(this.accountPS)).getValue(), this.naturaleza, false, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
            } else {
                this.asientosDetalle(idCta, valueAccount, this.naturaleza, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
            }
            partidaDoble = this.naturaleza.booleanValue() ? (partidaDoble += valueAccount) : (partidaDoble -= valueAccount);
            if (this.debug) {
                System.out.println("partida doble columnDataAccount: " + partidaDoble);
            }
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(partidaDoble);
            bigDecimal = bigDecimal.setScale(2, 4);
            return bigDecimal.doubleValue();
        }
        catch (NumberFormatException NFEe) {
            // empty catch block
        }
        return partidaDoble;
    }

    public double columnData(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        double partidaDoble = 0.0;
        List colElement = pack.getChildren();
        for (int k = 0; k < this.colData.size(); ++k) {
            double valueAccount;
            int col = Integer.parseInt(this.colData.get(k));
            Element element = (Element)colElement.get(col);
            String value = element.getValue();
            try {
                valueAccount = Double.parseDouble(value);
            }
            catch (NumberFormatException NFEe) {
                valueAccount = 0.0;
            }
            String idProdServ = "";
            boolean debito = false;
            String account = this.colAccount.get(k);
            System.out.println("cuenta: " + account);
            if (this.getColIdProdServ() > -1) {
                Element eIdProdServ = (Element)colElement.get(this.getColIdProdServ());
                idProdServ = eIdProdServ.getText();
            } else {
                idProdServ = "";
            }
            boolean cuentaregistrada = true;
            if (this.naturaleza == null) {
                String code = LinkingCache.getIdAsientosPr(this.bd, idProdServ, this.codeAPS);
                try {
                    debito = LinkingCache.isAsientoDebito(this.bd, code, account);
                }
                catch (DontHaveKeyException DHKEe) {
                    cuentaregistrada = false;
                }
            } else {
                debito = this.naturaleza;
            }
            if (this.debug) {
                System.out.println("La cuenta a procesar es: " + account);
                System.out.println("La cuenta esta registrada: " + cuentaregistrada);
                System.out.println("Valor del movimiento: " + valueAccount);
            }
            if (valueAccount == 0.0 || "IdProdServ".equals(account.trim()) || !cuentaregistrada) continue;
            double baseAccount = LinkingCache.getPCBase(this.bd, account.trim());
            if (valueAccount < 0.0) {
                valueAccount = Math.abs(valueAccount);
                boolean bl = debito = !debito;
            }
            if (!(baseAccount >= this.base)) continue;
            String idCta = LinkingCache.getPCIdCta(this.bd, account);
            if (LinkingCache.isPCInventarios(this.bd, account)) {
                if (this.colCost == col) {
                    String bodega = "";
                    bodega = CacheKeys.getKey("bodegaSaliente") != null ? CacheKeys.getKey("bodegaSaliente") : CacheKeys.getKey("bodegaEntrante");
                    valueAccount = valueAccount == LinkingCache.getSaldoInventario(this.bd, bodega, idProdServ) ? LinkingCache.getVSaldoInventario(this.bd, bodega, idProdServ) : (valueAccount *= LinkingCache.getPCosto(this.bd, bodega, idProdServ));
                    try {
                        BigDecimal bigDecimal = new BigDecimal(valueAccount);
                        bigDecimal = bigDecimal.setScale(2, 4);
                        valueAccount = bigDecimal.doubleValue();
                    }
                    catch (NumberFormatException NFEe) {
                        // empty catch block
                    }
                }
                this.asientosConTipo(idCta, valueAccount, idProdServ, debito, false, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCTerceros(this.bd, account)) {
                String idTercero = CacheKeys.getKey("idTercero");
                if (idTercero == null) {
                    idTercero = this.tercero;
                }
                this.asientosConTipo(idCta, valueAccount, idTercero, debito, true, LinkingCache.isPCNaturaleza(this.bd, account));
            } else {
                this.asientosDetalle(idCta, valueAccount, debito, LinkingCache.isPCNaturaleza(this.bd, account));
            }
            partidaDoble = debito ? (partidaDoble += valueAccount) : (partidaDoble -= valueAccount);
            try {
                BigDecimal bigDecimal = new BigDecimal(partidaDoble);
                bigDecimal = bigDecimal.setScale(2, 4);
                partidaDoble = bigDecimal.doubleValue();
            }
            catch (NumberFormatException NFEe) {
                // empty catch block
            }
            if (!this.debug) continue;
            System.out.println("partida doble columnData:" + partidaDoble);
        }
        return partidaDoble;
    }

    private int getColIdProdServ() {
        if (this.colIdProdServ == -1) {
            for (int i = 0; i < this.colAccount.size(); ++i) {
                if (!this.colAccount.get(i).equals("IdProdServ")) continue;
                this.colIdProdServ = i;
                return this.colIdProdServ;
            }
            return -1;
        }
        return this.colIdProdServ;
    }

    private void asientosConTipo(String idCta, double value, String idTipo, boolean debito, boolean tipo, boolean natCta) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        QueryRunner RQsalidas;
        double nsaldo;
        double saldo;
        if (!tipo) {
            saldo = LinkingCache.getSaldoLibroAux(this.bd, "", idCta, "", idTipo);
            LNUndoSaldos.setSaldoAntLibroAux(this.bd, "", idCta, "", idTipo, new Double(saldo));
        } else {
            saldo = LinkingCache.getSaldoLibroAux(this.bd, "", idCta, idTipo, "");
            LNUndoSaldos.setSaldoAntLibroAux(this.bd, "", idCta, idTipo, "", new Double(saldo));
        }
        String[] asiento = new String[8];
        asiento[0] = idCta;
        asiento[1] = idTipo;
        asiento[2] = CacheKeys.getDate();
        asiento[3] = this.concepto;
        asiento[4] = CacheKeys.getKey("ndocumento");
        if (debito) {
            asiento[5] = String.valueOf(value);
            asiento[6] = "0";
            nsaldo = natCta ? saldo + value : saldo - value;
        } else {
            asiento[5] = "0";
            asiento[6] = String.valueOf(value);
            nsaldo = natCta ? saldo - value : saldo + value;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(nsaldo);
            bigDecimal = bigDecimal.setScale(2, 4);
            nsaldo = bigDecimal.doubleValue();
        }
        catch (NumberFormatException NFEe) {
            // empty catch block
        }
        asiento[7] = String.valueOf(nsaldo);
        if (this.debug) {
            System.out.println("Datos a almacenar");
            for (int i = 0; i < asiento.length; ++i) {
                System.out.println("Campo " + i + ": " + asiento[i]);
            }
        }
        if (!tipo) {
            LinkingCache.setSaldoLibroAux(this.bd, "", idCta, "", idTipo, new Double(nsaldo));
            RQsalidas = new QueryRunner(this.bd, "SCI00O7", asiento);
        } else {
            LinkingCache.setSaldoLibroAux(this.bd, "", idCta, idTipo, "", new Double(nsaldo));
            RQsalidas = new QueryRunner(this.bd, "SCI00O6", asiento);
        }
        RQsalidas.ejecutarSQL();
    }

    private void asientosDetalle(String idCta, double value, boolean debito, boolean natCta) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        double nsaldo;
        double saldo = LinkingCache.getSaldoLibroAux(this.bd, "", idCta, "", "");
        LNUndoSaldos.setSaldoAntLibroAux(this.bd, "", idCta, "", "", new Double(saldo));
        String[] asiento = new String[7];
        asiento[0] = idCta;
        asiento[1] = CacheKeys.getDate();
        asiento[2] = this.concepto;
        asiento[3] = CacheKeys.getKey("ndocumento");
        if (debito) {
            asiento[4] = String.valueOf(value);
            asiento[5] = "0";
            nsaldo = natCta ? saldo + value : saldo - value;
        } else {
            asiento[4] = "0";
            asiento[5] = String.valueOf(value);
            nsaldo = natCta ? saldo - value : saldo + value;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(nsaldo);
            bigDecimal = bigDecimal.setScale(2, 4);
            nsaldo = bigDecimal.doubleValue();
        }
        catch (NumberFormatException NFEe) {
            // empty catch block
        }
        asiento[6] = String.valueOf(nsaldo);
        LinkingCache.setSaldoLibroAux(this.bd, "", idCta, "", "", new Double(nsaldo));
        QueryRunner RQsalidas = new QueryRunner(this.bd, "SCI00O5", asiento);
        RQsalidas.ejecutarSQL();
    }

    public void anular() throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String idDocumento = CacheKeys.getKey("ndocumento");
        QueryRunner RQdocumento = new QueryRunner(this.bd, "SCS0052", new String[]{idDocumento});
        ResultSet RSdatos = RQdocumento.ejecutarSELECT();
        QueryRunner RQanular = new QueryRunner(this.bd, "SCU0005", new String[]{idDocumento});
        RQanular.ejecutarSQL();
        while (RSdatos.next()) {
            String idTercero = RSdatos.getString(3) == null ? "-1" : RSdatos.getString(3);
            String idProducto = RSdatos.getString(4) == null ? "-1" : RSdatos.getString(4);
            this.recoverData(RSdatos.getString(1), RSdatos.getString(2), idTercero, idProducto);
        }
        RSdatos.close();
        RQdocumento.closeStatement();
    }

    public void recoverDocument() throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdocument = new QueryRunner(this.bd, "SCS0081", new String[]{CacheKeys.getKey("ndocumento")});
        ResultSet RSdocument = RQdocument.ejecutarSELECT();
        System.out.println("Recalculando editados");
        while (RSdocument.next()) {
            String idTercero = RSdocument.getString(3) == null ? "-1" : RSdocument.getString(3);
            String idProducto = RSdocument.getString(4) == null ? "-1" : RSdocument.getString(4);
            this.recoverData(RSdocument.getString(1), RSdocument.getString(2), idTercero, idProducto);
        }
        QueryRunner RQdropDocument = new QueryRunner(this.bd, "SCS0086", new String[]{CacheKeys.getKey("ndocumento")});
        ResultSet RSdropDocument = RQdropDocument.ejecutarSELECT();
        System.out.println("Recalculando los elimiandos");
        while (RSdropDocument.next()) {
            String idTercero = RSdropDocument.getString(3) == null ? "-1" : RSdropDocument.getString(3);
            String idProducto = RSdropDocument.getString(4) == null ? "-1" : RSdropDocument.getString(4);
            this.recoverData(RSdropDocument.getString(1), RSdropDocument.getString(2), idTercero, idProducto);
        }
        QueryRunner RQdpDocument = new QueryRunner(this.bd, "SCD0004", new String[0]);
        RQdpDocument.ejecutarSQL();
        RQdocument.closeStatement();
        RSdocument.close();
        RQdropDocument.closeStatement();
        RSdropDocument.close();
        RQdpDocument.closeStatement();
    }

    public void recoverCost(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdocument = new QueryRunner(this.bd, "SCS0087");
        ResultSet RSdocument = RQdocument.ejecutarSELECT();
        System.out.println("Recalculando costeo");
        while (RSdocument.next()) {
            this.recoverData(null, RSdocument.getString(1), RSdocument.getString(2), RSdocument.getString(3));
        }
        RSdocument.close();
        RQdocument.closeStatement();
    }

    public void recover(Element pack) {
        Iterator i = pack.getChildren().iterator();
        String fecha = null;
        String idCta = CacheKeys.getKey("idCta");
        String idTercero = CacheKeys.getKey("idTercero");
        String idProducto = CacheKeys.getKey("idProducto");
        while (i.hasNext()) {
            Element field = (Element)i.next();
            String nameField = field.getAttributeValue("name");
            if ("fecha".equals(nameField = nameField.toLowerCase())) {
                fecha = field.getText();
                continue;
            }
            if ("idcta".equals(nameField)) {
                idCta = field.getText();
                continue;
            }
            if ("idtercero".equals(nameField)) {
                idTercero = field.getText();
                continue;
            }
            if (!"idproducto".equals(nameField)) continue;
            idProducto = field.getText();
        }
        this.recoverData(fecha, idCta, idTercero, idProducto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverData(String fecha, String idCta, String idTercero, String idProducto) {
        double saldoAnt = 0.0;
        QueryRunner RQsaldo = null;
        QueryRunner RQdata = null;
        ResultSet RSsaldo = null;
        ResultSet RSdata = null;
        QueryRunner RQnaturaleza = null;
        ResultSet RSnaturaleza = null;
        QueryRunner RQupdate = null;
        try {
            if (LNDocuments.getActionDocument().equals("editDocument") || LNDocuments.getActionDocument().equals("deleteDocument")) {
                fecha = CacheKeys.getMinDate();
            }
            if (fecha != null) {
                RQsaldo = new QueryRunner(this.bd, "SCS0074", new String[]{fecha, idCta, idTercero, idProducto});
                RQdata = new QueryRunner(this.bd, "SCS0075", new String[]{fecha, idCta, idTercero, idProducto});
                RSsaldo = RQsaldo.ejecutarSELECT();
                if (RSsaldo.next()) {
                    saldoAnt = RSsaldo.getDouble(1);
                }
            } else {
                RQdata = new QueryRunner(this.bd, "SCS0072", new String[]{idCta, idTercero, idProducto});
            }
            RQnaturaleza = new QueryRunner(this.bd, "SCS0073", new String[]{idCta});
            RSnaturaleza = RQnaturaleza.ejecutarSELECT();
            RSnaturaleza.next();
            boolean naturaleza = RSnaturaleza.getBoolean(1);
            RSdata = RQdata.ejecutarSELECT();
            RQupdate = new QueryRunner(this.bd, "SCU0003");
            double saldo = 0.0;
            saldo = naturaleza ? this.roundValue(this.recoverDebit(saldoAnt, RSdata, RQupdate)) : this.roundValue(this.recoverCredit(saldoAnt, RSdata, RQupdate));
            LinkingCache.setSaldoLibroAux(this.bd, "", idCta, idTercero.equals("-1") ? "" : idTercero, idProducto.equals("-1") ? "" : idProducto, saldo);
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                RQsaldo.closeStatement();
                RSsaldo.close();
            }
            catch (NullPointerException NPEe) {
            }
            catch (SQLException e) {}
            try {
                RQnaturaleza.closeStatement();
                RSnaturaleza.close();
                RQdata.closeStatement();
                RSsaldo.close();
                RSdata.close();
                RQupdate.closeStatement();
            }
            catch (NullPointerException NPEe) {
            }
            catch (SQLException e) {}
        }
    }

    private double recoverDebit(double saldoAnt, ResultSet RSdata, QueryRunner RQupdate) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        String orden = null;
        double debe = 0.0;
        double haber = 0.0;
        double saldo = saldoAnt;
        while (RSdata.next()) {
            orden = RSdata.getString(1);
            debe = RSdata.getDouble(2);
            haber = RSdata.getDouble(3);
            saldo = this.roundValue(saldo + debe - haber);
            RQupdate.ejecutarSQL(new String[]{String.valueOf(saldo), orden});
        }
        return saldo;
    }

    private double recoverCredit(double saldoAnt, ResultSet RSdata, QueryRunner RQupdate) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        String orden = null;
        double debe = 0.0;
        double haber = 0.0;
        double saldo = saldoAnt;
        while (RSdata.next()) {
            orden = RSdata.getString(1);
            debe = RSdata.getDouble(2);
            haber = RSdata.getDouble(3);
            saldo = this.roundValue(saldo + haber - debe);
            RQupdate.ejecutarSQL(new String[]{String.valueOf(saldo), orden});
        }
        return saldo;
    }

    private double roundValue(Double value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public void deleteDocument() throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdpDocument = new QueryRunner(this.bd, "SCD0004", new String[0]);
        QueryRunner RQdropDocument = new QueryRunner(this.bd, "SCS0084", new String[]{CacheKeys.getKey("ndocumento")});
        QueryRunner RQdeleteDocument = new QueryRunner(this.bd, "SCD0001", new String[]{CacheKeys.getKey("ndocumento")});
        RQdpDocument.ejecutarSQL();
        RQdropDocument.ejecutarSQL();
        RQdeleteDocument.ejecutarSQL();
        RQdpDocument.closeStatement();
        RQdropDocument.closeStatement();
        RQdeleteDocument.closeStatement();
    }
}

