/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.misc.language.Language;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.AnnulDocumentException;
import server.businessrules.CacheKeys;
import server.businessrules.DontHaveBalanceException;
import server.businessrules.InvalidDateException;
import server.businessrules.LNContabilidad;
import server.businessrules.LNErrorProcecuteException;
import server.businessrules.LNGenericSQL;
import server.businessrules.LNInventarios;
import server.businessrules.LNSelectedField;
import server.businessrules.LNUndoSaldos;
import server.businessrules.RunTransaction;
import server.comunications.EmakuServerSocket;
import server.database.sql.DontHaveKeyException;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNDocuments {
    private static SocketChannel sock;
    private static String idTransaction;
    private static Document doc;
    private static Element pack;
    private static LNGenericSQL LNGtransaccion;
    private static double partidaDoble;
    private static String date;
    private static String minDate;
    private static String idDocument;
    private static String linkDocument;
    private static String multiDocument;
    private static String rfDocument;
    private static String consecutive;
    private static boolean cash;
    private static boolean lockDocument;
    private static String actionDocument;
    private static String bd;
    private static final String CREATE_DOCUMENT = "createDocument";
    private static final String ANNUL_DOCUMENT = "annulDocument";
    public static final String DELETE_DOCUMENT = "deleteDocument";
    public static final String EDIT_DOCUMENT = "editDocument";
    public static String ndocument;

    public LNDocuments(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        LNDocuments.makeTransaction(sock, doc, pack, idTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static synchronized void makeTransaction(SocketChannel _sock, Document _doc, Element _pack, String _idTransaction) {
        LNDocuments.idDocument = null;
        LNDocuments.linkDocument = null;
        LNDocuments.multiDocument = null;
        LNDocuments.rfDocument = null;
        LNDocuments.consecutive = null;
        LNDocuments.cash = false;
        LNDocuments.lockDocument = false;
        LNDocuments.sock = _sock;
        LNDocuments.doc = _doc;
        LNDocuments.pack = _pack;
        LNDocuments.idTransaction = _idTransaction;
        LNDocuments.partidaDoble = 0.0;
        LNDocuments.bd = EmakuServerSocket.getBd(LNDocuments.sock);
        i = LNDocuments.doc.getRootElement().getChildren().iterator();
        j = LNDocuments.pack.getChildren().iterator();
        LNDocuments.LNGtransaccion = new LNGenericSQL(LNDocuments.sock);
        LNDocuments.LNGtransaccion.setAutoCommit(false);
        CacheKeys.cleanKeys();
        try {
            m = 0;
            while (i.hasNext()) {
                block119: {
                    block120: {
                        block122: {
                            sql = (Element)i.next();
                            subpackage = (Element)j.next();
                            if (m != 0) break block122;
                            LNDocuments.getDocumentConfig(sql);
                            if (!LNDocuments.actionDocument.equals("createDocument")) ** GOTO lbl75
                            parameters = true;
                            if (LNDocuments.consecutive == null) {
                                parameters = LNDocuments.getParameters(subpackage);
                            }
                            if (parameters) {
                                if ("".equals(CacheKeys.getDate())) {
                                    dateDocument = subpackage.getValue();
                                    CacheKeys.setDate(dateDocument);
                                    CacheKeys.setMinDate(dateDocument);
                                    if (i.hasNext()) {
                                        subpackage = (Element)j.next();
                                    }
                                }
                                sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
                                if (!LNDocuments.lockDocument && LinkingCache.getLockDate(LNDocuments.bd) != null && LinkingCache.getLockDate(LNDocuments.bd).getTime() > sdf.parse(CacheKeys.getDate()).getTime()) {
                                    throw new InvalidDateException();
                                }
                                if (LNDocuments.lockDocument) {
                                    LNDocuments.lockDocument = false;
                                    dateDocument = subpackage.getValue();
                                    LinkingCache.setLockDate(LNDocuments.bd, dateDocument);
                                }
                                LNDocuments.createDocument(LNDocuments.idDocument.trim(), LNDocuments.consecutive.trim());
                                LNDocuments.ndocument = LNDocuments.getDocumentKey(LNDocuments.idDocument, LNDocuments.consecutive);
                                if (LNDocuments.linkDocument != null) {
                                    consecutiveLinkDocument = LinkingCache.getConsecutive(LNDocuments.bd, LNDocuments.linkDocument);
                                    LNDocuments.createDocument(LNDocuments.linkDocument.trim(), consecutiveLinkDocument);
                                    infoDocumentPack = new Element("package");
                                    infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.getDocumentKey(LNDocuments.linkDocument, consecutiveLinkDocument)));
                                    infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.ndocument));
                                    infoDocumentPack.addContent((Content)new Element("field").setText(EmakuServerSocket.getLoging(LNDocuments.sock)));
                                    if (LNDocuments.cash) {
                                        infoDocumentPack.addContent((Content)new Element("field").setText(EmakuServerSocket.getLoging(LNDocuments.sock)));
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0016", infoDocumentPack);
                                    } else {
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0017", infoDocumentPack);
                                    }
                                }
                                LNDocuments.LNGtransaccion.setKey("ndocumento", LNDocuments.ndocument);
                                infoDocumentPack = new Element("package");
                                infoDocumentPack.addContent((Content)new Element("field").setText(EmakuServerSocket.getLoging(LNDocuments.sock)));
                                if (LNDocuments.cash) {
                                    infoDocumentPack.addContent((Content)new Element("field").setText(EmakuServerSocket.getLoging(LNDocuments.sock)));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI00O3", infoDocumentPack);
                                } else {
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI00O2", infoDocumentPack);
                                }
                            } else {
                                LNDocuments.undoTransaction(Language.getWord((String)"ERR_PARAMETERS_DOCUMENT"));
                                return;
lbl75:
                                // 1 sources

                                if (LNDocuments.actionDocument.equals("annulDocument")) {
                                    numero = subpackage.getValue();
                                    primaryKey = LNDocuments.getPrimaryKey(numero);
                                    LNDocuments.consecutive = numero = "0000000000".substring(0, 10 - numero.length()) + numero;
                                    if (primaryKey == null) {
                                        LNDocuments.undoTransaction(Language.getWord((String)"ERR_ANNUL_DOCUMENT_NOT_FOUND"));
                                        break;
                                    }
                                    if (!LNDocuments.isAnnullDocument(primaryKey)) {
                                        throw new AnnulDocumentException(LNDocuments.idDocument, numero);
                                    }
                                    if (LNDocuments.rfDocument != null && !LNDocuments.rfDocument.equals("")) {
                                        RQrfkey = new QueryRunner(LNDocuments.bd, "SCS0053", new String[]{primaryKey});
                                        RSrfkey = RQrfkey.ejecutarSELECT();
                                        rfKey = "";
                                        while (RSrfkey.next()) {
                                            rfKey = RSrfkey.getString(1);
                                        }
                                        if ("".equals(rfKey)) {
                                            LNDocuments.undoTransaction(Language.getWord((String)"ERR_ANNUL_RF_DOCUMENT_NOT_FOUND"));
                                            break;
                                        }
                                        tmpKey = LNDocuments.LNGtransaccion.getKey(0);
                                        LNDocuments.LNGtransaccion.removeKey("ndocumento");
                                        documentPack = new Element("package");
                                        documentPack.addContent((Content)new Element("field").setText(rfKey));
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCU0001", documentPack);
                                        LNDocuments.LNGtransaccion.setKey("ndocumento", tmpKey);
                                    }
                                    if (LNDocuments.lockDocument) {
                                        LinkingCache.reloadLockDate(LNDocuments.bd);
                                    }
                                    documentPack = new Element("package");
                                    documentPack.addContent((Content)new Element("field"));
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCU0001", documentPack);
                                    if (!i.hasNext()) break;
                                    subpackage = (Element)j.next();
                                } else if (LNDocuments.actionDocument.equals("deleteDocument")) {
                                    numero = subpackage.getValue();
                                    key = LNDocuments.getPrimaryKey(numero);
                                    if (i.hasNext()) {
                                        subpackage = (Element)j.next();
                                    }
                                    if ("".equals(CacheKeys.getDate())) {
                                        dateDocument = subpackage.getValue();
                                        CacheKeys.setDate(dateDocument);
                                        CacheKeys.setMinDate(dateDocument);
                                        if (i.hasNext()) {
                                            subpackage = (Element)j.next();
                                        }
                                    }
                                    if (key == null) {
                                        LNDocuments.undoTransaction(Language.getWord((String)"ERR_DELETE_DOCUMENT_NOT_FOUND"));
                                        break;
                                    }
                                } else if (LNDocuments.actionDocument.equals("editDocument")) {
                                    numero = subpackage.getValue();
                                    key = LNDocuments.getPrimaryKey(numero);
                                    System.out.println("llave primaria: " + key);
                                    if (!i.hasNext()) break;
                                    subpackage = (Element)j.next();
                                    if ("".equals(CacheKeys.getDate())) {
                                        dateDocument = subpackage.getValue();
                                        CacheKeys.setDate(dateDocument);
                                        CacheKeys.setMinDate(dateDocument);
                                        if (i.hasNext()) {
                                            subpackage = (Element)j.next();
                                        }
                                    }
                                    LNDocuments.updateDateDocument(key, CacheKeys.getDate());
                                }
                            }
                            sql = (Element)i.next();
                            System.out.println("pasando al LN");
                        }
                        if (sql.getName().equals("arg")) {
                            System.out.println("SQL: " + sql.getValue());
                            if ("addKey".equals(sql.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else if ("removeKey".equals(sql.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.removeKey(sql.getValue());
                                CacheKeys.removeKey(sql.getValue());
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else {
                                LNDocuments.LNGtransaccion.setGenerable(true);
                            }
                            if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                                out = new XMLOutputter();
                                out.setFormat(Format.getPrettyFormat());
                                if ("discardBadArguments".equals(sql.getAttributeValue("attribute"))) {
                                    LNDocuments.LNGtransaccion.setDiscardBadArgument(true);
                                }
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, sql.getValue(), subpackage);
                            } else {
                                LNDocuments.getfields(LNDocuments.LNGtransaccion, sql.getValue(), subpackage);
                            }
                            break block119;
                        }
                        if (!sql.getName().equals("subarg")) break block120;
                        for (Element subargs : sql.getChildren()) {
                            if ("addKey".equals(subargs.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else if ("removeKey".equals(subargs.getAttributeValue("attribute"))) {
                                LNDocuments.LNGtransaccion.removeKey(subargs.getValue());
                                CacheKeys.removeKey(subargs.getValue());
                                LNDocuments.LNGtransaccion.setGenerable(false);
                            } else {
                                LNDocuments.LNGtransaccion.setGenerable(true);
                            }
                            System.out.println("SQL: " + subargs.getValue());
                            if (subargs.getName().equals("arg")) {
                                if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                                    LNDocuments.getTransaction(LNDocuments.LNGtransaccion, subargs.getValue(), subpackage);
                                    continue;
                                }
                                LNDocuments.getfields(LNDocuments.LNGtransaccion, subargs.getValue(), subpackage);
                                continue;
                            }
                            if (subargs.getName().equals("LNData")) {
                                if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                                    LNDocuments.validLNData(subargs, subpackage);
                                    continue;
                                }
                                for (Element epack : subpackage.getChildren()) {
                                    LNDocuments.validLNData(subargs, epack);
                                }
                                continue;
                            }
                            LNDocuments.undoTransaction(Language.getWord((String)"ERR_PACKAGE_NOT_FOUND") + " " + subargs.getValue());
                            return;
                        }
                    }
                    if (sql.getName().equals("LNData")) {
                        System.out.println("SQL: " + sql.getValue());
                        if (((Element)subpackage.getChildren().iterator().next()).getName().equals("field")) {
                            LNDocuments.validLNData(sql, subpackage);
                        } else {
                            for (Element epack : subpackage.getChildren()) {
                                LNDocuments.validLNData(sql, epack);
                            }
                        }
                    } else if (sql.getName().equals("multiDocument")) {
                        repeat = Integer.parseInt(subpackage.getValue());
                        e = new Element("multipackage");
                        n = 0;
                        while (j.hasNext()) {
                            sb = (Element)((Element)j.next()).clone();
                            e.addContent((Content)sb);
                            System.out.println("paquete " + n++ + " valor " + sb.getValue());
                        }
                        LNDocuments.LNGtransaccion.setGenerable(true);
                        for (h = 0; h < repeat; ++h) {
                            CacheKeys.cleanKeys();
                            CacheKeys.setDate(LNDocuments.date);
                            CacheKeys.setDate(LNDocuments.minDate);
                            LNDocuments.LNGtransaccion.setGenerable(true);
                            System.out.println("Documento " + h);
                            LNDocuments.LNGtransaccion.removeKey("ndocumento");
                            consecutiveLinkDocument = LinkingCache.getConsecutive(LNDocuments.bd, LNDocuments.multiDocument);
                            LNDocuments.createDocument(LNDocuments.multiDocument.trim(), consecutiveLinkDocument);
                            keyDocument = LNDocuments.getDocumentKey(LNDocuments.multiDocument, consecutiveLinkDocument);
                            infoDocumentPack = new Element("package");
                            infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.getDocumentKey(LNDocuments.multiDocument, consecutiveLinkDocument)));
                            infoDocumentPack.addContent((Content)new Element("field").setText(LNDocuments.ndocument));
                            infoDocumentPack.addContent((Content)new Element("field").setText(EmakuServerSocket.getLoging(LNDocuments.sock)));
                            if (LNDocuments.cash) {
                                infoDocumentPack.addContent((Content)new Element("field").setText(EmakuServerSocket.getLoging(LNDocuments.sock)));
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0016", infoDocumentPack);
                            } else {
                                LNDocuments.getTransaction(LNDocuments.LNGtransaccion, "SCI0017", infoDocumentPack);
                            }
                            LNDocuments.LNGtransaccion.setKey("ndocumento", keyDocument);
                            isubargs = sql.getChildren().iterator();
                            ipackage = e.getChildren().iterator();
                            while (isubargs.hasNext()) {
                                subargs = (Element)isubargs.next();
                                msubpackage = (Element)ipackage.next();
                                if ("addKey".equals(subargs.getAttributeValue("attribute"))) {
                                    LNDocuments.LNGtransaccion.setGenerable(false);
                                } else if ("removeKey".equals(subargs.getAttributeValue("attribute"))) {
                                    LNDocuments.LNGtransaccion.removeKey(subargs.getValue());
                                    CacheKeys.removeKey(subargs.getValue());
                                    LNDocuments.LNGtransaccion.setGenerable(false);
                                } else {
                                    LNDocuments.LNGtransaccion.setGenerable(true);
                                }
                                if (subargs.getName().equals("arg")) {
                                    if (((Element)msubpackage.getChildren().iterator().next()).getName().equals("field")) {
                                        LNDocuments.getTransaction(LNDocuments.LNGtransaccion, subargs.getValue(), msubpackage);
                                        continue;
                                    }
                                    LNDocuments.getfields(LNDocuments.LNGtransaccion, subargs.getValue(), msubpackage);
                                    continue;
                                }
                                if (subargs.getName().equals("LNData")) {
                                    if (((Element)msubpackage.getChildren().iterator().next()).getName().equals("field")) {
                                        LNDocuments.validLNData(subargs, msubpackage);
                                        continue;
                                    }
                                    for (Element epack : msubpackage.getChildren()) {
                                        LNDocuments.validLNData(subargs, epack);
                                    }
                                    continue;
                                }
                                LNDocuments.undoTransaction(Language.getWord((String)"ERR_PACKAGE_NOT_FOUND") + " " + subargs.getValue());
                                return;
                            }
                            LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.multiDocument);
                        }
                        LNDocuments.multiDocument = null;
                    } else {
                        LNDocuments.undoTransaction(Language.getWord((String)"ERR_PACKAGE_NOT_FOUND") + " " + sql.getName());
                        return;
                        catch (NoSuchElementException NSEEe) {
                            NSEEe.printStackTrace();
                        }
                    }
                }
                ++m;
            }
            if (LNDocuments.partidaDoble == 0.0) {
                LNDocuments.LNGtransaccion.commit();
                ndocument = new Element("ndocument");
                ndocument.setText(LNDocuments.consecutive);
                RunTransaction.successMessage(LNDocuments.sock, LNDocuments.idTransaction, Language.getWord((String)"TRANSACTION_OK"), ndocument);
                if ("createDocument".equals(LNDocuments.actionDocument)) {
                    System.out.println("Se creo un documento, avanzando consecutivo...");
                    LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.idDocument);
                    if (LNDocuments.linkDocument != null) {
                        System.out.println("Se creo un documento enlace, avanzando consecutivo...");
                        LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.linkDocument);
                    }
                } else if ("deleteDocument".equals(LNDocuments.actionDocument)) {
                    LinkingCache.reloadConsecutive(LNDocuments.bd, LNDocuments.idDocument);
                    if (LNDocuments.linkDocument != null) {
                        LinkingCache.incrementeConsecutive(LNDocuments.bd, LNDocuments.linkDocument);
                    }
                }
            } else {
                LNDocuments.undoTransaction(Language.getWord((String)"ERR_DONT_HAVE_BALANCE_EXCEPTION") + " " + LNDocuments.partidaDoble);
            }
        }
        catch (SQLNotFoundException SQLNFEe) {
            SQLNFEe.printStackTrace();
            LNDocuments.undoTransaction(SQLNFEe.getMessage());
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            SQLBAEe.printStackTrace();
            LNDocuments.undoTransaction(SQLBAEe.getMessage());
        }
        catch (SQLException SQLe) {
            SQLe.printStackTrace();
            LNDocuments.undoTransaction(SQLe.getMessage());
        }
        catch (NullPointerException NPEe) {
            NPEe.printStackTrace();
            LNDocuments.undoTransaction(NPEe.getMessage());
        }
        catch (SecurityException SEe) {
            SEe.printStackTrace();
            LNDocuments.undoTransaction(SEe.getMessage());
        }
        catch (IllegalArgumentException IAEe) {
            IAEe.printStackTrace();
            LNDocuments.undoTransaction(IAEe.getMessage());
        }
        catch (ClassNotFoundException CNFEe) {
            CNFEe.printStackTrace();
            LNDocuments.undoTransaction(CNFEe.getMessage());
        }
        catch (NoSuchMethodException NSMEe) {
            NSMEe.printStackTrace();
            LNDocuments.undoTransaction(NSMEe.getMessage());
        }
        catch (InstantiationException IEe) {
            IEe.printStackTrace();
            LNDocuments.undoTransaction(IEe.getMessage());
        }
        catch (IllegalAccessException IAEe) {
            IAEe.printStackTrace();
            LNDocuments.undoTransaction(IAEe.getMessage());
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
            LNDocuments.undoTransaction(ITEe.getLocalizedMessage());
        }
        catch (LNErrorProcecuteException LNEPEe) {
            LNEPEe.printStackTrace();
            LNDocuments.undoTransaction(LNEPEe.getMessage());
        }
        catch (DontHaveKeyException DHEe) {
            DHEe.printStackTrace();
            LNDocuments.undoTransaction(DHEe.getMessage());
        }
        catch (DontHaveBalanceException DHBEe) {
            DHBEe.printStackTrace();
            LNDocuments.undoTransaction(DHBEe.getMessage());
        }
        catch (AnnulDocumentException ADEe) {
            LNDocuments.undoTransaction(ADEe.getMessage());
        }
        catch (ParseException e) {
            LNDocuments.undoTransaction(e.getMessage());
        }
        catch (InvalidDateException IDEe) {
            LNDocuments.undoTransaction(IDEe.getMessage());
        }
        finally {
            CacheKeys.setKeys(new Hashtable<K, V>());
        }
        LNDocuments.LNGtransaccion.setAutoCommit(true);
    }

    private static void updateDateDocument(String key, String date) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        QueryRunner RQupdateDateDocument = new QueryRunner(bd, "SCU0004", new String[]{date, key});
        RQupdateDateDocument.ejecutarSQL();
        RQupdateDateDocument.closeStatement();
    }

    private static boolean isAnnullDocument(String keyDocument) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        boolean annul = true;
        QueryRunner RQkey = new QueryRunner(bd, "SCS0045", new String[]{keyDocument});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            annul = RSdatos.getBoolean(1);
        }
        RSdatos.close();
        RQkey.closeStatement();
        return annul;
    }

    private static String getPrimaryKey(String numero) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String primaryKey = null;
        QueryRunner RQkey = new QueryRunner(bd, "SCS0024", new String[]{idDocument, numero});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            primaryKey = RSdatos.getString(1);
        }
        LNGtransaccion.setKey("ndocumento", primaryKey);
        CacheKeys.setKeys(LNGtransaccion.getKeys());
        RSdatos.close();
        RQkey.closeStatement();
        return primaryKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void validLNData(Element args, Element pack) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, LNErrorProcecuteException, SQLBadArgumentsException, SQLNotFoundException, SQLException, DontHaveKeyException, DontHaveBalanceException {
        Iterator i = args.getChildren().iterator();
        String driver = null;
        String method = null;
        Element parameters = null;
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("driver")) {
                driver = e.getValue();
                continue;
            }
            if (name.equals("method")) {
                method = e.getValue();
                continue;
            }
            if (!name.equals("parameters")) continue;
            parameters = e;
        }
        if ("LNInventarios".equals(driver)) {
            LNInventarios LNIprocesar = new LNInventarios(parameters, EmakuServerSocket.getBd(sock));
            if (method.equals("movimientos")) {
                LNIprocesar.movimientos(pack);
                return;
            } else {
                if (!method.equals("traslados")) throw new NoSuchMethodException(method);
                LNIprocesar.traslados(pack);
            }
            return;
        } else if ("LNContabilidad".equals(driver)) {
            LNContabilidad LNCprocesar = parameters != null ? new LNContabilidad(parameters, EmakuServerSocket.getBd(sock)) : new LNContabilidad(EmakuServerSocket.getBd(sock));
            if ("columnData".equals(method)) {
                partidaDoble += LNCprocesar.columnData(pack);
            } else if ("fieldData".equals(method)) {
                partidaDoble += LNCprocesar.fieldData(pack);
            } else if ("columnDataAccount".equals(method)) {
                partidaDoble += LNCprocesar.columDataAccount(pack);
            } else if ("rowDataAccount".equals(method)) {
                partidaDoble += LNCprocesar.rowDataAccount(pack);
            } else if ("anular".equals(method)) {
                LNCprocesar.anular();
            } else if ("recover".equals(method)) {
                LNCprocesar.recover(pack);
            } else if ("recoverDocument".equals(method)) {
                LNCprocesar.recoverDocument();
            } else if ("recoverCost".equals(method)) {
                LNCprocesar.recoverDocument();
            } else {
                if (!DELETE_DOCUMENT.equals(method)) throw new NoSuchMethodException(Language.getWord((String)"NO_SUCH_METHOD") + method);
                LNCprocesar.deleteDocument();
            }
            try {
                BigDecimal bigDecimal = new BigDecimal(partidaDoble);
                bigDecimal = bigDecimal.setScale(2, 4);
                partidaDoble = bigDecimal.doubleValue();
                return;
            }
            catch (NumberFormatException NFEe) {}
            return;
        } else if ("LNSelectedField".equals(driver)) {
            LNSelectedField LNSprocesar = new LNSelectedField(parameters, EmakuServerSocket.getBd(sock));
            LNSprocesar.getFields(pack);
            return;
        } else {
            LNDocuments.validExternalClass(driver, method, parameters, pack);
        }
    }

    private static void validExternalClass(String driver, String method, Element parameters, Element pack) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = Class.forName(driver);
        Class[] type_args_constructor = null;
        Object[] args_constructor = null;
        if (method != null) {
            type_args_constructor = new Class[]{Element.class, String.class};
            args_constructor = new Object[]{parameters, EmakuServerSocket.getBd(sock)};
        }
        Constructor<?> cons = cls.getConstructor(type_args_constructor);
        Object obj = cons.newInstance(args_constructor);
        Method meth = cls.getMethod(method, Element.class);
        meth.invoke(obj, pack);
    }

    private static void getTransaction(LNGenericSQL LNGtransaccion, String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        LNGtransaccion.setArgs(pack, idTransaction);
        LNGtransaccion.generar(sql);
        CacheKeys.setKeys(LNGtransaccion.getKeys());
    }

    private static void getfields(LNGenericSQL LNGtransaccion, String sql, Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        for (Element subpackage : pack.getChildren()) {
            LNDocuments.getTransaction(LNGtransaccion, sql, subpackage);
        }
    }

    private static String getDocumentKey(String idDocument, String consecutive) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String primaryKey = null;
        QueryRunner RQkey = new QueryRunner(bd, "SCS0024", new String[]{idDocument, consecutive});
        ResultSet RSdatos = RQkey.ejecutarSELECT();
        while (RSdatos.next()) {
            primaryKey = RSdatos.getString(1);
        }
        RSdatos.close();
        RQkey.closeStatement();
        return primaryKey;
    }

    private static void createDocument(String idDocument, String consecutive) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Element documentPack = new Element("package");
        documentPack.addContent((Content)new Element("field").setText(idDocument));
        documentPack.addContent((Content)new Element("field").setText(consecutive));
        documentPack.addContent((Content)new Element("field").setText(CacheKeys.getDate().trim()));
        LNDocuments.getTransaction(LNGtransaccion, "SCI00O1", documentPack);
    }

    private static boolean getParameters(Element config) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException {
        for (Element subpackage : config.getChildren()) {
            String value = subpackage.getValue();
            if (!"consecutive".equals(subpackage.getAttributeValue("attribute"))) continue;
            consecutive = value;
        }
        return consecutive != null;
    }

    private static void getDocumentConfig(Element config) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        for (Element subpackage : config.getChildren()) {
            String value = subpackage.getValue();
            if (subpackage.getAttributeValue("attribute").equals("idDocument")) {
                idDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("linkDocument")) {
                linkDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("multiDocument")) {
                multiDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("rfDocument")) {
                rfDocument = value;
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("consecutive")) {
                String bd = EmakuServerSocket.getBd(sock);
                consecutive = LinkingCache.getConsecutive(bd, idDocument);
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("date")) {
                GregorianCalendar fecha = new GregorianCalendar();
                SimpleDateFormat formato = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                date = formato.format(fecha.getTime());
                minDate = formato.format(fecha.getTime());
                CacheKeys.setDate(formato.format(fecha.getTime()));
                CacheKeys.setMinDate(formato.format(fecha.getTime()));
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("actionDocument")) {
                actionDocument = subpackage.getValue();
                continue;
            }
            if (subpackage.getAttributeValue("attribute").equals("cash")) {
                cash = true;
                continue;
            }
            if (!subpackage.getAttributeValue("attribute").equals("lockDocument")) continue;
            lockDocument = true;
        }
    }

    private static void undoTransaction(String message) {
        LNGtransaccion.rollback();
        LNUndoSaldos.undoSaldos();
        Element ndocument = new Element("ndocument");
        ndocument.setText(consecutive);
        System.out.println("consecutivo: " + consecutive + " transaccion " + idTransaction);
        RunTransaction.errorMessage(sock, idTransaction, message, ndocument);
    }

    public static String getActionDocument() {
        return actionDocument;
    }

    public static void setActionDocument(String actionDocument) {
        LNDocuments.actionDocument = actionDocument;
    }

    static {
        partidaDoble = 0.0;
    }
}

