/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.misc.formulas.BeanShell;
import common.misc.language.Language;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.CacheKeys;
import server.businessrules.RunTransaction;
import server.comunications.EmakuServerSocket;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNSelectedField {
    private String fields;
    private String conditional;
    private int[] cols;
    private QueryRunner RQfields;
    private ArrayList<String> discartKeys;

    public LNSelectedField(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        try {
            CacheKeys.cleanKeys();
            this.analizar(doc.getRootElement(), pack, EmakuServerSocket.getBd(sock), false);
            this.RQfields.commit();
            RunTransaction.successMessage(sock, idTransaction, Language.getWord((String)"TRANSACTION_OK"));
        }
        catch (SQLNotFoundException SQLNFEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLNFEe.getMessage());
            this.RQfields.rollback();
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLBAEe.getMessage());
            this.RQfields.rollback();
        }
        catch (SQLException SQLEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLEe.getMessage());
            this.RQfields.rollback();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.RQfields.setAutoCommit(true);
    }

    public LNSelectedField(Element parameters, String bd) throws SQLNotFoundException, SQLBadArgumentsException {
        this.parametrizar(parameters, bd);
    }

    private void analizar(Element parametros, Element paquetes, String bd, boolean subparametro) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException {
        Iterator parametro = parametros.getChildren().iterator();
        Iterator paquete = paquetes.getChildren().iterator();
        while (parametro.hasNext()) {
            Element data = (Element)parametro.next();
            Element pack = null;
            pack = !subparametro ? (Element)paquete.next() : (Element)paquetes.clone();
            try {
                if (data.getName().equals("LNData")) {
                    System.out.println("Es un Data");
                    Element args = (Element)data.getChildren("parameters").iterator().next();
                    this.parametrizar(args, bd);
                    if (((Element)pack.getChildren().iterator().next()).getName().equals("field")) {
                        System.out.println("Es un field sin cosas");
                        this.getFields(pack);
                        continue;
                    }
                    System.out.println("Es un conjunto de packages");
                    this.getSubPackage(pack);
                    continue;
                }
                if (data.getName().equals("arg")) {
                    if (((Element)pack.getChildren().iterator().next()).getName().equals("field")) {
                        System.out.println("Es un field con cosas");
                        this.getFields(bd, data, pack);
                        continue;
                    }
                    System.out.println("debe ser subarg");
                    this.getSubPackage(bd, data, pack);
                    continue;
                }
                System.out.println("Hay un conjunto de sentencias q deben ser procesadas");
                this.analizar((Element)data.clone(), (Element)pack.clone(), bd, true);
            }
            catch (NoSuchElementException NSEEe) {}
        }
    }

    private void parametrizar(Element parameters, String bd) throws SQLNotFoundException, SQLBadArgumentsException {
        Iterator i = parameters.getChildren().iterator();
        String sql = "";
        this.discartKeys = new ArrayList();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String attribute = e.getAttributeValue("attribute");
            String value = e.getValue();
            if ("fields".equals(attribute)) {
                this.fields = value;
                continue;
            }
            if ("sql".equals(attribute)) {
                sql = value;
                continue;
            }
            if ("conditional".equals(attribute)) {
                this.conditional = value;
                continue;
            }
            if (!"discartKey".equals(attribute)) continue;
            System.out.println("Este es value: " + value.toString());
            this.discartKeys.add(value);
        }
        this.RQfields = new QueryRunner(bd, sql);
        StringTokenizer STcols = new StringTokenizer(this.fields, ",");
        this.cols = new int[STcols.countTokens()];
        int j = 0;
        while (STcols.hasMoreTokens()) {
            this.cols[j] = Integer.parseInt(STcols.nextToken());
            ++j;
        }
    }

    public void getFields(String bd, Element args, Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        this.RQfields = new QueryRunner(bd, args.getValue());
        ArrayList<String> fieldSQL = new ArrayList<String>();
        Iterator valueKeys = CacheKeys.getKeys();
        while (valueKeys.hasNext()) {
            String key = (String)valueKeys.next();
            fieldSQL.add(key);
        }
        for (Element value : pack.getChildren()) {
            String text = value.getText();
            String key = value.getAttributeValue("attribute");
            String nameField = value.getAttributeValue("nameField");
            if ("key".equals(key)) {
                nameField = nameField == null ? "" : nameField;
                CacheKeys.setKey(nameField, text);
            }
            if ("".equals(text)) continue;
            fieldSQL.add(text);
        }
        this.RQfields.ejecutarSQL(fieldSQL.toArray(new String[fieldSQL.size()]));
    }

    public void getFields(Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        System.out.println("\n-----------------------------");
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.setFormat(Format.getPrettyFormat());
            xmlOutputter.output(pack, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List lpack = pack.getChildren();
        if (this.conditional != null && !BeanShell.eval((String)this.formulaReplacer(this.conditional, lpack))) {
            return;
        }
        ArrayList<String> fieldSQL = new ArrayList<String>();
        Iterator valueKeys = CacheKeys.getKeys();
        Iterator keys = CacheKeys.getHKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            boolean discart = false;
            for (int k = 0; k < this.discartKeys.size(); ++k) {
                if (!key.equals(this.discartKeys.get(k))) continue;
                discart = true;
                break;
            }
            if (discart) continue;
            fieldSQL.add((String)valueKeys.next());
        }
        for (int j = 0; j < this.cols.length; ++j) {
            System.out.println("solicitando col: " + this.cols[j]);
            fieldSQL.add(((Element)lpack.get(this.cols[j])).getValue());
        }
        this.RQfields.ejecutarSQL(fieldSQL.toArray(new String[fieldSQL.size()]));
    }

    private void getSubPackage(Element paquete) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        for (Element fields : paquete.getChildren()) {
            if (((Element)fields.getChildren().iterator().next()).getName().equals("field")) {
                this.getFields(fields);
                continue;
            }
            this.getSubPackage(fields);
        }
    }

    private void getSubPackage(String bd, Element data, Element paquete) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        for (Element fields : paquete.getChildren()) {
            if (((Element)fields.getChildren().iterator().next()).getName().equals("field")) {
                this.getFields(bd, data, fields);
                continue;
            }
            this.getSubPackage(bd, data, fields);
        }
    }

    private String formulaReplacer(String var, List lpack) {
        String newVar = "";
        for (int j = 0; j < var.length(); ++j) {
            if (j + 10 < var.length() && var.substring(j, j + 11).equals(".startsWith")) {
                String s = ".startsWith(" + var.substring(j + 12, var.indexOf(")", j + 12)) + ")";
                newVar = newVar + s;
                j = var.indexOf(")", j);
                continue;
            }
            if (j + 7 < var.length() && var.substring(j, j + 7).equals(".equals")) {
                String s = ".equals(" + var.substring(j + 8, var.indexOf(")", j + 8)) + ")";
                newVar = newVar + s;
                j = var.indexOf(")", j);
                continue;
            }
            if (var.charAt(j) >= 'A' && var.charAt(j) <= 'Z' || var.charAt(j) >= 'a' && var.charAt(j) <= 'z') {
                int col = var.charAt(j) <= 'Z' ? var.charAt(j) - 65 : var.charAt(j) - 97;
                newVar = newVar + ((Element)lpack.get(col)).getValue();
                continue;
            }
            newVar = newVar + var.substring(j, j + 1);
        }
        return newVar;
    }
}

