/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.SocketWriter;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import server.comunications.EmakuServerSocket;
import server.comunications.ErrorXML;
import server.comunications.SuccessXML;
import server.database.sql.BusinessRulesStructure;
import server.database.sql.LinkingCache;
import server.database.sql.SQLFormatAgent;

public class RunTransaction
extends Thread {
    private String transaction_code;
    private String id_transaction;
    private Class[] type_args_constructor;
    private Class[] type_args_method;
    private Object[] args_constructor;
    private Object[] args_method;
    private Element pack = null;
    private Document transaction;
    private SocketChannel sock;

    public RunTransaction(SocketChannel sock, Document transaction) {
        this.sock = sock;
        this.transaction = transaction;
    }

    @Override
    public void run() {
        String login;
        Element elm = this.transaction.getRootElement();
        List listaRaiz = elm.getChildren();
        Iterator i = listaRaiz.iterator();
        String password = "";
        this.pack = new Element("source");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String nombre = e.getName();
            if (nombre.equals("driver")) {
                this.transaction_code = e.getValue();
                continue;
            }
            if (nombre.equals("password")) {
                password = e.getValue();
                continue;
            }
            if (nombre.equals("id")) {
                this.id_transaction = e.getValue();
                continue;
            }
            if (!nombre.equals("package")) continue;
            this.pack.addContent((Content)((Element)e.clone()));
        }
        String bd = EmakuServerSocket.getBd(this.sock);
        if (SQLFormatAgent.permisoTransaccion(bd, login = EmakuServerSocket.getLoging(this.sock), this.transaction_code, password)) {
            System.out.println("bd: " + bd + " transaction_code: " + this.transaction_code + " Driver: " + LinkingCache.getDriver(bd, this.transaction_code));
            this.callDriver(LinkingCache.getDriver(bd, this.transaction_code), this.id_transaction);
        } else {
            RunTransaction.errorMessage(this.sock, this.id_transaction, Language.getWord((String)"TRANSACTION_ACCESS_DENIED"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callDriver(BusinessRulesStructure CLDdriver, String id_transaction) {
        try {
            if (CLDdriver.getDriver() != null) {
                Class<?> cls = Class.forName(CLDdriver.getDriver());
                if (CLDdriver.getArg_driver() != null) {
                    this.type_args_constructor = new Class[]{SocketChannel.class, Document.class, Element.class, String.class};
                    this.args_constructor = new Object[]{this.sock, CLDdriver.getArg_driver(), this.pack, id_transaction};
                } else {
                    this.type_args_constructor = new Class[]{SocketChannel.class, Element.class, String.class};
                    this.args_constructor = new Object[]{this.sock, this.pack, id_transaction};
                }
                Constructor<?> cons = cls.getConstructor(this.type_args_constructor);
                Object obj = cons.newInstance(this.args_constructor);
                if (CLDdriver.getMethod() != null) {
                    if (CLDdriver.getArg_method() != null) {
                        this.type_args_method = new Class[]{Document.class};
                        this.args_method = new Object[]{CLDdriver.getArg_method()};
                    }
                    Method meth = cls.getMethod(CLDdriver.getMethod(), this.type_args_method);
                    meth.invoke(obj, this.args_method);
                }
            } else {
                RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + Language.getWord((String)"ERR_NOT_DRIVER"));
            }
        }
        catch (ClassNotFoundException CNFEe) {
            CNFEe.printStackTrace();
            RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + CNFEe.getMessage());
        }
        catch (NoSuchMethodException NSMEe) {
            NSMEe.printStackTrace();
            RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + NSMEe.getMessage());
        }
        catch (InstantiationException IEe) {
            IEe.printStackTrace();
            RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + IEe.getMessage());
        }
        catch (IllegalAccessException IAEe) {
            IAEe.printStackTrace();
            RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + IAEe.getMessage());
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
            RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + ITEe.getMessage());
        }
        catch (NullPointerException NPEe) {
            NPEe.printStackTrace();
            RunTransaction.errorMessage(this.sock, id_transaction, Language.getWord((String)"ERR_MODULE_LG") + "\n" + Language.getWord((String)"ERR_FOUND_DRIVER_LG"));
        }
        finally {
            this.transaction_code = null;
            this.type_args_constructor = null;
            this.type_args_method = null;
            this.args_constructor = null;
            this.args_method = null;
            this.pack = null;
            this.transaction = null;
            System.gc();
        }
    }

    public static void errorMessage(SocketChannel sock, String id_transaction, String message) {
        ErrorXML error = new ErrorXML();
        LogAdmin.setMessage((String)message, (int)0);
        SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)error.returnError(0, EmakuServerSocket.getBd(sock), id_transaction, message));
    }

    public static void errorMessage(SocketChannel sock, String id_transaction, String message, Element element) {
        ErrorXML error = new ErrorXML();
        LogAdmin.setMessage((String)message, (int)0);
        SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)error.returnError(id_transaction, message, element));
    }

    public static void successMessage(SocketChannel sock, String id_transaction, String message) {
        SuccessXML success = new SuccessXML();
        LogAdmin.setMessage((String)message, (int)2);
        SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)success.returnSuccess(id_transaction, message));
    }

    public static void successMessage(SocketChannel sock, String id_transaction, String message, Element element) {
        SuccessXML success = new SuccessXML();
        LogAdmin.setMessage((String)message, (int)2);
        SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)sock, (Document)success.returnSuccess(id_transaction, message, element));
    }
}

