/*
 * Decompiled with CFR 0.152.
 */
package server.control;

import common.comunications.SocketWriter;
import common.misc.ZipHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import server.comunications.EmakuServerSocket;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class ACPSender
extends Thread {
    private static final long serialVersionUID = -757058034217759942L;
    private Document docACPBegin;
    private String bd;
    private String[] Arrlogin;
    private ResultSet rs;
    private Statement st;
    private SocketChannel sock;
    private XMLOutputter xmlout = new XMLOutputter();

    public ACPSender(SocketChannel sock, String bd, String login) {
        this.sock = sock;
        this.bd = bd;
        this.Arrlogin = new String[]{login};
        this.SendACPBegin();
    }

    private String validPass(String pass) {
        if (pass == null) {
            return "trust";
        }
        return "password";
    }

    public void SendACPBegin() {
        Element element = new Element("ACPBegin");
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            QueryRunner runquery = new QueryRunner(this.bd, "SCS0042", this.Arrlogin);
            this.rs = runquery.ejecutarSELECT();
            this.rs.next();
            String numTrans = this.rs.getString(1);
            runquery = new QueryRunner(this.bd, "SCS0043", this.Arrlogin);
            this.rs = runquery.ejecutarSELECT();
            this.rs.next();
            String numQuerys = this.rs.getString(1);
            String company = LinkingCache.getCompanyData(EmakuServerSocket.getCompanyNameKey(this.sock));
            String companyID = LinkingCache.getCompanyData(EmakuServerSocket.getCompanyIDKey(this.sock));
            this.docACPBegin = new Document();
            this.docACPBegin.setRootElement(element);
            element.addContent((Content)new Element("companyName").setText(company));
            element.addContent((Content)new Element("companyID").setText(companyID));
            element.addContent((Content)new Element("transactions").setText(numTrans));
            element.addContent((Content)new Element("querys").setText(numQuerys));
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)this.docACPBegin);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        StatementsClosingHandler.close(this.rs);
        StatementsClosingHandler.close(this.st);
        this.rs = null;
        this.st = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            QueryRunner runquery = new QueryRunner(this.bd, "SCS0005", this.Arrlogin);
            this.rs = runquery.ejecutarSELECT();
            Document cnx = new Document();
            Element selement = new Element("SACPData");
            Element qdata = new Element("ACPData");
            Element query = new Element("query");
            while (this.rs.next()) {
                Element sql = new Element("sql");
                sql.setText(this.rs.getString("codigo"));
                sql.setAttribute("type", this.validPass(this.rs.getString("password")));
                query.addContent((Content)sql);
            }
            qdata.addContent((Content)query);
            selement.addContent((Content)qdata);
            this.rs.close();
            this.rs = null;
            runquery = new QueryRunner(this.bd, "SCS0004", this.Arrlogin);
            this.rs = runquery.ejecutarSELECT();
            while (this.rs.next()) {
                Element element = new Element("ACPData");
                try {
                    Element transaction = new Element("transaction");
                    Element driver = new Element("driver");
                    driver.setText(this.rs.getString("codigo").trim());
                    driver.setAttribute("type", this.validPass(this.rs.getString("password")));
                    ByteArrayInputStream bufferIn = new ByteArrayInputStream(this.rs.getString("perfil").getBytes());
                    SAXBuilder builder = new SAXBuilder(false);
                    Document form = builder.build((InputStream)bufferIn);
                    transaction.addContent((Content)driver);
                    transaction.addContent((Content)form.detachRootElement());
                    element.addContent((Content)transaction);
                    selement.addContent((Content)element);
                    bufferIn.close();
                    bufferIn = null;
                    form = null;
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                    System.out.println("Buffer:" + this.rs.getString("perfil"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            cnx.setRootElement(selement);
            Document doc = this.compressDocument(cnx);
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)doc);
            selement.removeContent();
            selement = null;
            doc = null;
            this.rs.close();
            this.rs = null;
            this.st.close();
            this.st = null;
            System.gc();
            SocketChannel socketChannel = this.sock;
            synchronized (socketChannel) {
                Document prueba = new Document();
                prueba.setRootElement(new Element("ACPData"));
                Element el = new Element("CACHE-QUERY").setText("CH00003");
                prueba.getRootElement().addContent((Content)el);
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)this.compressDocument(prueba));
                Document prueba2 = new Document();
                prueba2.setRootElement(new Element("ACPData"));
                Element el2 = new Element("CACHE-QUERY").setText("CH00004");
                prueba2.getRootElement().addContent((Content)el2);
                SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.sock, (Document)this.compressDocument(prueba2));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Document compressDocument(Document data) throws IOException {
        Document docZip = new Document();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.xmlout.output(data, (OutputStream)baos);
        baos.close();
        ZipHandler zip = new ZipHandler(baos, "data.xml");
        docZip.setRootElement(zip.getElementDataEncode("ACPZip"));
        return docZip;
    }
}

