/*
 * Decompiled with CFR 0.152.
 */
package server.database.connection;

import com.javaexchange.dbConnectionBroker.DbConnectionBroker;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import server.database.connection.ConnectionsPoolException;
import server.database.connection.PooledConnections;
import server.misc.settings.ConfigFileHandler;

public class ConnectionsPool {
    private static Hashtable<String, PooledConnections> Hpoolbds;
    private DbConnectionBroker myBroker;

    public static void CargarBD() throws ConnectionsPoolException {
        Hpoolbds = new Hashtable();
        int max = ConfigFileHandler.getDBSize();
        for (int i = 0; i < max; ++i) {
            try {
                LogAdmin.setMessage((String)(Language.getWord((String)"LOADING_DB") + " " + ConfigFileHandler.getDBName(i)), (int)2);
                String driver = ConfigFileHandler.getDriver(i);
                String url = ConfigFileHandler.getUrl(i);
                String user = ConfigFileHandler.getUser(i);
                String password = ConfigFileHandler.getPassword(i);
                Class.forName(driver);
                PooledConnections c = new PooledConnections(driver, url, user, password, 10);
                Hpoolbds.put(ConfigFileHandler.getDBName(i), c);
                continue;
            }
            catch (ClassNotFoundException CNFEe) {
                LogAdmin.setMessage((String)"ERR_CLASS", (String)Language.getWord((String)"ERR_CLASS"), (String)CNFEe.getMessage(), (int)0);
                throw new ConnectionsPoolException(ConfigFileHandler.getDBName(i));
            }
            catch (SQLException SQLEe) {
                LogAdmin.setMessage((String)"ERR_SQL", (String)Language.getWord((String)"ERR_SQL"), (String)SQLEe.getMessage(), (int)0);
                throw new ConnectionsPoolException(ConfigFileHandler.getDBName(i));
            }
        }
    }

    public static Connection getConnection(String nombreBD) {
        return Hpoolbds.get(nombreBD).getConnection();
    }

    public static Connection getMultiConnection(String nombreBD) {
        return Hpoolbds.get(nombreBD).getMultiConnection();
    }

    public static void freeMultiConnection(String nombreBD, Connection conn) {
        Hpoolbds.get(nombreBD).freeConnection(conn);
    }

    public static boolean chekDataBase(String DataBase) {
        return Hpoolbds.containsKey(DataBase);
    }
}

