/*
 * Decompiled with CFR 0.152.
 */
package server.database.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import server.database.connection.ConnectionReaper;
import server.database.connection.JDCConnection;

public class JDCConnectionPool {
    private Vector connections;
    private String url;
    private String user;
    private String password;
    private final long timeout = 60000L;
    private ConnectionReaper reaper;
    private final int poolsize = 10;

    public JDCConnectionPool(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.connections = new Vector(10);
        this.reaper = new ConnectionReaper(this);
        this.reaper.start();
    }

    public synchronized void reapConnections() {
        long stale = System.currentTimeMillis() - 60000L;
        Enumeration connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDCConnection conn = (JDCConnection)connlist.nextElement();
            if (!conn.inUse() || stale <= conn.getLastUse() || conn.validate()) continue;
            this.removeConnection(conn);
        }
    }

    public synchronized void closeConnections() {
        Enumeration connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDCConnection conn = (JDCConnection)connlist.nextElement();
            this.removeConnection(conn);
        }
    }

    private synchronized void removeConnection(JDCConnection conn) {
        this.connections.removeElement(conn);
    }

    public synchronized Connection getConnection() throws SQLException {
        JDCConnection c;
        for (int i = 0; i < this.connections.size(); ++i) {
            c = (JDCConnection)this.connections.elementAt(i);
            if (!c.lease()) continue;
            System.out.println("conexion asignada: " + i);
            return c;
        }
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        c = new JDCConnection(conn, this);
        c.lease();
        this.connections.addElement(c);
        return c;
    }

    public synchronized void returnConnection(JDCConnection conn) {
        conn.expireLease();
    }
}

