/*
 * Decompiled with CFR 0.152.
 */
package server.database.connection;

import com.javaexchange.dbConnectionBroker.DbConnectionBroker;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;

public class PooledConnections {
    private String driver;
    private String url;
    private String username;
    private String password;
    private Integer index = 0;
    private Connection transConnection;
    private Iterator<Connection> its;
    private int minConnections;
    private int maxConnections;
    private DbConnectionBroker myBroker;

    public PooledConnections(String driver, String url, String username, String password, int maxConnections) throws SQLException {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.maxConnections = maxConnections;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            String fileSep = System.getProperty("file.separator");
            String logFile = fileSep + tmpDir + fileSep + "poolConections";
            this.myBroker = new DbConnectionBroker(driver, url, username, password, 2, 8, logFile, 1.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.transConnection = DriverManager.getConnection(url, username, password);
    }

    public Connection getConnection() {
        return this.transConnection;
    }

    public Connection getMultiConnection() {
        return this.myBroker.getConnection();
    }

    public int getIdMultiConnection(Connection conn) {
        return this.myBroker.idOfConnection(conn);
    }

    public void freeConnection(Connection conn) {
        this.myBroker.freeConnection(conn);
    }
}

