/*
 * Decompiled with CFR 0.152.
 */
package server.database.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jdom.Element;
import server.database.connection.ConnectionsPool;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class QueryRunner
extends Element {
    private static final long serialVersionUID = -5369073295276204778L;
    private String bd;
    private String cod_sql;
    private Statement st;
    private String sql;

    public QueryRunner(String bd, String cod_sql) throws SQLNotFoundException, SQLBadArgumentsException {
        this.bd = bd;
        this.cod_sql = cod_sql;
        this.sql = SQLFormatAgent.getSentencia(bd, cod_sql);
    }

    public QueryRunner(String bd, String cod_sql, String[] args) throws SQLNotFoundException, SQLBadArgumentsException {
        this.bd = bd;
        this.cod_sql = cod_sql;
        this.sql = SQLFormatAgent.getSentencia(bd, cod_sql, args);
    }

    public QueryRunner(String bd, String cache, String sql) {
        this.bd = bd;
        this.cod_sql = cache;
        this.sql = sql;
    }

    public QueryRunner(String bd) {
        this.bd = bd;
    }

    public ResultSet ejecutarSELECT() throws SQLException {
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            ResultSet rs = this.st.executeQuery(this.sql);
            return rs;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public ResultSet ejecutarMTSELECT(Connection conn) throws SQLException {
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(this.sql);
            return rs;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(this.cod_sql + " " + SQLEe.getMessage() + " " + SQLEe.getErrorCode());
        }
    }

    public boolean ejecutarSQL(String cod_sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.cod_sql = cod_sql;
            System.out.println("Estos son los argumentos: ");
            for (String a : args) {
                System.out.println("a: " + a);
            }
            this.sql = SQLFormatAgent.getSentencia(this.bd, cod_sql, args);
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarSQL(String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        try {
            this.sql = SQLFormatAgent.getSentencia(this.bd, this.cod_sql, args);
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException("SQL " + this.sql + " code " + this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public boolean ejecutarSQL() throws SQLException {
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            boolean status = this.st.execute(this.sql);
            this.st.close();
            this.st = null;
            return status;
        }
        catch (SQLException SQLEe) {
            throw new SQLException(this.cod_sql + " " + SQLEe.getMessage());
        }
    }

    public void closeStatement() {
        StatementsClosingHandler.close(this.st);
        this.st = null;
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            ConnectionsPool.getConnection(this.bd).setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commit() {
        try {
            ConnectionsPool.getConnection(this.bd).commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void rollback() {
        try {
            ConnectionsPool.getConnection(this.bd).rollback();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

