/*
 * Decompiled with CFR 0.152.
 */
package server.reports;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import common.comunications.SocketWriter;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.misc.text.DateValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import org.jdom.Content;
import org.jdom.Document;
import server.comunications.EmakuServerSocket;
import server.control.ReportsStore;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.misc.ServerConstants;
import server.misc.settings.ConfigFileHandler;
import server.reports.HorizontalFiller;
import server.reports.PhantomDataSource;
import server.reports.VerticalFiller;

public class ReportMaker
extends Thread {
    private String codigo;
    private String id;
    private String[] args;
    private org.jdom.Element element;
    private SocketChannel socket;
    private String dataBase;
    private boolean reportType;

    public ReportMaker(org.jdom.Element element, SocketChannel sock, boolean reportType) {
        this.element = element;
        this.socket = sock;
        this.dataBase = EmakuServerSocket.getBd(this.socket);
        this.reportType = reportType;
    }

    public ReportMaker() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    HashMap parameters = new HashMap();
                    JRBaseFiller filler = ReportMaker.this.createFiller(ReportsStore.getReportClass("REP0000"));
                    JasperPrint jasperPrint = filler.fill(parameters, (JRDataSource)new PhantomDataSource());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)os);
                    os.close();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    @Override
    public void run() {
        try {
            org.jdom.Element titleReport;
            Connection conn;
            Calendar calendar = Calendar.getInstance();
            long init = calendar.getTimeInMillis();
            this.codigo = this.element.getChildText("driver");
            while (true) {
                try {
                    while ((conn = ConnectionsPool.getMultiConnection(this.dataBase)) == null) {
                        System.out.println("Dio null :S");
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            ResultSet rs = new QueryRunner(this.dataBase, "SCS0050", new String[]{this.codigo}).ejecutarMTSELECT(conn);
            boolean next = rs.next();
            String title = null;
            String sql = null;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Document docZip = new Document();
            if (next) {
                System.out.println("Generando reporte No. " + this.codigo);
                title = rs.getString(1);
                sql = rs.getString(2).trim();
                this.id = this.element.getChildText("id");
                List list = this.element.getChild("package").getChildren();
                Iterator it = list.iterator();
                this.args = new String[list.size()];
                rs.close();
                rs = null;
                if (list.size() > 0) {
                    int i = 0;
                    while (it.hasNext()) {
                        org.jdom.Element arg = (org.jdom.Element)it.next();
                        this.args[i] = arg.getValue();
                        ++i;
                    }
                    rs = new QueryRunner(EmakuServerSocket.getBd(this.socket), sql, this.args).ejecutarMTSELECT(conn);
                } else {
                    rs = new QueryRunner(EmakuServerSocket.getBd(this.socket), sql).ejecutarMTSELECT(conn);
                }
                int resultSize = rs.getFetchSize();
                if (resultSize == 0) {
                    os = this.paintPDFMessage(os, "/reports/images/report_noresult_", false);
                } else {
                    JRResultSetDataSource jrRS = new JRResultSetDataSource(rs);
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    String company = LinkingCache.getCompanyData(EmakuServerSocket.getCompanyNameKey(this.socket));
                    String companyID = LinkingCache.getCompanyData(EmakuServerSocket.getCompanyIDKey(this.socket));
                    String address = LinkingCache.getAddress(EmakuServerSocket.getBd(this.socket));
                    String phone = LinkingCache.getPhone(EmakuServerSocket.getBd(this.socket));
                    String city = LinkingCache.getCity(EmakuServerSocket.getBd(this.socket));
                    if (company == null) {
                        company = Language.getWord((String)"DATANOTFOUND");
                    }
                    if (companyID == null) {
                        companyID = Language.getWord((String)"DATANOTFOUND");
                    }
                    parameters.put("Empresa", company);
                    parameters.put("Nit", companyID);
                    parameters.put("Direccion", address);
                    parameters.put("Telefono", phone);
                    parameters.put("Ciudad", city);
                    parameters.put("Fecha", DateValidator.getFormattedDate());
                    parameters.put("Qhatu", "Reporte elaborado con eMaku");
                    JRBaseFiller filler = this.createFiller(ReportsStore.getReportClass(this.codigo));
                    JasperPrint jasperPrint = filler.fill(parameters, (JRDataSource)jrRS);
                    if (this.reportType) {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int cols = rsmd.getColumnCount();
                        String headers = "";
                        for (int i = 1; i <= cols; ++i) {
                            headers = headers + rsmd.getColumnClassName(i) + "\t";
                        }
                        headers = headers + "\n";
                        os.write(headers.getBytes());
                        JRCsvExporter exporter = new JRCsvExporter();
                        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
                        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)"\t");
                        exporter.exportReport();
                    } else {
                        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)os);
                    }
                }
                titleReport = new org.jdom.Element("titleReport").setText(title);
            } else {
                os = this.paintPDFMessage(os, "/reports/images/report_nf_", true);
                titleReport = new org.jdom.Element("titleReport").setText(Language.getWord((String)"REP_ERROR"));
            }
            os.close();
            String fileType = "REPORT";
            String fileName = "report.pdf";
            if (this.reportType) {
                fileType = "PLAINREPORT";
                fileName = "report.csv";
            }
            System.out.println("Empaquetando Reporte...");
            org.jdom.Element root = new org.jdom.Element(fileType);
            org.jdom.Element id = new org.jdom.Element("id").setText(this.id);
            org.jdom.Element idReport = new org.jdom.Element("idReport").setText(this.codigo);
            root.addContent((Content)id);
            root.addContent((Content)idReport);
            root.addContent((Content)titleReport);
            ZipHandler zip = new ZipHandler(os, fileName);
            System.out.println("Reporte empaquetado...");
            root.addContent((Content)zip.getElementDataEncode("data"));
            docZip.setRootElement(root);
            calendar = Calendar.getInstance();
            long end = calendar.getTimeInMillis();
            System.out.println("Generador en " + (end - init) / 1000L + " segundos ");
            System.out.println("Escribiendo paquete ....");
            calendar = Calendar.getInstance();
            init = calendar.getTimeInMillis();
            SocketWriter.writing((Hashtable)EmakuServerSocket.getHchannelclients(), (SocketChannel)this.socket, (Document)docZip);
            calendar = Calendar.getInstance();
            end = calendar.getTimeInMillis();
            System.out.println("paquete escrito en " + (end - init) / 1000L + " segundos");
            rs.close();
            conn.close();
            rs = null;
            conn = null;
            os.close();
            os = null;
            System.gc();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ByteArrayOutputStream paintPDFMessage(ByteArrayOutputStream os, String path, boolean flag) {
        com.lowagie.text.Document pdfDoc = new com.lowagie.text.Document(new Rectangle(400.0f, 200.0f), 10.0f, 10.0f, 10.0f, 10.0f);
        try {
            PdfWriter.getInstance((com.lowagie.text.Document)pdfDoc, (OutputStream)os);
            pdfDoc.open();
            Image png = Image.getInstance((String)(ServerConstants.EMAKU_HOME + path + ConfigFileHandler.getLocal() + ".png"));
            png.setAlignment(1);
            pdfDoc.add((Element)png);
            if (flag) {
                Chunk chunck = new Chunk(Language.getWord((String)"REFERENCE") + " " + this.codigo);
                chunck.setFont(new Font(1, 12.0f));
                Paragraph p = new Paragraph();
                p.setAlignment(1);
                p.add((Object)chunck);
                pdfDoc.add((Element)p);
            }
            pdfDoc.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return os;
    }

    public JRBaseFiller createFiller(JasperReport jasperReport) throws JRException {
        Object filler = null;
        switch (jasperReport.getPrintOrder()) {
            case 2: {
                filler = new HorizontalFiller(jasperReport);
                break;
            }
            case 1: {
                filler = new VerticalFiller(jasperReport);
            }
        }
        return filler;
    }
}

