/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.CacheKeys;
import server.businessrules.LNErrorProcecuteException;
import server.businessrules.LNInventarios;
import server.database.connection.ConnectionsPool;
import server.database.sql.ComboProductos;
import server.database.sql.DontHaveKeyException;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class LNContabilidad {
    private Vector<String> colData;
    private Vector<String> colAccount;
    private int colIdProdServ = -1;
    private int colIdActivo = -1;
    private int colIdTercero = -1;
    private Vector<String> accountFields;
    private Vector<String> typeRegister;
    private int accountData;
    private int accountKey = -1;
    private int accountTh = -1;
    private int accountAc = -1;
    private int accountPS = -1;
    private int accountConcept = -1;
    private Boolean naturaleza;
    private String bd;
    private String codeAPS;
    private String concepto;
    private String tercero;
    private String inventario;
    private String activo;
    private String centroCosto;
    private String scentroCosto;
    private String vinculo;
    private String constantTh;
    private String constantAct;
    private String sqlData;
    private double base;
    private int colCost = -1;
    private int type;
    private final int DUAL = 0;
    private final int D2649 = 1;
    private final int NIIFS = 2;
    private boolean debug;
    private static Hashtable<String, Boolean> cacheNat = new Hashtable();
    private HashMap<Integer, LNInventarios.RecoverData> recoverList = new HashMap();
    private final int LIBRO_AUX_INV = 0;
    private final int LIBRO_AUX_TER = 1;
    private final int LIBRO_AUX_ACT = 2;
    private final int LIBRO_AUX_TER_INV = 3;

    public LNContabilidad(String bd) {
        this.bd = bd;
        this.type = 0;
    }

    public LNContabilidad(String bd, int type) {
        this.bd = bd;
        this.type = type;
    }

    public LNContabilidad(Element parameters, String bd, int type) {
        this.bd = bd;
        this.type = type;
        this.buildParameters(parameters);
    }

    public LNContabilidad(Element parameters, String bd) {
        this.bd = bd;
        this.buildParameters(parameters);
    }

    private void buildParameters(Element parameters) {
        this.colData = new Vector();
        this.colAccount = new Vector();
        this.accountFields = new Vector();
        this.typeRegister = new Vector();
        for (Element e : parameters.getChildren()) {
            String attribute = e.getAttributeValue("attribute");
            if (attribute != null) {
                attribute = attribute.toLowerCase();
            }
            if ("codeaps".equals(attribute)) {
                this.codeAPS = e.getValue();
                continue;
            }
            if ("base".equals(attribute)) {
                try {
                    this.base = 0.0;
                }
                catch (NumberFormatException NFEe) {
                    this.base = 0.0;
                }
                continue;
            }
            if ("concepto".equals(attribute)) {
                this.concepto = e.getValue().trim();
                continue;
            }
            if ("naturaleza".equals(attribute)) {
                if ("d".equals(e.getValue()) || "D".equals(e.getValue())) {
                    this.naturaleza = new Boolean("true");
                    continue;
                }
                if (!"c".equals(e.getValue()) && !"C".equals(e.getValue())) continue;
                this.naturaleza = new Boolean("false");
                continue;
            }
            if ("debuging".equals(attribute)) {
                this.debug = Boolean.parseBoolean(e.getValue());
                continue;
            }
            if ("tercero".equals(attribute)) {
                this.tercero = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("activo".equals(attribute)) {
                this.activo = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("inventario".equals(attribute)) {
                this.inventario = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("centrocosto".equals(attribute)) {
                this.centroCosto = e.getValue().toLowerCase().trim();
                System.out.println("almacenando cc " + this.centroCosto);
                continue;
            }
            if ("scentrocosto".equals(attribute)) {
                this.scentroCosto = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("vinculo".equals(attribute)) {
                this.vinculo = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("constantth".equals(attribute)) {
                this.constantTh = e.getValue().toLowerCase().trim();
                continue;
            }
            if ("sqlcode".equals(attribute)) {
                this.sqlData = e.getValue().trim();
                continue;
            }
            if (!"subarg".equals(e.getName())) continue;
            for (Element f : e.getChildren()) {
                String col;
                String account;
                StringTokenizer STval;
                if ("accountCol".equals(f.getAttributeValue("attribute"))) {
                    try {
                        STval = new StringTokenizer(f.getValue(), ",");
                        account = STval.nextToken();
                        col = STval.nextToken();
                        this.colData.addElement(col);
                        System.out.println("Account: " + col);
                        if (account.equals("getName")) {
                            System.out.println("Desde getName " + CacheKeys.getKey("account"));
                            this.colAccount.addElement(CacheKeys.getKey("account"));
                            continue;
                        }
                        System.out.println("Su valor...");
                        this.colAccount.addElement(account);
                    }
                    catch (NoSuchElementException NSEEe) {
                        NSEEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountCostCol".equals(f.getAttributeValue("attribute"))) {
                    try {
                        STval = new StringTokenizer(f.getValue(), ",");
                        account = STval.nextToken();
                        col = STval.nextToken();
                        this.colData.addElement(col);
                        this.colAccount.addElement(account);
                        try {
                            this.colCost = Integer.parseInt(col);
                        }
                        catch (NumberFormatException NFEe) {
                            this.colCost = -1;
                        }
                    }
                    catch (NoSuchElementException NSEEe) {
                        NSEEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountField".equals(f.getAttributeValue("attribute"))) {
                    try {
                        STval = new StringTokenizer(f.getValue(), ",");
                        account = STval.nextToken();
                        String register = STval.nextToken();
                        this.accountFields.addElement(account);
                        this.typeRegister.addElement(register);
                    }
                    catch (NoSuchElementException NSEEe) {
                        NSEEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountKey".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountKey = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountKey = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountTh".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountTh = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountTh = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountPS".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountPS = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountPS = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountAc".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountAc = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountAc = -1;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if ("accountData".equals(f.getAttributeValue("attribute"))) {
                    try {
                        this.accountData = Integer.parseInt(f.getValue());
                    }
                    catch (NumberFormatException NFEe) {
                        this.accountData = 0;
                        NFEe.printStackTrace();
                    }
                    continue;
                }
                if (!"accountConcept".equals(f.getAttributeValue("attribute"))) continue;
                this.accountConcept = Integer.parseInt(f.getValue());
            }
        }
    }

    public double fieldData(Element pack) throws DontHaveKeyException, SQLNotFoundException, SQLBadArgumentsException, SQLException {
        double partidaDoble = 0.0;
        Iterator ipack = pack.getChildren().iterator();
        double valueAccount = 0.0;
        for (int i = 0; i < this.accountFields.size(); ++i) {
            String th;
            double baseAccount;
            String account = this.accountFields.get(i);
            System.out.println("Account: " + account);
            if (account.equals("key")) {
                account = CacheKeys.getKey("cuenta");
            }
            Element element = (Element)ipack.next();
            String value = element.getValue();
            if (this.sqlData != null) {
                Statement st = ConnectionsPool.getConnection(this.bd).createStatement();
                ResultSet rs = null;
                rs = !value.equals("") ? st.executeQuery(SQLFormatAgent.getSentencia(this.bd, this.sqlData, new String[]{value})) : st.executeQuery(SQLFormatAgent.getSentencia(this.bd, this.sqlData));
                while (rs.next()) {
                    valueAccount = rs.getDouble(1);
                }
                StatementsClosingHandler.close(st);
                StatementsClosingHandler.close(rs);
                st = null;
                rs = null;
            } else {
                try {
                    valueAccount = Double.parseDouble(value);
                }
                catch (NumberFormatException NFEe) {
                    valueAccount = 0.0;
                }
            }
            if (valueAccount == 0.0 || !((baseAccount = LinkingCache.getPCBase(this.bd, account.trim())) >= this.base)) continue;
            String type = this.typeRegister.get(i);
            boolean debito = type.equals("D") || type.equals("d");
            if (valueAccount < 0.0) {
                valueAccount = Math.abs(valueAccount);
                debito = !debito;
            }
            String idCta = LinkingCache.getPCIdCta(this.bd, account);
            if (LinkingCache.isPCTerceros(this.bd, account) && LinkingCache.isPCInventarios(this.bd, account)) {
                th = this.constantTh != null ? this.constantTh : CacheKeys.getKey("idTercero");
                System.out.println("tercero: " + th);
                this.asientosConTipo(idCta, valueAccount, th, CacheKeys.getKey("idProdServ"), debito, 3, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCTerceros(this.bd, account)) {
                th = this.constantTh != null ? this.constantTh : CacheKeys.getKey("idTercero");
                System.out.println("tercero: " + th);
                this.asientosConTipo(idCta, valueAccount, th, debito, 1, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCActivos(this.bd, account)) {
                String act = this.constantAct != null ? this.constantAct : CacheKeys.getKey("idActivo");
                System.out.println("activo: " + act);
                this.asientosConTipo(idCta, valueAccount, act, debito, 2, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCInventarios(this.bd, account)) {
                this.asientosConTipo(idCta, valueAccount, CacheKeys.getKey("idProdServ"), debito, 0, LinkingCache.isPCNaturaleza(this.bd, account));
            } else {
                this.asientosDetalle(idCta, valueAccount, debito, LinkingCache.isPCNaturaleza(this.bd, account));
            }
            if (debito) {
                partidaDoble += valueAccount;
                continue;
            }
            partidaDoble -= valueAccount;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(partidaDoble);
            bigDecimal = bigDecimal.setScale(2, 4);
            partidaDoble = bigDecimal.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return partidaDoble;
    }

    public double rowDataAccount(Element pack) throws DontHaveKeyException, SQLException, SQLNotFoundException, SQLBadArgumentsException {
        double valor;
        double partidaDoble = 0.0;
        Iterator i = pack.getChildren().iterator();
        String[] asiento = new String[9];
        asiento[0] = CacheKeys.getKey("ndocumento");
        asiento[1] = CacheKeys.getDate();
        asiento[2] = this.concepto;
        for (int k = 2; i.hasNext() && k < asiento.length; ++k) {
            Element elm2;
            if (k == 2 && this.concepto != null) {
                asiento[2] = this.concepto;
            } else if (k == 3 && this.centroCosto != null) {
                asiento[k] = this.centroCosto.equals("getname") && CacheKeys.getKey("centrocosto") != null ? CacheKeys.getKey("centrocosto") : (this.centroCosto.equals("notdata") ? "NULL" : "NULL");
            } else if (k == 5) {
                elm2 = (Element)i.next();
                asiento[k] = "NULL";
                if (LinkingCache.isPCTerceros(this.bd, asiento[4])) {
                    if (!"".equals(elm2.getText()) && !"NULL".equals(elm2.getText())) {
                        asiento[k] = elm2.getText().trim();
                    } else if ("getname".equals(this.tercero) && CacheKeys.getKey("idTercero") != null) {
                        asiento[k] = CacheKeys.getKey("idTercero");
                    } else if (this.tercero.equals("notdata")) {
                        asiento[k] = "NULL";
                    }
                }
            } else if (k == 6 && this.inventario != null) {
                asiento[k] = this.inventario.equals("getname") && CacheKeys.getKey("inventario") != null && LinkingCache.isPCInventarios(this.bd, asiento[4]) ? CacheKeys.getKey("inventario") : (this.inventario.equals("notdata") ? "NULL" : "NULL");
            } else {
                elm2 = (Element)i.next();
                asiento[k] = elm2.getText().trim();
            }
            if (!this.debug) continue;
            System.out.println("asiento[" + k + "] = " + asiento[k]);
        }
        double debito = Double.parseDouble(asiento[7]);
        double credito = Double.parseDouble(asiento[8]);
        if (debito < 0.0) {
            asiento[7] = "0";
            asiento[8] = String.valueOf(this.roundValue(Math.abs(debito)));
        } else if (credito < 0.0) {
            asiento[7] = String.valueOf(this.roundValue(Math.abs(credito)));
            asiento[8] = "0";
        }
        if (this.debug) {
            System.out.println("debito: [" + asiento[7] + "]  credito: [" + asiento[8] + "]");
        }
        if ((valor = Double.parseDouble(asiento[7]) + Double.parseDouble(asiento[8])) > 0.0) {
            if (this.debug) {
                System.out.println("generando ...");
            }
            boolean natCta = LinkingCache.isPCNaturaleza(this.bd, asiento[4]);
            asiento[4] = LinkingCache.getPCIdCta(this.bd, asiento[4]);
            double movimiento = 0.0;
            if (Double.parseDouble(asiento[7]) != 0.0) {
                movimiento = Double.parseDouble(asiento[7]);
                partidaDoble += movimiento;
            } else {
                movimiento = Double.parseDouble(asiento[8]);
                partidaDoble -= movimiento;
                try {
                    BigDecimal bigDecimal = new BigDecimal(partidaDoble);
                    bigDecimal = bigDecimal.setScale(2, 4);
                    partidaDoble = bigDecimal.doubleValue();
                }
                catch (NumberFormatException bigDecimal) {
                    // empty catch block
                }
                if (this.debug) {
                    System.out.println("Movimiento: " + movimiento + " Partida doble rowDataAccount: " + partidaDoble);
                }
            }
            System.out.println("longitud del asiento: " + asiento.length + " tipo: " + this.type);
            for (int j = 0; j < asiento.length; ++j) {
                System.out.println("posicion: " + j + " Valor: " + asiento[j]);
            }
            if (this.type == 0) {
                new QueryRunner(this.bd, "SCI0014", asiento).ejecutarSQL();
                new QueryRunner(this.bd, "SCINIFS01", asiento).ejecutarSQL();
            } else if (this.type == 1) {
                new QueryRunner(this.bd, "SCI0014", asiento).ejecutarSQL();
            } else if (this.type == 2) {
                new QueryRunner(this.bd, "SCINIFS01", asiento).ejecutarSQL();
            }
        }
        return partidaDoble;
    }

    public double rowDataAccountSC(Element pack) throws DontHaveKeyException, SQLException, SQLNotFoundException, SQLBadArgumentsException {
        double valor;
        double partidaDoble = 0.0;
        Iterator i = pack.getChildren().iterator();
        String[] asiento = new String[13];
        asiento[0] = CacheKeys.getKey("ndocumento");
        asiento[1] = CacheKeys.getDate();
        System.out.println("concepto: " + this.concepto);
        for (int k = 2; i.hasNext() && k < asiento.length; ++k) {
            Element elm2;
            if (k == 2 && this.concepto != null) {
                asiento[2] = this.concepto;
            } else if (k == 3 && this.centroCosto != null) {
                asiento[k] = this.centroCosto.equals("getname") && CacheKeys.getKey("centrocosto") != null ? CacheKeys.getKey("centrocosto") : (this.centroCosto.equals("notdata") ? "NULL" : "NULL");
                System.out.println("Centrocosto: " + asiento[k]);
            } else if (k == 4 && this.scentroCosto != null) {
                asiento[k] = this.scentroCosto.equals("getname") && CacheKeys.getKey("scentrocosto") != null ? CacheKeys.getKey("scentrocosto") : (this.scentroCosto.equals("notdata") ? "NULL" : "NULL");
                System.out.println("SCentrocosto: " + asiento[k]);
            } else if (k == 5 && this.vinculo != null) {
                asiento[k] = this.vinculo.equals("getname") && CacheKeys.getKey("vinculo") != null ? CacheKeys.getKey("vinculo") : (this.vinculo.equals("notdata") ? "NULL" : "NULL");
                System.out.println("vinculo: " + asiento[k]);
            } else if (k == 7) {
                if (!LinkingCache.isPCCentro(this.bd, asiento[6])) {
                    asiento[3] = "NULL";
                }
                if (!LinkingCache.isPCSCentro(this.bd, asiento[6])) {
                    asiento[4] = "NULL";
                }
                if (!LinkingCache.isPCVinculo(this.bd, asiento[6])) {
                    System.out.println("la cuenta " + asiento[6] + " no es vinculada");
                    asiento[5] = "NULL";
                }
                elm2 = (Element)i.next();
                asiento[k] = "NULL";
                if (LinkingCache.isPCTerceros(this.bd, asiento[6])) {
                    if (!"".equals(elm2.getText()) && !"NULL".equals(elm2.getText())) {
                        asiento[k] = elm2.getText().trim();
                    } else if ("getname".equals(this.tercero) && CacheKeys.getKey("idTercero") != null) {
                        asiento[k] = CacheKeys.getKey("idTercero");
                    } else if (this.tercero.equals("notdata")) {
                        asiento[k] = "NULL";
                    }
                }
            } else if (k == 8 && this.inventario != null) {
                asiento[k] = this.inventario.equals("getname") && CacheKeys.getKey("inventario") != null && LinkingCache.isPCInventarios(this.bd, asiento[6]) ? CacheKeys.getKey("inventario") : (this.inventario.equals("notdata") ? "NULL" : "NULL");
            } else if (k == 12) {
                System.out.println("validando 12");
                asiento[k] = "NULL";
                elm2 = (Element)i.next();
                if (LinkingCache.isPCActivos(this.bd, asiento[6])) {
                    if (!"".equals(elm2.getText()) && !"NULL".equals(elm2.getText())) {
                        asiento[k] = elm2.getText().trim();
                    } else if ("getname".equals(this.activo) && CacheKeys.getKey("idActivo") != null) {
                        asiento[k] = CacheKeys.getKey("idActivo");
                    } else if (this.activo.equals("notdata")) {
                        asiento[k] = "NULL";
                    }
                }
            } else {
                elm2 = (Element)i.next();
                asiento[k] = elm2.getText().trim();
            }
            System.out.println("indice " + k + " valor " + asiento[k]);
            if (!this.debug) continue;
            System.out.println("asiento[" + k + "] = " + asiento[k]);
        }
        System.out.println("---------------------------------------------");
        double debito = Double.parseDouble(asiento[10]);
        double credito = Double.parseDouble(asiento[11]);
        if (debito < 0.0) {
            asiento[10] = "0";
            asiento[11] = String.valueOf(this.roundValue(Math.abs(debito)));
        } else if (credito < 0.0) {
            asiento[10] = String.valueOf(this.roundValue(Math.abs(credito)));
            asiento[11] = "0";
        }
        if (this.debug) {
            System.out.println("debito: [" + asiento[10] + "]  credito: [" + asiento[11] + "]");
        }
        if ((valor = Double.parseDouble(asiento[10]) + Double.parseDouble(asiento[11])) > 0.0) {
            if (this.debug) {
                System.out.println("generando ...");
            }
            boolean natCta = LinkingCache.isPCNaturaleza(this.bd, asiento[6]);
            asiento[6] = LinkingCache.getPCIdCta(this.bd, asiento[6]);
            double movimiento = 0.0;
            if (Double.parseDouble(asiento[10]) != 0.0) {
                movimiento = Double.parseDouble(asiento[10]);
                partidaDoble += movimiento;
            } else {
                movimiento = Double.parseDouble(asiento[11]);
                partidaDoble -= movimiento;
                try {
                    BigDecimal bigDecimal = new BigDecimal(partidaDoble);
                    bigDecimal = bigDecimal.setScale(2, 4);
                    partidaDoble = bigDecimal.doubleValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.debug) {
                    System.out.println("Movimiento: " + movimiento + " Partida doble rowDataAccount: " + partidaDoble);
                }
            }
            if (this.type == 0) {
                new QueryRunner(this.bd, "SCI0024", asiento).ejecutarSQL();
                new QueryRunner(this.bd, "SCINIFS02", asiento).ejecutarSQL();
            } else if (this.type == 1) {
                new QueryRunner(this.bd, "SCI0024", asiento).ejecutarSQL();
            } else if (this.type == 2) {
                new QueryRunner(this.bd, "SCINIFS02", asiento).ejecutarSQL();
            }
        }
        return partidaDoble;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double columDataAccount(Element pack) throws DontHaveKeyException, SQLNotFoundException, SQLBadArgumentsException, SQLException, LNErrorProcecuteException {
        double partidaDoble = 0.0;
        String idCta = "";
        String value = "";
        double valueAccount = 0.0;
        List lpack = pack.getChildren();
        if (this.accountKey == -1) throw new LNErrorProcecuteException("AccountKey = -1");
        String charCta = null;
        charCta = this.accountKey >= 999 ? (this.accountKey == 999 ? CacheKeys.getKey("cuenta") : String.valueOf(this.accountKey)) : ((Element)lpack.get(this.accountKey)).getValue();
        value = ((Element)lpack.get(this.accountData)).getValue();
        idCta = LinkingCache.getPCIdCta(this.bd, charCta.trim());
        if (this.accountConcept != -1) {
            this.concepto = ((Element)lpack.get(this.accountConcept)).getValue();
        }
        try {
            valueAccount = Double.parseDouble(value);
        }
        catch (NumberFormatException NFEe) {
            valueAccount = 0.0;
        }
        if (valueAccount != 0.0) {
            if (valueAccount < 0.0) {
                valueAccount = Math.abs(valueAccount);
                this.naturaleza = this.naturaleza == false;
            }
            if (LinkingCache.isPCTerceros(this.bd, charCta.trim()) && LinkingCache.isPCInventarios(this.bd, charCta.trim())) {
                String th = null;
                if (this.accountTh >= 0) {
                    th = ((Element)lpack.get(this.accountTh)).getValue();
                } else {
                    if (!"getname".equals(this.tercero)) throw new LNErrorProcecuteException("Cuenta: " + charCta + "-- getname: " + this.tercero + " llave: " + CacheKeys.getKey("idTercero") + " LinkingCache es de terceros, accountTH = 0 tercero no es gtname");
                    if (CacheKeys.getKey("idTercero") == null) throw new LNErrorProcecuteException("Cuenta: " + charCta + "-- getname: " + this.tercero + " llave: " + CacheKeys.getKey("idTercero") + " LinkingCache es de terceros, accountTH = 0 tercero no es gtname");
                    th = CacheKeys.getKey("idTercero");
                }
                String idProdServ = null;
                if (this.accountPS < 0) throw new LNErrorProcecuteException("Cuenta: " + charCta + " LinkingCache es de Inventarios pero accountPS <0");
                idProdServ = ((Element)lpack.get(this.accountPS)).getValue();
                this.asientosConTipo(idCta, valueAccount, th, idProdServ, this.naturaleza, 3, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
            } else if (LinkingCache.isPCTerceros(this.bd, charCta.trim())) {
                if (this.accountTh >= 0) {
                    this.asientosConTipo(idCta, valueAccount, ((Element)lpack.get(this.accountTh)).getValue(), this.naturaleza, 1, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
                } else {
                    if (!"getname".equals(this.tercero)) throw new LNErrorProcecuteException("Cuenta: " + charCta + "-- getname: " + this.tercero + " llave: " + CacheKeys.getKey("idTercero") + " LinkingCache es de terceros, accountTH = 0 tercero no es gtname");
                    if (CacheKeys.getKey("idTercero") == null) throw new LNErrorProcecuteException("Cuenta: " + charCta + "-- getname: " + this.tercero + " llave: " + CacheKeys.getKey("idTercero") + " LinkingCache es de terceros, accountTH = 0 tercero no es gtname");
                    this.asientosConTipo(idCta, valueAccount, CacheKeys.getKey("idTercero"), this.naturaleza, 1, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
                }
            } else if (LinkingCache.isPCActivos(this.bd, charCta.trim())) {
                if (this.accountAc < 0) throw new LNErrorProcecuteException("Cuenta: " + charCta + " LinkingCache es de activos y accountAc = 0");
                this.asientosConTipo(idCta, valueAccount, ((Element)lpack.get(this.accountAc)).getValue(), this.naturaleza, 2, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
            } else if (LinkingCache.isPCInventarios(this.bd, charCta.trim())) {
                if (this.accountPS < 0) throw new LNErrorProcecuteException("Cuenta: " + charCta + " LinkingCache es de Inventarios pero accountPS <0");
                this.asientosConTipo(idCta, valueAccount, ((Element)lpack.get(this.accountPS)).getValue(), this.naturaleza, 0, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
            } else {
                this.asientosDetalle(idCta, valueAccount, this.naturaleza, LinkingCache.isPCNaturaleza(this.bd, charCta.trim()));
            }
            partidaDoble = this.naturaleza.booleanValue() ? (partidaDoble += valueAccount) : (partidaDoble -= valueAccount);
            if (this.debug) {
                System.out.println("partida doble columnDataAccount: " + partidaDoble);
            }
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(partidaDoble);
            bigDecimal = bigDecimal.setScale(2, 4);
            return bigDecimal.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return partidaDoble;
    }

    public double columnComboData(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        String idProducto = null;
        double cantidad = 0.0;
        for (Element field : pack.getChildren()) {
            String nameField = field.getAttributeValue("name");
            if ("idProducto".equals(nameField)) {
                idProducto = field.getValue();
            }
            if (!"cantidad".equals(nameField)) continue;
            cantidad = Double.parseDouble(field.getValue());
        }
        if (idProducto != null) {
            ArrayList<ComboProductos> combos = LinkingCache.getComboProductos(this.bd, idProducto);
            if (combos != null) {
                for (ComboProductos cb : combos) {
                    Element comboPack = new Element("subPackage");
                    Element fieldProd = new Element("field");
                    fieldProd.setAttribute("name", "idProducto");
                    fieldProd.setText(String.valueOf(cb.getIdProdServ()));
                    comboPack.addContent((Content)fieldProd);
                    Element fieldCant = new Element("field");
                    fieldCant.setAttribute("name", "cantidad");
                    fieldCant.setText(String.valueOf((double)cb.getCantidad() * cantidad));
                    comboPack.addContent((Content)fieldCant);
                }
            } else {
                return this.columnData(pack);
            }
            return 0.0;
        }
        return this.columnData(pack);
    }

    public double columnData(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        try {
            xmlOutputter.output(pack, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double partidaDoble = 0.0;
        List colElement = pack.getChildren();
        for (int k = 0; k < this.colData.size(); ++k) {
            Element eIdTercero;
            String idTercero;
            BigDecimal bigDecimal3;
            String bodega;
            double valueAccount;
            System.out.println("-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-");
            int col = Integer.parseInt(this.colData.get(k));
            Element element = (Element)colElement.get(col);
            String value = element.getValue();
            try {
                valueAccount = Double.parseDouble(value);
            }
            catch (NumberFormatException NFEe) {
                System.out.println("numver format de " + value);
                valueAccount = 0.0;
            }
            String idProdServ = "";
            String idActivo = "";
            boolean debito = false;
            String account = this.colAccount.get(k);
            System.out.println("cuenta: " + account);
            if (this.getColIdProdServ() > -1) {
                Element eIdProdServ = (Element)colElement.get(this.getColIdProdServ());
                idProdServ = eIdProdServ.getText();
                System.out.println("columna idProdServ: " + this.getColIdProdServ() + " idProdServ: " + idProdServ);
            } else {
                idProdServ = "";
            }
            if (this.getColIdActivo() > -1) {
                Element eIdActivo = (Element)colElement.get(this.getColIdActivo());
                idActivo = eIdActivo.getText();
                System.out.println("columna idActivo: " + this.getColIdActivo() + " idActivo: " + idActivo);
            } else {
                idActivo = "";
            }
            boolean cuentaregistrada = true;
            if (this.naturaleza == null) {
                String code = LinkingCache.getIdAsientosPr(this.bd, idProdServ, this.codeAPS);
                System.out.println("code: " + code + " idProdServ " + idProdServ + " codeaps " + this.codeAPS);
                try {
                    debito = LinkingCache.isAsientoDebito(this.bd, code, account);
                }
                catch (DontHaveKeyException DHKEe) {
                    DHKEe.printStackTrace();
                    cuentaregistrada = false;
                }
            } else {
                debito = this.naturaleza;
            }
            System.out.println("valueAccount: " + valueAccount + " IdProdServ==" + account.trim() + " cuenta registrada " + cuentaregistrada);
            if (valueAccount == 0.0 || "IdProdServ".equals(account.trim()) || !cuentaregistrada) continue;
            double baseAccount = LinkingCache.getPCBase(this.bd, account.trim());
            if (this.debug) {
                System.out.println("La cuenta a procesar es: " + account);
                System.out.println("La cuenta esta registrada: " + cuentaregistrada);
                System.out.println("Valor del movimiento: " + valueAccount);
                System.out.println("idProdServ: " + idProdServ);
            }
            if (valueAccount < 0.0) {
                valueAccount = Math.abs(valueAccount);
                boolean bl = debito = !debito;
            }
            if (!(baseAccount >= this.base)) continue;
            String idCta = LinkingCache.getPCIdCta(this.bd, account);
            System.out.println("idCta: " + idCta);
            if (LinkingCache.isPCInventarios(this.bd, account) && LinkingCache.isPCTerceros(this.bd, account)) {
                if (this.colCost == col) {
                    bodega = "";
                    bodega = CacheKeys.getKey("bodegaSaliente") != null ? CacheKeys.getKey("bodegaSaliente") : (CacheKeys.getKey("bodegaEntrante") != null ? CacheKeys.getKey("bodegaEntrante") : CacheKeys.getKey("bodegaAjuste"));
                    valueAccount = valueAccount == LinkingCache.getSaldoInventario(this.bd, bodega, idProdServ) ? LinkingCache.getVSaldoInventario(this.bd, bodega, idProdServ) : (valueAccount *= LinkingCache.getPCosto(this.bd, bodega, idProdServ));
                    try {
                        bigDecimal3 = new BigDecimal(valueAccount);
                        bigDecimal3 = bigDecimal3.setScale(2, 4);
                        valueAccount = bigDecimal3.doubleValue();
                    }
                    catch (NumberFormatException bigDecimal2) {
                        // empty catch block
                    }
                    System.out.println("cantidades existentes del producto " + idProdServ + ": " + LinkingCache.getVSaldoInventario(this.bd, bodega, idProdServ));
                    System.out.println("costo de promedio del producto " + idProdServ + ": " + LinkingCache.getPCosto(this.bd, bodega, idProdServ));
                    System.out.println("valor de valueAccount:  (costo*cant) " + valueAccount);
                }
                idTercero = null;
                if (this.getColIdTercero() > -1) {
                    eIdTercero = (Element)colElement.get(this.getColIdTercero());
                    idTercero = eIdTercero.getText();
                    System.out.println("columna idTercero: " + this.getColIdTercero() + " idTercero: " + idTercero);
                }
                if (idTercero == null) {
                    idTercero = CacheKeys.getKey("idTercero");
                }
                if (idTercero == null) {
                    idTercero = this.tercero;
                    System.out.println("Tercero es nulo entonces tercero es " + idTercero);
                }
                System.out.println("tercero actual " + idTercero);
                this.asientosConTipo(idCta, valueAccount, idTercero, idProdServ, debito, 3, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCInventarios(this.bd, account)) {
                if (this.colCost == col) {
                    bodega = "";
                    bodega = CacheKeys.getKey("bodegaSaliente") != null ? CacheKeys.getKey("bodegaSaliente") : CacheKeys.getKey("bodegaEntrante");
                    valueAccount = valueAccount == LinkingCache.getSaldoInventario(this.bd, bodega, idProdServ) ? LinkingCache.getVSaldoInventario(this.bd, bodega, idProdServ) : (valueAccount *= LinkingCache.getPCosto(this.bd, bodega, idProdServ));
                    try {
                        bigDecimal3 = new BigDecimal(valueAccount);
                        bigDecimal3 = bigDecimal3.setScale(2, 4);
                        valueAccount = bigDecimal3.doubleValue();
                    }
                    catch (NumberFormatException bigDecimal3) {
                        // empty catch block
                    }
                    System.out.println("cantidades existentes del producto " + idProdServ + ": " + LinkingCache.getVSaldoInventario(this.bd, bodega, idProdServ));
                    System.out.println("costo de promedio del producto " + idProdServ + ": " + LinkingCache.getPCosto(this.bd, bodega, idProdServ));
                    System.out.println("valor de valueAccount:  (costo*cant) " + valueAccount);
                }
                this.asientosConTipo(idCta, valueAccount, idProdServ, debito, 0, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCTerceros(this.bd, account)) {
                idTercero = null;
                if (this.getColIdTercero() > -1) {
                    eIdTercero = (Element)colElement.get(this.getColIdTercero());
                    idTercero = eIdTercero.getText();
                    System.out.println("columna idTercero: " + this.getColIdTercero() + " idTercero: " + idTercero);
                }
                if (idTercero == null) {
                    idTercero = CacheKeys.getKey("idTercero");
                }
                if (idTercero == null) {
                    idTercero = this.tercero;
                    System.out.println("Tercero es nulo entonces tercero es " + idTercero);
                }
                System.out.println("tercero actual " + idTercero);
                this.asientosConTipo(idCta, valueAccount, idTercero, debito, 1, LinkingCache.isPCNaturaleza(this.bd, account));
            } else if (LinkingCache.isPCActivos(this.bd, account)) {
                System.out.println("columna accountAC " + this.accountAc);
                this.asientosConTipo(idCta, valueAccount, idActivo, debito, 2, LinkingCache.isPCNaturaleza(this.bd, account));
            } else {
                this.asientosDetalle(idCta, valueAccount, debito, LinkingCache.isPCNaturaleza(this.bd, account));
            }
            partidaDoble = debito ? (partidaDoble += valueAccount) : (partidaDoble -= valueAccount);
            try {
                BigDecimal bigDecimal4 = new BigDecimal(partidaDoble);
                bigDecimal4 = bigDecimal4.setScale(2, 4);
                partidaDoble = bigDecimal4.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!this.debug) continue;
            System.out.println("partida doble columnData:" + partidaDoble);
        }
        System.out.println("-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-");
        return partidaDoble;
    }

    private int getColIdProdServ() {
        if (this.colIdProdServ == -1) {
            for (int i = 0; i < this.colAccount.size(); ++i) {
                if (!this.colAccount.get(i).equals("IdProdServ")) continue;
                this.colIdProdServ = i;
                return this.colIdProdServ;
            }
            return -1;
        }
        return this.colIdProdServ;
    }

    private int getColIdActivo() {
        if (this.colIdActivo == -1) {
            for (int i = 0; i < this.colAccount.size(); ++i) {
                System.out.println("buscando en " + i + " idActivo valor actual: " + this.colAccount.get(i));
                if (!this.colAccount.get(i).equals("IdActivo")) continue;
                this.colIdActivo = Integer.parseInt(this.colData.get(i));
                return this.colIdActivo;
            }
            return -1;
        }
        return this.colIdActivo;
    }

    private int getColIdTercero() {
        if (this.colIdTercero == -1) {
            for (int i = 0; i < this.colAccount.size(); ++i) {
                System.out.println("buscando en " + i + " idTercero valor actual: " + this.colAccount.get(i));
                if (!this.colAccount.get(i).equals("IdTercero")) continue;
                this.colIdTercero = Integer.parseInt(this.colData.get(i));
                return this.colIdTercero;
            }
            return -1;
        }
        return this.colIdTercero;
    }

    private void asientosConTipo(String idCta, double value, String idTipo, boolean debito, int tipo, boolean natCta) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        QueryRunner RQsalidas;
        String[] asiento;
        System.out.println("cc: " + this.centroCosto);
        if (this.centroCosto != null && this.centroCosto.equals("getname")) {
            asiento = new String[8];
            String cc = CacheKeys.getKey("centrocosto");
            System.out.println("centrocosto: {" + cc + "}");
            asiento[0] = cc == null ? "NULL" : cc;
            asiento[1] = idCta;
            asiento[2] = idTipo;
            asiento[3] = CacheKeys.getDate();
            asiento[4] = this.concepto;
            asiento[5] = CacheKeys.getKey("ndocumento");
        } else {
            asiento = new String[7];
            asiento[0] = idCta;
            asiento[1] = idTipo;
            asiento[2] = CacheKeys.getDate();
            asiento[3] = this.concepto;
            asiento[4] = CacheKeys.getKey("ndocumento");
        }
        if (debito) {
            if (asiento.length == 8) {
                asiento[6] = String.valueOf(value);
                asiento[7] = "0";
            } else {
                asiento[5] = String.valueOf(value);
                asiento[6] = "0";
            }
        } else if (asiento.length == 8) {
            asiento[6] = "0";
            asiento[7] = String.valueOf(value);
        } else {
            asiento[5] = "0";
            asiento[6] = String.valueOf(value);
        }
        if (this.debug) {
            System.out.println("Datos a almacenar");
            for (int i = 0; i < asiento.length; ++i) {
                System.out.println("Campo " + i + ": " + asiento[i]);
            }
        }
        System.out.println("tipo de almacenamiento: " + this.type);
        if (this.type == 0) {
            QueryRunner RQsalidasNIFS;
            if (tipo == 0) {
                RQsalidas = new QueryRunner(this.bd, "SCI00O7", asiento);
                RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS04", asiento);
            } else if (tipo == 2) {
                RQsalidas = new QueryRunner(this.bd, "SCI0025", asiento);
                RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS06", asiento);
            } else {
                RQsalidas = new QueryRunner(this.bd, "SCI00O6", asiento);
                RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS05", asiento);
            }
            RQsalidas.ejecutarSQL();
            RQsalidasNIFS.ejecutarSQL();
        } else if (this.type == 1) {
            RQsalidas = tipo == 0 ? new QueryRunner(this.bd, "SCI00O7", asiento) : (tipo == 2 ? new QueryRunner(this.bd, "SCI0025", asiento) : new QueryRunner(this.bd, "SCI00O6", asiento));
            RQsalidas.ejecutarSQL();
        } else if (this.type == 2) {
            QueryRunner RQsalidasNIFS = tipo == 0 ? new QueryRunner(this.bd, "SCINIFS04", asiento) : (tipo == 2 ? new QueryRunner(this.bd, "SCINIFS06", asiento) : new QueryRunner(this.bd, "SCINIFS05", asiento));
            RQsalidasNIFS.ejecutarSQL();
        }
    }

    private void asientosConTipo(String idCta, double value, String idTercero, String idProdServ, boolean debito, int tipo, boolean natCta) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        QueryRunner RQsalidas;
        String[] asiento;
        System.out.println("cc: " + this.centroCosto);
        if (this.centroCosto != null && this.centroCosto.equals("getname")) {
            asiento = new String[9];
            String cc = CacheKeys.getKey("centrocosto");
            System.out.println("centrocosto: {" + cc + "}");
            asiento[0] = cc == null ? "NULL" : cc;
            asiento[1] = idCta;
            asiento[2] = idTercero;
            asiento[3] = idProdServ;
            asiento[4] = CacheKeys.getDate();
            asiento[5] = this.concepto;
            asiento[6] = CacheKeys.getKey("ndocumento");
        } else {
            asiento = new String[8];
            asiento[0] = idCta;
            asiento[1] = idTercero;
            asiento[2] = idProdServ;
            asiento[3] = CacheKeys.getDate();
            asiento[4] = this.concepto;
            asiento[5] = CacheKeys.getKey("ndocumento");
        }
        if (debito) {
            if (asiento.length == 9) {
                asiento[7] = String.valueOf(value);
                asiento[8] = "0";
            } else {
                asiento[6] = String.valueOf(value);
                asiento[7] = "0";
            }
        } else if (asiento.length == 9) {
            asiento[7] = "0";
            asiento[8] = String.valueOf(value);
        } else {
            asiento[6] = "0";
            asiento[7] = String.valueOf(value);
        }
        if (this.debug) {
            System.out.println("Datos a almacenar");
            for (int i = 0; i < asiento.length; ++i) {
                System.out.println("Campo " + i + ": " + asiento[i]);
            }
        }
        System.out.println("tipo de almacenamiento: " + this.type);
        if (this.type == 0) {
            RQsalidas = new QueryRunner(this.bd, "SCI0027", asiento);
            QueryRunner RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS06", asiento);
            RQsalidas.ejecutarSQL();
            RQsalidasNIFS.ejecutarSQL();
        } else if (this.type == 1) {
            RQsalidas = new QueryRunner(this.bd, "SCI0027", asiento);
            RQsalidas.ejecutarSQL();
        } else if (this.type == 2) {
            QueryRunner RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS06", asiento);
            RQsalidasNIFS.ejecutarSQL();
        }
    }

    private void asientosDetalle(String idCta, double value, boolean debito, boolean natCta) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, DontHaveKeyException {
        QueryRunner RQsalidas;
        String[] asiento;
        if (this.centroCosto != null && this.centroCosto.equals("getname")) {
            asiento = new String[7];
            String cc = CacheKeys.getKey("centrocosto");
            System.out.println("centrocosto: {" + cc + "}");
            asiento[0] = cc == null ? "NULL" : cc;
            asiento[1] = idCta;
            asiento[2] = CacheKeys.getDate();
            asiento[3] = this.concepto;
            asiento[4] = CacheKeys.getKey("ndocumento");
        } else {
            asiento = new String[6];
            asiento[0] = idCta;
            asiento[1] = CacheKeys.getDate();
            asiento[2] = this.concepto;
            asiento[3] = CacheKeys.getKey("ndocumento");
        }
        if (debito) {
            if (asiento.length == 6) {
                asiento[4] = String.valueOf(value);
                asiento[5] = "0";
            } else {
                asiento[5] = String.valueOf(value);
                asiento[6] = "0";
            }
        } else if (asiento.length == 6) {
            asiento[4] = "0";
            asiento[5] = String.valueOf(value);
        } else {
            asiento[5] = "0";
            asiento[6] = String.valueOf(value);
        }
        if (this.type == 0) {
            RQsalidas = new QueryRunner(this.bd, "SCI00O5", asiento);
            QueryRunner RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS03", asiento);
            RQsalidas.ejecutarSQL();
            RQsalidasNIFS.ejecutarSQL();
        } else if (this.type == 1) {
            RQsalidas = new QueryRunner(this.bd, "SCI00O5", asiento);
            RQsalidas.ejecutarSQL();
        } else if (this.type == 2) {
            QueryRunner RQsalidasNIFS = new QueryRunner(this.bd, "SCINIFS03", asiento);
            RQsalidasNIFS.ejecutarSQL();
        }
    }

    public void anular() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, InterruptedException {
        String idDocumento = CacheKeys.getKey("ndocumento");
        QueryRunner RQanular = new QueryRunner(this.bd, "SCU0005", new String[]{idDocumento});
        QueryRunner RQanularNIFS = new QueryRunner(this.bd, "SCUNIFS01", new String[]{idDocumento});
        RQanular.ejecutarSQL();
        RQanularNIFS.ejecutarSQL();
        RQanular.closeStatement();
        RQanularNIFS.closeStatement();
    }

    public void recover() {
    }

    private double roundValue(Double value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public void deleteDocument() throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdpDocument = new QueryRunner(this.bd, "SCD0004", new String[0]);
        QueryRunner RQdropDocument = new QueryRunner(this.bd, "SCS0084", new String[]{CacheKeys.getKey("ndocumento")});
        QueryRunner RQdeleteDocument = new QueryRunner(this.bd, "SCD0001", new String[]{CacheKeys.getKey("ndocumento")});
        RQdpDocument.ejecutarSQL();
        RQdropDocument.ejecutarSQL();
        RQdeleteDocument.ejecutarSQL();
        RQdpDocument.closeStatement();
        RQdropDocument.closeStatement();
        RQdeleteDocument.closeStatement();
        QueryRunner RQdpDocumentNIFS = new QueryRunner(this.bd, "SCDNIFS01", new String[0]);
        QueryRunner RQdropDocumentNIFS = new QueryRunner(this.bd, "SCSNIFS01", new String[]{CacheKeys.getKey("ndocumento")});
        QueryRunner RQdeleteDocumentNIFS = new QueryRunner(this.bd, "SCDNIFS02", new String[]{CacheKeys.getKey("ndocumento")});
        RQdpDocumentNIFS.ejecutarSQL();
        RQdropDocumentNIFS.ejecutarSQL();
        RQdeleteDocumentNIFS.ejecutarSQL();
        RQdpDocumentNIFS.closeStatement();
        RQdropDocumentNIFS.closeStatement();
        RQdeleteDocumentNIFS.closeStatement();
    }
}

