/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.misc.language.Language;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.CacheKeys;
import server.businessrules.LNDocuments;
import server.businessrules.LNErrorProcecuteException;
import server.businessrules.LNUndoSaldos;
import server.database.beans.InfoInventario;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNInventarios {
    private String bd;
    private String tipoMovimiento;
    private final String ENTRADA = "entrada";
    private final String SALIDA = "salida";
    private final String AJUSTE = "ajuste";
    private final String NOTA = "nota";
    private final String RECOVER = "recover";
    private final String RECOVERDOC = "recoverdocument";
    private final String GASTOS = "gastosydescuentos";
    private final String ANULAR = "anular";
    private final String DELETE = "deletedocument";
    private HashMap<Integer, RecoverData> recoverList = new HashMap();
    double saldo;
    double vsaldo;

    public LNInventarios(String bd, final Element raiz, final String tipoDoc, final String numero) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, InterruptedException {
        this.bd = bd;
        Thread recoverReload = new Thread(){

            @Override
            public void run() {
                try {
                    LNInventarios.this.recoverDocument(tipoDoc, numero);
                    LinkingCache.reloadInventarios(raiz.getChild("db").getValue(), "SCS0097", new String[]{tipoDoc});
                }
                catch (SQLNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SQLBadArgumentsException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        recoverReload.start();
    }

    public LNInventarios(Element parameters, String bd) {
        this.bd = bd;
        if (parameters != null) {
            for (Element e : parameters.getChildren()) {
                String attribute = e.getAttributeValue("attribute");
                if (!attribute.equals("tipoMovimiento")) continue;
                this.tipoMovimiento = e.getValue().trim().toLowerCase();
            }
        }
    }

    public void movimientos(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, InterruptedException {
        QueryRunner RQmovimiento = null;
        if ("entrada".equals(this.tipoMovimiento)) {
            RQmovimiento = new QueryRunner(this.bd, "SCI00O8");
            String[] record = this.movimientoInventario(pack);
            if (!record[4].equals("0") && !record[4].equals("0.0")) {
                RQmovimiento.ejecutarSQL(record);
                RQmovimiento.closeStatement();
            }
        } else if ("salida".equals(this.tipoMovimiento)) {
            RQmovimiento = new QueryRunner(this.bd, "SCI00O4");
            String[] record = this.movimientoInventario(pack);
            if (!record[4].equals("0") && !record[4].equals("0.0")) {
                RQmovimiento.ejecutarSQL(record);
                RQmovimiento.closeStatement();
            }
        } else if ("gastosydescuentos".equals(this.tipoMovimiento)) {
            this.gastosYdescuentos(pack);
        } else if ("ajuste".equals(this.tipoMovimiento)) {
            this.ajustes(pack);
        } else if ("anular".equals(this.tipoMovimiento)) {
            this.anular();
        } else if ("nota".equals(this.tipoMovimiento)) {
            this.nota(pack);
        } else if ("recover".equals(this.tipoMovimiento)) {
            this.recover();
        } else if ("recoverdocument".equals(this.tipoMovimiento)) {
            this.recoverDocument();
        } else if ("deletedocument".equals(this.tipoMovimiento)) {
            this.deleteDocument();
        }
    }

    private void nota(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQmovimiento = null;
        String[] record = new String[9];
        String cuenta = null;
        record[0] = CacheKeys.getDate();
        record[1] = CacheKeys.getKey("ndocumento");
        Iterator i = pack.getChildren().iterator();
        boolean movimiento = false;
        while (i.hasNext()) {
            Element field = (Element)i.next();
            String nameField = field.getAttributeValue("name");
            if (nameField == null) continue;
            if ("cuenta".equals(nameField = nameField.toLowerCase()) && (!(cuenta = field.getValue()).startsWith("14") && !cuenta.startsWith("62") || Integer.parseInt(cuenta.substring(4, 6)) >= 90)) {
                return;
            }
            if ("bodega".equals(nameField)) {
                record[2] = field.getValue();
                continue;
            }
            if ("idproducto".equals(nameField)) {
                record[3] = field.getValue();
                if (!record[3].equals("NULL")) continue;
                return;
            }
            if ("cantidad".equals(nameField)) {
                record[4] = field.getValue();
                continue;
            }
            if ("creditos".equals(nameField) && !field.getValue().startsWith("0")) {
                RQmovimiento = new QueryRunner(this.bd, "SCI00O4");
                record[5] = field.getValue();
                continue;
            }
            if (!"debitos".equals(nameField) || field.getValue().startsWith("0")) continue;
            RQmovimiento = new QueryRunner(this.bd, "SCI00O8");
            record[5] = field.getValue();
            movimiento = true;
        }
        double pcosto = LinkingCache.getPCosto(this.bd, record[2], record[3]);
        this.saldo = LinkingCache.getSaldoInventario(this.bd, record[2], record[3]);
        this.vsaldo = LinkingCache.getVSaldoInventario(this.bd, record[2], record[3]);
        LNUndoSaldos.setSaldoAntInv(this.bd, record[2], record[3], new InfoInventario(pcosto, this.saldo, this.vsaldo));
        String[] ponderado = null;
        double cantidad = Double.parseDouble(record[4]);
        double entrada = cantidad > 0.0 ? Double.parseDouble(record[5]) / cantidad : (cantidad == 0.0 && Double.parseDouble(record[5]) != 0.0 ? Double.parseDouble(record[5]) : 0.0);
        BigDecimal bigDecimal = new BigDecimal(entrada);
        bigDecimal = bigDecimal.setScale(2, 4);
        record[5] = String.valueOf(bigDecimal.doubleValue());
        ponderado = movimiento ? this.ponderar(record[2], record[3], cantidad, bigDecimal.doubleValue()) : this.ponderar(record[2], record[3], cantidad, bigDecimal.doubleValue() * -1.0);
        record[6] = ponderado[0];
        record[7] = ponderado[1];
        record[8] = ponderado[2];
        if (entrada != 0.0) {
            RQmovimiento.ejecutarSQL(record);
            RQmovimiento.closeStatement();
        }
    }

    private void ajustes(Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        String[] record = this.movimientoInventario(pack);
        QueryRunner RQmovimiento = null;
        if ("salida".equals(this.tipoMovimiento)) {
            RQmovimiento = new QueryRunner(this.bd, "SCI00O4");
        } else if ("entrada".equals(this.tipoMovimiento)) {
            RQmovimiento = new QueryRunner(this.bd, "SCI00O8");
        }
        if (!record[4].equals("0") && !record[4].equals("0.0")) {
            RQmovimiento.ejecutarSQL(record);
            RQmovimiento.closeStatement();
        }
    }

    public void traslados(Element pack) throws LNErrorProcecuteException, SQLBadArgumentsException, SQLBadArgumentsException, SQLNotFoundException, SQLException {
        QueryRunner RQentrada = null;
        QueryRunner RQsalida = null;
        try {
            this.tipoMovimiento = "salida";
            String[] records = this.movimientoInventario(pack);
            if (records[4].equals("0") || records[4].equals("0.0")) {
                System.out.println("Se omite insercion porque la cantidad es 0");
            } else {
                RQsalida = new QueryRunner(this.bd, "SCI00O4");
                RQsalida.ejecutarSQL(records);
                RQsalida.closeStatement();
            }
            CacheKeys.setKey("valorEntrada", records[6]);
            this.tipoMovimiento = "entrada";
            String[] ventradas = this.movimientoInventario(pack);
            if (ventradas[4].equals("0") || ventradas[4].equals("0.0")) {
                System.out.println("Se omite insercion porque la cantidad es 0");
            } else {
                RQentrada = new QueryRunner(this.bd, "SCI00O8");
                RQentrada.ejecutarSQL(ventradas);
                RQentrada.closeStatement();
            }
        }
        catch (NumberFormatException NFEe) {
            RQentrada.closeStatement();
            RQsalida.closeStatement();
            throw new LNErrorProcecuteException(Language.getWord((String)"ERR_ARGS"));
        }
        catch (IndexOutOfBoundsException IOOBEe) {
            RQentrada.closeStatement();
            RQsalida.closeStatement();
            IOOBEe.printStackTrace();
            throw new LNErrorProcecuteException(Language.getWord((String)"ERR_ARGS"));
        }
    }

    private synchronized String[] movimientoInventario(Element pack) {
        String[] record = new String[9];
        int conversion = 1;
        if (this.tipoMovimiento.equals("entrada")) {
            record = this.infoMovimiento(pack, "bodegaEntrante");
        } else if (this.tipoMovimiento.equals("salida")) {
            record = this.infoMovimiento(pack, "bodegaSaliente");
            conversion = -1;
        } else if (this.tipoMovimiento.equals("ajuste")) {
            record = this.infoMovimiento(pack, "bodegaAjuste");
        }
        if (this.tipoMovimiento.equals("ajuste")) {
            double _cantidad = Double.parseDouble(record[4]);
            if (_cantidad > 0.0) {
                this.tipoMovimiento = "salida";
                record[5] = record[5] == null || record[5] == "0" || record[5] == "0.0" ? String.valueOf(LinkingCache.getPCosto(this.bd, record[2], record[3])) : record[5];
                conversion = -1;
            } else {
                this.tipoMovimiento = "entrada";
                record[4] = String.valueOf(_cantidad * -1.0);
            }
        }
        if (this.tipoMovimiento.equals("entrada")) {
            if (record[5] == null) {
                record[5] = CacheKeys.getKey("valorEntrada") == null ? "0.0" : CacheKeys.getKey("valorEntrada");
            }
        } else if (record[5] == null) {
            record[5] = String.valueOf(LinkingCache.getPCosto(this.bd, record[2], record[3]));
        }
        System.out.println("DESDE MOVIMIENTO INVENTARIO: id_prod_serv: " + record[3] + " pcosto: " + record[5]);
        double cantidad = Double.parseDouble(record[4]);
        double valor = Double.parseDouble(record[5]);
        String[] ponderado = this.ponderar(record[2], record[3], cantidad * (double)conversion, valor);
        record[6] = ponderado[0];
        record[7] = ponderado[1];
        record[8] = ponderado[2];
        return record;
    }

    private void gastosYdescuentos(Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Object[] record = new String[8];
        Vector<Double> gastos = new Vector<Double>();
        record[0] = CacheKeys.getDate();
        record[1] = CacheKeys.getKey("ndocumento");
        record[2] = CacheKeys.getKey("bodegaEntrante");
        for (Element field : pack.getChildren()) {
            String nameField = field.getAttributeValue("name");
            if (nameField == null) continue;
            if ("bodegaentrante".equals(nameField = nameField.toLowerCase())) {
                record[2] = field.getValue();
                continue;
            }
            if ("idproducto".equals(nameField)) {
                record[3] = field.getValue();
                continue;
            }
            if (!"gastos".equals(nameField) && !"descuentos".equals(nameField)) continue;
            try {
                double gd = Double.parseDouble(field.getValue());
                if (!(gd > 0.0)) continue;
                if ("gastos".equals(nameField)) {
                    gastos.addElement(new Double(gd));
                    continue;
                }
                double descuento = gd * -1.0;
                gastos.addElement(new Double(descuento));
            }
            catch (NumberFormatException gd) {}
        }
        QueryRunner RQmovimiento = new QueryRunner(this.bd, "SCI0013");
        if (gastos.size() > 0) {
            for (int j = 0; j < gastos.size(); ++j) {
                this.saldo = LinkingCache.getSaldoInventario(this.bd, record[2], record[3]);
                this.vsaldo = LinkingCache.getVSaldoInventario(this.bd, record[2], record[3]);
                double ventrada = (Double)gastos.get(j);
                this.vsaldo += ventrada;
                double pcosto = this.saldo > 0.0 ? this.vsaldo / this.saldo : 0.0;
                BigDecimal bigDecimal = new BigDecimal(pcosto);
                bigDecimal = bigDecimal.setScale(2, 4);
                pcosto = bigDecimal.doubleValue();
                record[4] = String.valueOf(ventrada);
                record[5] = String.valueOf(pcosto);
                record[6] = String.valueOf(this.saldo);
                record[7] = String.valueOf(this.vsaldo);
                RQmovimiento.ejecutarSQL((String[])record);
                LinkingCache.setPCosto(this.bd, record[2], record[3], pcosto);
                this.actualizarSaldos(record);
            }
            RQmovimiento.closeStatement();
        }
    }

    private String[] infoMovimiento(Element pack, String bodega) {
        String[] record = new String[9];
        record[0] = CacheKeys.getDate();
        record[1] = CacheKeys.getKey("ndocumento");
        record[2] = CacheKeys.getKey(bodega);
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.setFormat(Format.getPrettyFormat());
            xmlOutputter.output(pack, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Element field : pack.getChildren()) {
            String nameField = field.getAttributeValue("name");
            System.out.println("Element: " + field);
            System.out.println("nameField: " + nameField);
            if (nameField == null) continue;
            nameField = nameField.toLowerCase();
            if (bodega != null && bodega.toLowerCase().equals(nameField)) {
                record[2] = field.getValue();
                CacheKeys.setKey("idBodega", field.getValue());
                continue;
            }
            if ("idproducto".equals(nameField)) {
                record[3] = field.getValue();
                continue;
            }
            if ("cantidad".equals(nameField)) {
                record[4] = field.getValue();
                continue;
            }
            if (!"pcosto".equals(nameField)) continue;
            record[5] = field.getValue();
        }
        System.out.println("id_prod_serv: " + record[3] + " pcosto: " + record[5]);
        double pcosto = LinkingCache.getPCosto(this.bd, record[2], record[3]);
        this.saldo = LinkingCache.getSaldoInventario(this.bd, record[2], record[3]);
        this.vsaldo = LinkingCache.getVSaldoInventario(this.bd, record[2], record[3]);
        LNUndoSaldos.setSaldoAntInv(this.bd, record[2], record[3], new InfoInventario(pcosto, this.saldo, this.vsaldo));
        return record;
    }

    private void anular() throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        QueryRunner RQanular = new QueryRunner(this.bd, "SCU0006", new String[]{CacheKeys.getKey("ndocumento")});
        RQanular.ejecutarSQL();
        this.recoverAux("SCS0051", new String[]{CacheKeys.getKey("ndocumento")}, true);
    }

    private String[] ponderar(String idBodega, String idProdServ, double cantidad, double valor) {
        double saldoAnt = this.saldo;
        this.saldo += cantidad;
        if (cantidad < 0.0 && saldoAnt == Math.abs(cantidad) || valor < 0.0 && cantidad == saldoAnt) {
            this.vsaldo = 0.0;
        } else if (cantidad == 0.0 && valor != 0.0) {
            System.out.println("por cantidad 0 y valor!=0");
            this.vsaldo += valor;
        } else {
            this.vsaldo += cantidad * valor;
        }
        double pcosto = this.vsaldo / this.saldo;
        System.out.println("pcosto: " + pcosto + " vsaldo: " + this.vsaldo + " saldo: " + this.saldo);
        try {
            BigDecimal bigDecimal = new BigDecimal(pcosto);
            bigDecimal = bigDecimal.setScale(2, 4);
            pcosto = bigDecimal.doubleValue();
        }
        catch (NumberFormatException NFEe) {
            pcosto = 0.0;
        }
        String[] ponderados = new String[]{String.valueOf(pcosto), String.valueOf(this.saldo), String.valueOf(this.vsaldo)};
        LinkingCache.setPCosto(this.bd, idBodega, idProdServ, pcosto);
        LinkingCache.setSaldoInventario(this.bd, idBodega, idProdServ, this.saldo);
        LinkingCache.setVSaldoInventario(this.bd, idBodega, idProdServ, this.vsaldo);
        return ponderados;
    }

    private void actualizarSaldos(Object[] record) {
        LinkingCache.setSaldoInventario(this.bd, (String)record[2], (String)record[3], this.saldo);
        LinkingCache.setVSaldoInventario(this.bd, (String)record[2], (String)record[3], this.vsaldo);
    }

    public void recoverDocument() throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        this.recoverAux("SCS0082", new String[]{CacheKeys.getKey("ndocumento")}, true);
        this.recoverAux("SCS0085", new String[]{CacheKeys.getKey("ndocumento")}, true);
        QueryRunner RQdpDocument = new QueryRunner(this.bd, "SCD0003", new String[0]);
        RQdpDocument.ejecutarSQL();
        RQdpDocument.closeStatement();
    }

    public void recoverDocument(String codigo_tipo, String numero) {
        this.recoverAux("SCS0102", new String[]{codigo_tipo, numero}, true);
    }

    public void recover() throws SQLNotFoundException, SQLBadArgumentsException, SQLException, InterruptedException {
        System.out.println("recover...");
        QueryRunner RQdpDocument = new QueryRunner(this.bd, "SCD0003", new String[0]);
        this.recoverAux("SCS0090", null, false);
        RQdpDocument.ejecutarSQL();
        RQdpDocument.closeStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverAux(String sql, String[] args, boolean transaction) {
        Calendar calendar = Calendar.getInstance();
        long init = calendar.getTimeInMillis();
        Monitor m = new Monitor();
        m.setPriority(1);
        m.start();
        System.out.println("Iniciando recosteo");
        try {
            Connection conn = null;
            if (transaction) {
                System.out.println("voy por conexion");
                conn = ConnectionsPool.getConnection(this.bd);
            } else {
                System.out.println("voy por multiconexion");
                conn = ConnectionsPool.getMultiConnection(this.bd);
            }
            QueryRunner RQdocument = null;
            RQdocument = args == null ? new QueryRunner(this.bd, sql) : new QueryRunner(this.bd, sql, args);
            ResultSet RSdocument = RQdocument.ejecutarMTSELECT(conn);
            int i = 0;
            while (RSdocument.next()) {
                m.setI(i);
                this.runThread(i, RSdocument.getString(1), RSdocument.getString(2), RSdocument.getString(3), RSdocument.getDouble(4), RSdocument.getDouble(5), transaction);
                ++i;
            }
            calendar = Calendar.getInstance();
            long end = calendar.getTimeInMillis();
            HashMap<Integer, RecoverData> hashMap = this.recoverList;
            synchronized (hashMap) {
                while (this.recoverList.size() > 0) {
                    try {
                        this.recoverList.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            System.out.println("Inventario recosteado en " + (end - init) / 1000L + " segundos ");
            m.interrupt();
            RQdocument.closeStatement();
            RSdocument.close();
            if (!transaction) {
                ConnectionsPool.freeMultiConnection(this.bd, conn);
            }
        }
        catch (SQLNotFoundException conn) {
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runThread(int i, String fecha, String bodega, String idProducto, double saldo, double valorSaldo, boolean transaction) throws InterruptedException {
        HashMap<Integer, RecoverData> hashMap = this.recoverList;
        synchronized (hashMap) {
            if (this.recoverList.size() >= 20) {
                try {
                    this.recoverList.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.recoverList.put(i, new RecoverData(this.recoverList, i, fecha, bodega, idProducto, saldo, valorSaldo, transaction));
            this.recoverList.get(i).start();
        }
    }

    private void recoverData(String fecha, String idBodega, String idProducto, double saldoAnt, double valorSaldoAnt, boolean transaction) {
        String orden = "";
        String rfDocumento = "";
        String tipoDocumento = "";
        boolean estado = true;
        double pinventario = 0.0;
        double hpinventario = 0.0;
        double entrada = 0.0;
        double valorEntrada = 0.0;
        double salida = 0.0;
        double valorSalida = 0.0;
        boolean ponderar = false;
        Hashtable<String, DataInventory> historyInv = new Hashtable<String, DataInventory>();
        QueryRunner RQdata = null;
        Connection conn = null;
        conn = transaction ? ConnectionsPool.getConnection(this.bd) : ConnectionsPool.getMultiConnection(this.bd);
        try {
            if (fecha != null) {
                RQdata = new QueryRunner(this.bd, "SCS0077", new String[]{fecha, idBodega, idProducto});
            } else if (LNDocuments.getActionDocument() != null && (LNDocuments.getActionDocument().equals("editDocument") || LNDocuments.getActionDocument().equals("deleteDocument"))) {
                fecha = CacheKeys.getMinDate();
            } else {
                RQdata = new QueryRunner(this.bd, "SCS0071", new String[]{idBodega, idProducto});
            }
            Hashtable<String, Double> valorTraslado = this.cargarTraslados(conn, idBodega, idProducto);
            ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
            QueryRunner RQupdate = new QueryRunner(this.bd, "SCU0002");
            while (RSdata.next()) {
                ponderar = true;
                orden = RSdata.getString(1);
                rfDocumento = RSdata.getString(2);
                tipoDocumento = RSdata.getString(3);
                hpinventario = RSdata.getDouble(4) != 0.0 ? RSdata.getDouble(4) : hpinventario;
                estado = RSdata.getBoolean(5);
                entrada = RSdata.getDouble(6);
                valorEntrada = RSdata.getDouble(7);
                salida = RSdata.getDouble(8);
                valorSalida = RSdata.getDouble(9);
                if (salida != 0.0) {
                    if (!estado) {
                        salida = 0.0;
                        valorSalida = 0.0;
                    } else if (tipoDocumento.equals("DC")) {
                        valorSalida = rfDocumento == null ? pinventario : (historyInv.containsKey(rfDocumento) ? ((DataInventory)historyInv.get(rfDocumento)).getValorEntrada() : this.getDBValue(conn, "SCS0078", rfDocumento, idProducto));
                    } else if (tipoDocumento.equals("TB") || tipoDocumento.equals("RM") || tipoDocumento.equals("RT") || tipoDocumento.equals("RA") || tipoDocumento.equals("RE") || tipoDocumento.equals("CA") || tipoDocumento.equals("FA") || tipoDocumento.equals("FH") || tipoDocumento.equals("FB") || tipoDocumento.equals("FC") || tipoDocumento.equals("FI") || tipoDocumento.equals("FM") || tipoDocumento.equals("IJ")) {
                        valorSalida = pinventario;
                        ponderar = false;
                    }
                } else if (entrada != 0.0) {
                    if (!estado) {
                        entrada = 0.0;
                        valorEntrada = 0.0;
                    } else if (tipoDocumento.equals("DV")) {
                        valorEntrada = rfDocumento == null ? pinventario : (historyInv.containsKey(rfDocumento) ? ((DataInventory)historyInv.get(rfDocumento)).getValorSalida() : this.getDBValue(conn, "SCS0079", orden, idProducto));
                    } else if (tipoDocumento.equals("TB") || tipoDocumento.equals("RM") || tipoDocumento.equals("RT")) {
                        System.out.println("buscando orden: " + orden + " lo contiene? " + valorTraslado.containsKey(orden) + " valorTraslado: " + valorTraslado.get(orden) + " pinventario: " + pinventario + " resultado del condicional: " + (valorTraslado.containsKey(orden) ? valorTraslado.get(orden) : pinventario));
                        valorEntrada = valorTraslado.containsKey(orden) ? valorTraslado.get(orden) : pinventario;
                    } else if (tipoDocumento.equals("IJ")) {
                        valorEntrada = pinventario;
                        ponderar = false;
                    }
                }
                double nuevoValorEntrada = valorEntrada < 0.0 && entrada == Math.abs(saldoAnt) && valorEntrada == pinventario ? valorSaldoAnt * -1.0 : entrada * valorEntrada;
                double nuevoValorSalida = saldoAnt == salida && valorSalida == pinventario ? valorSaldoAnt : salida * valorSalida;
                saldoAnt = saldoAnt + entrada - salida;
                double d = valorSaldoAnt = saldoAnt == 0.0 ? 0.0 : this.roundValue(valorSaldoAnt + nuevoValorEntrada - nuevoValorSalida);
                if (ponderar) {
                    pinventario = saldoAnt != 0.0 ? this.roundValue(valorSaldoAnt / saldoAnt) : (entrada != 0.0 ? valorEntrada : (salida != 0.0 ? valorSalida : hpinventario));
                }
                RQupdate.ejecutarSQL(conn, new String[]{String.valueOf(pinventario), String.valueOf(valorEntrada), String.valueOf(valorSalida), String.valueOf(saldoAnt), String.valueOf(valorSaldoAnt), orden});
                if (!estado) continue;
                historyInv.put(orden, new DataInventory(pinventario, entrada, valorEntrada, salida, valorSalida));
            }
            LinkingCache.setPCosto(this.bd, idBodega, idProducto, pinventario);
            LinkingCache.setSaldoInventario(this.bd, idBodega, idProducto, saldoAnt);
            LinkingCache.setVSaldoInventario(this.bd, idBodega, idProducto, valorSaldoAnt);
            RQupdate.closeStatement();
            RQdata.closeStatement();
            RSdata.close();
            if (!transaction) {
                ConnectionsPool.freeMultiConnection(this.bd, conn);
            }
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Hashtable<String, Double> cargarTraslados(Connection conn, String idBodega, String idProducto) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdata = new QueryRunner(this.bd, "SCS0107", new String[]{idBodega, idProducto});
        System.out.println("Cargando valor traslados de la bodega {" + idBodega + "} idProducto {" + idProducto + "}");
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        Hashtable<String, Double> data = new Hashtable<String, Double>();
        while (RSdata.next()) {
            String orden = RSdata.getString(1);
            Double valor = RSdata.getDouble(2);
            System.out.println("data: " + orden + " " + valor);
            data.put(orden, valor);
        }
        ConnectionsPool.freeMultiConnection(this.bd, conn);
        RSdata.close();
        return data;
    }

    private double getDBValue(Connection conn, String sql, String orden, String idProducto) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQventrada = new QueryRunner(this.bd, sql, new String[]{orden, idProducto});
        ResultSet RSventrada = RQventrada.ejecutarMTSELECT(conn);
        double valor = 0.0;
        if (RSventrada.next()) {
            valor = RSventrada.getDouble(1);
        }
        RQventrada.closeStatement();
        RSventrada.close();
        return valor;
    }

    private double roundValue(Double value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    private void deleteDocument() throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdpDocument = new QueryRunner(this.bd, "SCD0003", new String[0]);
        QueryRunner RQdropDocument = new QueryRunner(this.bd, "SCS0083", new String[]{CacheKeys.getKey("ndocumento")});
        QueryRunner RQdeleteDocument = new QueryRunner(this.bd, "SCD0002", new String[]{CacheKeys.getKey("ndocumento")});
        RQdpDocument.ejecutarSQL();
        RQdropDocument.ejecutarSQL();
        RQdeleteDocument.ejecutarSQL();
        RQdpDocument.closeStatement();
        RQdropDocument.closeStatement();
        RQdeleteDocument.closeStatement();
    }

    class Monitor
    extends Thread {
        int i;

        Monitor() {
        }

        public void setI(int i) {
            this.i = i;
        }

        @Override
        public void run() {
            int j = 0;
            while (true) {
                if (this.i != j) {
                    System.out.println("Hilo Generado " + this.i);
                    j = this.i;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    class RecoverData
    extends Thread {
        String _fecha;
        String _bodega;
        String _producto;
        HashMap<Integer, RecoverData> recoverList;
        Integer index;
        double _saldo;
        double _valorSaldo;
        boolean _transaction;

        RecoverData(HashMap<Integer, RecoverData> recoverList, Integer index, String fecha, String bodega, String producto, double saldo, double valorSaldo, boolean transaction) {
            this.recoverList = recoverList;
            this.index = index;
            this._fecha = fecha;
            this._bodega = bodega;
            this._producto = producto;
            this._saldo = saldo;
            this._valorSaldo = valorSaldo;
            this._transaction = transaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LNInventarios.this.recoverData(this._fecha, this._bodega, this._producto, this._saldo, this._valorSaldo, this._transaction);
            HashMap<Integer, RecoverData> hashMap = this.recoverList;
            synchronized (hashMap) {
                this.recoverList.remove(this.index);
                this.recoverList.notify();
            }
        }
    }

    class DataInventory {
        double pinventario = 0.0;
        double entrada = 0.0;
        double valorEntrada = 0.0;
        double salida = 0.0;
        double valorSalida = 0.0;

        public DataInventory(double pinventario, double entrada, double valorEntrada, double salida, double valorSalida) {
            this.pinventario = pinventario;
            this.entrada = entrada;
            this.valorEntrada = valorEntrada;
            this.salida = salida;
            this.valorSalida = valorSalida;
        }

        public double getEntrada() {
            return this.entrada;
        }

        public void setEntrada(double entrada) {
            this.entrada = entrada;
        }

        public double getPinventario() {
            return this.pinventario;
        }

        public void setPinventario(double pinventario) {
            this.pinventario = pinventario;
        }

        public double getSalida() {
            return this.salida;
        }

        public void setSalida(double salida) {
            this.salida = salida;
        }

        public double getValorEntrada() {
            return this.valorEntrada;
        }

        public void setValorEntrada(double valorEntrada) {
            this.valorEntrada = valorEntrada;
        }

        public double getValorSalida() {
            return this.valorSalida;
        }

        public void setValorSalida(double valorSalida) {
            this.valorSalida = valorSalida;
        }
    }
}

