/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import common.misc.formulas.BeanShell;
import common.misc.language.Language;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import server.businessrules.CacheKeys;
import server.businessrules.RunTransaction;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNSelectedField {
    private String fields;
    private String conditional;
    private int[] cols;
    private QueryRunner RQfields;
    private ArrayList<String> discartKeys;

    public LNSelectedField(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        try {
            CacheKeys.cleanKeys();
            this.analizar(doc.getRootElement(), pack, InfoSocket.getBd((SocketChannel)sock), false);
            this.RQfields.commit();
            RunTransaction.successMessage(sock, idTransaction, Language.getWord((String)"TRANSACTION_OK"));
        }
        catch (SQLNotFoundException SQLNFEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLNFEe.getMessage());
            this.RQfields.rollback();
        }
        catch (SQLBadArgumentsException SQLBAEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLBAEe.getMessage());
            this.RQfields.rollback();
        }
        catch (SQLException SQLEe) {
            RunTransaction.errorMessage(sock, idTransaction, SQLEe.getMessage());
            this.RQfields.rollback();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.RQfields.setAutoCommit(true);
    }

    public LNSelectedField(Element parameters, String bd) throws SQLNotFoundException, SQLBadArgumentsException {
        this.parametrizar(parameters, bd);
    }

    private void analizar(Element parametros, Element paquetes, String bd, boolean subparametro) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, IOException {
        Iterator parametro = parametros.getChildren().iterator();
        Iterator paquete = paquetes.getChildren().iterator();
        while (parametro.hasNext()) {
            Element data = (Element)parametro.next();
            Element pack = null;
            pack = !subparametro ? (Element)paquete.next() : (Element)paquetes.clone();
            try {
                if (data.getName().equals("LNData")) {
                    Element args = (Element)data.getChildren("parameters").iterator().next();
                    this.parametrizar(args, bd);
                    if (((Element)pack.getChildren().iterator().next()).getName().equals("field")) {
                        this.getFields(pack);
                        continue;
                    }
                    this.getSubPackage(pack);
                    continue;
                }
                if (data.getName().equals("arg")) {
                    if (((Element)pack.getChildren().iterator().next()).getName().equals("field")) {
                        this.getFields(bd, data, pack);
                        continue;
                    }
                    this.getSubPackage(bd, data, pack);
                    continue;
                }
                this.analizar((Element)data.clone(), (Element)pack.clone(), bd, true);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    private void parametrizar(Element parameters, String bd) throws SQLNotFoundException, SQLBadArgumentsException {
        Iterator i = parameters.getChildren().iterator();
        String sql = "";
        this.discartKeys = new ArrayList();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String attribute = e.getAttributeValue("attribute");
            String value = e.getValue();
            if ("fields".equals(attribute)) {
                this.fields = value;
                continue;
            }
            if ("sql".equals(attribute)) {
                sql = value;
                continue;
            }
            if ("conditional".equals(attribute)) {
                this.conditional = value;
                continue;
            }
            if (!"discartKey".equals(attribute)) continue;
            this.discartKeys.add(value);
        }
        this.RQfields = new QueryRunner(bd, sql);
        StringTokenizer STcols = new StringTokenizer(this.fields, ",");
        this.cols = new int[STcols.countTokens()];
        int j = 0;
        while (STcols.hasMoreTokens()) {
            this.cols[j] = Integer.parseInt(STcols.nextToken());
            ++j;
        }
    }

    public void getFields(String bd, Element args, Element pack) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        this.RQfields = new QueryRunner(bd, args.getValue());
        ArrayList<String> fieldSQL = new ArrayList<String>();
        Iterator valueKeys = CacheKeys.getKeys();
        while (valueKeys.hasNext()) {
            String key = (String)valueKeys.next();
            fieldSQL.add(key);
        }
        for (Element value : pack.getChildren()) {
            String text = value.getText();
            String key = value.getAttributeValue("attribute");
            String nameField = value.getAttributeValue("nameField");
            if ("key".equals(key)) {
                nameField = nameField == null ? "" : nameField;
                CacheKeys.setKey(nameField, text);
            }
            fieldSQL.add(text);
        }
        this.RQfields.ejecutarSQL(fieldSQL.toArray(new String[fieldSQL.size()]));
    }

    public void getFields(Element pack) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        List lpack = pack.getChildren();
        if (this.conditional != null && !BeanShell.eval((String)this.formulaReplacer(this.conditional, lpack))) {
            return;
        }
        ArrayList<String> fieldSQL = new ArrayList<String>();
        Iterator valueKeys = CacheKeys.getKeys();
        Iterator keys = CacheKeys.getHKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            boolean discart = false;
            for (int k = 0; k < this.discartKeys.size(); ++k) {
                if (!key.equals(this.discartKeys.get(k))) continue;
                System.out.println("--------------------------------------key descartada: " + this.discartKeys.get(k));
                discart = true;
                break;
            }
            System.out.println("-----------------------------------keys: " + key);
            String valor = (String)valueKeys.next();
            if (discart) continue;
            System.out.println("----------------------------------- addkeys: " + key + " valor " + valor);
            fieldSQL.add(valor);
        }
        for (int j = 0; j < this.cols.length; ++j) {
            fieldSQL.add(((Element)lpack.get(this.cols[j])).getValue());
        }
        this.RQfields.ejecutarSQL(fieldSQL.toArray(new String[fieldSQL.size()]));
    }

    private void getSubPackage(Element paquete) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        for (Element fields : paquete.getChildren()) {
            if (((Element)fields.getChildren().iterator().next()).getName().equals("field")) {
                this.getFields(fields);
                continue;
            }
            this.getSubPackage(fields);
        }
    }

    private void getSubPackage(String bd, Element data, Element paquete) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        for (Element fields : paquete.getChildren()) {
            if (((Element)fields.getChildren().iterator().next()).getName().equals("field")) {
                this.getFields(bd, data, fields);
                continue;
            }
            this.getSubPackage(bd, data, fields);
        }
    }

    private String formulaReplacer(String var, List lpack) {
        String newVar = "";
        for (int j = 0; j < var.length(); ++j) {
            if (j + 10 < var.length() && var.substring(j, j + 11).equals(".startsWith")) {
                String s = ".startsWith(" + var.substring(j + 12, var.indexOf(")", j + 12)) + ")";
                newVar = newVar + s;
                j = var.indexOf(")", j);
                continue;
            }
            if (j + 7 < var.length() && var.substring(j, j + 7).equals(".equals")) {
                String s = ".equals(" + var.substring(j + 8, var.indexOf(")", j + 8)) + ")";
                newVar = newVar + s;
                j = var.indexOf(")", j);
                continue;
            }
            if (var.charAt(j) >= 'A' && var.charAt(j) <= 'Z' || var.charAt(j) >= 'a' && var.charAt(j) <= 'z') {
                int col = var.charAt(j) <= 'Z' ? var.charAt(j) - 65 : var.charAt(j) - 97;
                newVar = newVar + ((Element)lpack.get(col)).getValue();
                continue;
            }
            newVar = newVar + var.substring(j, j + 1);
        }
        return newVar;
    }
}

