/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import dian.gov.co.facturaelectronica.structures_2_1.AuthorizationProvider;
import dian.gov.co.facturaelectronica.structures_2_1.AuthrorizedInvoices;
import dian.gov.co.facturaelectronica.structures_2_1.CoID2Type;
import dian.gov.co.facturaelectronica.structures_2_1.DianExtensionsType;
import dian.gov.co.facturaelectronica.structures_2_1.InvoiceControl;
import dian.gov.co.facturaelectronica.structures_2_1.SoftwareProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.KeyStoreException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ItemPropertyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PaymentMeansType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PricingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.BaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.BaseUnitMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ChargeIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CustomizationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DocumentCurrencyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DocumentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.EndDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.FreeOfChargeIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IdentificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IdentificationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.InvoiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.LineCountNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.MultiplierFactorNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PackSizeNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PaymentDueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PaymentMeansCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PerUnitAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.PriceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileExecutionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.RoundingAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.StartDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.TaxEvidenceIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UBLVersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UUIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ValueType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.ExtensionContentType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionsType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.InvoiceType;
import oasis.names.specification.ubl.schema.xsd.invoice_2.ObjectFactory;
import oasis.names.specification.ubl.schema.xsd.unqualifieddatatypes_2.IdentifierType;
import org.jdom.Content;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import server.businessrules.ElectronicDocumentException;
import server.businessrules.LNDocuments;
import server.businessrules.electronicdocuments.Crypto;
import server.businessrules.electronicdocuments.DescargaDocumentos;
import server.businessrules.electronicdocuments.ElementsForSigned;
import server.businessrules.electronicdocuments.InfoCliente;
import server.businessrules.electronicdocuments.InfoEmpresa;
import server.businessrules.electronicdocuments.MonetaryTotal;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.SaveCUFE;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SignedDocument;
import server.businessrules.electronicdocuments.UtilsXML;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class Invoice {
    private final String _MONEDA = "COP";
    private static final int ELECTRONIC_INVOICE = 1;
    private static final int CONTINGENCY_INVOICE = 7;
    private static final int AMBIENTE_HABILITACION = 2;
    private static final int AMBIENTE_PRODUCCION = 1;
    private int type_document;
    private Date date;
    private Hashtable<String, String> cliente;
    private Hashtable<String, Double> vtotales = new Hashtable();
    private Hashtable<String, TaxTotal> taxTotal = new Hashtable();
    private String fecfac;
    private String gTimeFormatted;
    private Connection conn;
    private String idTransaction;
    private String pin;
    private String id_registro_software;
    private String id_software_dian;
    private int id_tipo_ambiente;
    private String urlAmbiente;
    private String codigoOR;
    private String consecutivenc;
    private String CUFE;
    private String bd;
    private String conceptObject;
    private String codigo_tipo;
    private String consecutive;
    private String CITec;
    private String prefijoFA;
    private double totalRet;
    private double totalINCBolsa;
    final int TIPO_CONTADO = 1;
    final int TIPO_CREDITO = 2;
    final int PAGO_EFECTIVO = 10;
    final int PAGO_TDEBITO = 49;
    final int PAGO_TCREDITO = 48;
    final int PAGO_CONSIGNACION = 42;
    final int PAGO_CHEQUE = 20;
    final int PAGO_TRANSFERENCIA = 47;
    final int PAGO_CREDITO = 30;

    public Invoice(String bd, String idTransaction, int type_document, Date date, String codigo_tipo, String consecutive) {
        this.bd = bd;
        this.idTransaction = idTransaction;
        this.date = date;
        this.type_document = type_document;
        this.codigo_tipo = codigo_tipo;
        this.consecutive = consecutive;
        this.conn = ConnectionsPool.getConnection(bd);
    }

    public void makeDocument() throws KeyStoreException, UnsupportedOperationException, JAXBException, SQLException, SQLNotFoundException, SQLBadArgumentsException, ParserConfigurationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, ElectronicDocumentException, Exception {
        List<TaxTotalType> retenciones;
        Calendar calendar = Calendar.getInstance();
        long init = calendar.getTimeInMillis();
        InvoiceType invoiceType = new InvoiceType();
        UBLExtensionsType valueUBLExtensions = new UBLExtensionsType();
        UBLVersionIDType ublVersion = new UBLVersionIDType();
        ublVersion.setValue("UBL 2.1");
        invoiceType.setUBLVersionID(ublVersion);
        CustomizationIDType customizationID = new CustomizationIDType();
        customizationID.setValue("10");
        ProfileIDType versionDian = new ProfileIDType();
        versionDian.setValue("DIAN 2.1: Factura Electr\u00f3nica de Venta");
        invoiceType.setProfileID(versionDian);
        invoiceType.setCustomizationID(customizationID);
        invoiceType.setUBLExtensions(valueUBLExtensions);
        ProfileExecutionIDType profileExcecutionID = new ProfileExecutionIDType();
        invoiceType.setProfileExecutionID(profileExcecutionID);
        IDType invoiceID = new IDType();
        invoiceType.setID(invoiceID);
        UUIDType invoiceUUID = new UUIDType();
        if (this.type_document == 1) {
            invoiceUUID.setSchemeName("CUFE-SHA384");
        } else {
            invoiceUUID.setSchemeName("CUDE-SHA384");
        }
        invoiceType.setUUID(invoiceUUID);
        IssueDateType invoiceDate = new IssueDateType();
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        System.out.println("fecha en invoice: " + this.date);
        XMLGregorianCalendar gDateFormatted = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(this.date));
        invoiceDate.setValue(gDateFormatted);
        invoiceType.setIssueDate(invoiceDate);
        IssueTimeType invoiceTime = new IssueTimeType();
        FORMATER = "HH:mm:ssXXX";
        format = new SimpleDateFormat(FORMATER);
        this.gTimeFormatted = format.format(this.date);
        invoiceTime.setValue(this.gTimeFormatted);
        invoiceType.setIssueTime(invoiceTime);
        InvoiceTypeCodeType invoiceTypeCode = new InvoiceTypeCodeType();
        IDType id_contingencia = new IDType();
        if (this.type_document == 1) {
            invoiceTypeCode.setValue("01");
        } else {
            invoiceTypeCode.setValue("03");
            DocumentReferenceType contingencia = new DocumentReferenceType();
            contingencia.setID(id_contingencia);
            IssueDateType fecha_contingencia = new IssueDateType();
            fecha_contingencia.setValue(gDateFormatted);
            contingencia.setIssueDate(fecha_contingencia);
            DocumentTypeCodeType documento_referencia = new DocumentTypeCodeType();
            documento_referencia.setValue("FTC");
            contingencia.setDocumentTypeCode(documento_referencia);
            invoiceType.getAdditionalDocumentReference().add(contingencia);
        }
        invoiceType.setInvoiceTypeCode(invoiceTypeCode);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0005", new String[]{LNDocuments.LNTransaction().getKey(0)});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        ArrayList<String> notes = new ArrayList<String>();
        if (RSdata.next()) {
            int i;
            String note = RSdata.getString("observacion");
            String tmp_note = "";
            for (i = 0; i < note.length(); ++i) {
                if (tmp_note.length() > 50 && tmp_note.substring(tmp_note.length() - 1, tmp_note.length()).equals(" ")) {
                    notes.add(tmp_note.substring(0, tmp_note.length() - 1));
                    tmp_note = "";
                }
                if (i >= note.length()) continue;
                tmp_note = tmp_note + note.substring(i, i + 1);
            }
            notes.add(tmp_note);
            for (i = 0; i < notes.size(); ++i) {
                NoteType nota = new NoteType();
                nota.setValue((String)notes.get(i));
                invoiceType.getNote().add(nota);
            }
        }
        RSdata.close();
        DocumentCurrencyCodeType documentCurrency = new DocumentCurrencyCodeType();
        documentCurrency.setValue("COP");
        invoiceType.setDocumentCurrencyCode(documentCurrency);
        LineCountNumericType lineCountNumeric = new LineCountNumericType();
        invoiceType.setLineCountNumeric(lineCountNumeric);
        QueryRunner RQdata2 = new QueryRunner(this.bd, "SCSDE0004", new String[]{LNDocuments.LNTransaction().getKey(0)});
        ResultSet RSdata2 = RQdata2.ejecutarMTSELECT(this.conn);
        RSdata2.next();
        String numerofac = RSdata2.getString("numero");
        String fechai = RSdata2.getString("fechai");
        String fechaf = RSdata2.getString("fechaf");
        long desde = RSdata2.getLong("desde");
        long hasta = RSdata2.getLong("hasta");
        this.CITec = RSdata2.getString("clavet");
        this.prefijoFA = RSdata2.getString("prefijo");
        RSdata2.close();
        String factura = "";
        if (this.prefijoFA != null && !this.prefijoFA.equals("")) {
            invoiceID.setValue(this.prefijoFA + this.consecutive);
            factura = this.prefijoFA + this.consecutive;
        } else {
            invoiceID.setValue(this.consecutive);
            factura = this.consecutive;
        }
        if (this.type_document == 7) {
            id_contingencia.setValue(factura);
        }
        System.out.println("Valor seteado a la factura: " + factura + " prefijo " + this.prefijoFA + " consecutivo " + this.consecutive);
        InfoCliente infoCliente = new InfoCliente(this.bd, LNDocuments.LNTransaction().getKey(0));
        this.cliente = infoCliente.loadCliente();
        invoiceType.setAccountingCustomerParty(infoCliente.getCliente(this.prefijoFA));
        invoiceType.setTaxRepresentativeParty(DescargaDocumentos.getNitDescarga(this.cliente));
        List<TaxTotalType> incBolsa = this.totalINCBolsa(LNDocuments.LNTransaction().getKey(0));
        if (incBolsa != null) {
            invoiceType.getTaxTotal().addAll(incBolsa);
        }
        if ((retenciones = this.totalRetenciones(LNDocuments.LNTransaction().getKey(0))) != null) {
            invoiceType.getWithholdingTaxTotal().addAll(retenciones);
        }
        invoiceType.getInvoiceLine().addAll(this.listProductos(LNDocuments.LNTransaction().getKey(0)));
        double articulos = this.vtotales.get("articulos");
        BigDecimal bdarticulos = new BigDecimal(articulos);
        bdarticulos = bdarticulos.setScale(0, RoundingMode.HALF_UP);
        lineCountNumeric.setValue(bdarticulos);
        invoiceType.setLegalMonetaryTotal(MonetaryTotal.getTotales(this.vtotales, "COP"));
        invoiceType.getTaxTotal().addAll(this.totalIVAS());
        double vbase = this.vtotales.get("base");
        double vbase_ex = this.vtotales.get("base_excluida");
        BigDecimal bdbase = new BigDecimal(vbase + vbase_ex);
        bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
        double iva = this.vtotales.get("iva");
        BigDecimal bdiva = new BigDecimal(iva);
        bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
        System.out.println("iva: " + bdiva);
        double inc = this.vtotales.get("inc");
        BigDecimal bdinc = new BigDecimal(inc);
        bdinc = bdinc.setScale(2, RoundingMode.HALF_UP);
        System.out.println("inc: " + bdinc);
        double ica = this.vtotales.get("ica");
        BigDecimal bdica = new BigDecimal(ica);
        bdica = bdica.setScale(2, RoundingMode.HALF_UP);
        System.out.println("ica: " + bdica);
        double vtotal = this.vtotales.get("totalsinret");
        BigDecimal bdtotal = new BigDecimal(vtotal);
        bdtotal = bdtotal.setScale(2, RoundingMode.HALF_UP);
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        this.fecfac = ft.format(this.date);
        String numero = null;
        numero = this.prefijoFA != null ? this.prefijoFA + this.consecutive : this.consecutive;
        QueryRunner RQdata3 = new QueryRunner(this.bd, "SCSDE0008");
        ResultSet RSdata3 = RQdata3.ejecutarMTSELECT(this.conn);
        RSdata3.next();
        this.pin = RSdata3.getString("pin");
        this.id_software_dian = RSdata3.getString("identificador_software_dian");
        this.id_tipo_ambiente = RSdata3.getInt("id_tipo_ambiente");
        this.urlAmbiente = RSdata3.getString("url_ambiente");
        this.codigoOR = RSdata3.getString("codigo_obligacion_responsabilidad");
        this.id_registro_software = RSdata3.getString("id_registro_software");
        RSdata3.close();
        SimpleDateFormat ftcufe = new SimpleDateFormat("yyyy-MM-dd");
        String fechacufe = ftcufe.format(this.date);
        System.out.println("Tipo Ambiente: " + this.id_tipo_ambiente);
        this.CUFE = this.type_document == 1 ? numero + " " + fechacufe + " " + this.gTimeFormatted.toString() + " " + bdbase + " 01 " + bdiva + " 04 " + bdinc + " 03 " + bdica + " " + bdtotal + " " + LinkingCache.getNit(this.bd) + " " + this.cliente.get("nit") + " " + this.CITec + " " + this.id_tipo_ambiente : numero + " " + fechacufe + " " + this.gTimeFormatted.toString() + " " + bdbase + " 01 " + bdiva + " 04 " + bdinc + " 03 " + bdica + " " + bdtotal + " " + LinkingCache.getNit(this.bd) + " " + this.cliente.get("nit") + " " + this.pin + " " + this.id_tipo_ambiente;
        System.out.println("CUFE: " + this.CUFE);
        this.CUFE = this.CUFE.replaceAll("\\s+", "");
        System.out.println("CUFE REPLACE: " + this.CUFE);
        NoteType notacufe = new NoteType();
        notacufe.setValue(this.CUFE);
        invoiceType.getNote().add(notacufe);
        this.CUFE = Crypto.toSha384(this.CUFE);
        System.out.println("Sha384: " + this.CUFE);
        invoiceUUID.setValue(this.CUFE);
        ObjectFactory objectFactory = new ObjectFactory();
        SimpleDateFormat ftqr = new SimpleDateFormat("yyyy-MM-dd");
        String fechaqr = ftqr.format(this.date);
        valueUBLExtensions.getUBLExtension().add(this.valueUBLExtensionHeadersInvoice(factura, this.cliente.get("nit"), fechaqr, bdtotal, this.CUFE, numerofac, fechai, fechaf, desde, hasta));
        valueUBLExtensions.getUBLExtension().add(ElementsForSigned.getElement(this.date));
        profileExcecutionID.setValue(String.valueOf(this.id_tipo_ambiente));
        invoiceUUID.setSchemeID(String.valueOf(this.id_tipo_ambiente));
        InfoEmpresa empresa = new InfoEmpresa(this.bd);
        invoiceType.setAccountingSupplierParty(empresa.getEmpresa(this.prefijoFA, this.codigoOR));
        invoiceType.getPaymentMeans().addAll(this.formaPago(LNDocuments.LNTransaction().getKey(0)));
        JAXBElement je = objectFactory.createInvoice(invoiceType);
        this.generateXMLFile((JAXBElement<InvoiceType>)je, this.date, LNDocuments.LNTransaction().getKey(0));
        Calendar calendar2 = Calendar.getInstance();
        long end = calendar2.getTimeInMillis();
        System.out.print("Documento electronico generado en " + (end - init) + " milisegundos\n");
    }

    private List<TaxTotalType> totalINCBolsa(String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0023", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        ArrayList<TaxTotalType> totalINC = new ArrayList<TaxTotalType>();
        TaxTotalType totalINCBolsa = new TaxTotalType();
        TaxAmountType valorINCBolsa = new TaxAmountType();
        valorINCBolsa.setCurrencyID("COP");
        double unidad = 0.0;
        double total = 0.0;
        if (RSdata.next()) {
            unidad = RSdata.getDouble("unidad_bolsa");
            total = RSdata.getDouble("total_bolsa");
            RSdata.close();
            BigDecimal bdunidad = new BigDecimal(unidad);
            bdunidad = bdunidad.setScale(2, RoundingMode.HALF_UP);
            BigDecimal bdtotal = new BigDecimal(total);
            bdtotal = bdtotal.setScale(2, RoundingMode.HALF_UP);
            valorINCBolsa.setValue(bdtotal);
            TaxEvidenceIndicatorType taxEvidence = new TaxEvidenceIndicatorType();
            taxEvidence.setValue(false);
            totalINCBolsa.setTaxAmount(valorINCBolsa);
            totalINCBolsa.setTaxEvidenceIndicator(taxEvidence);
            TaxSubtotalType subTotalINCBolsa = new TaxSubtotalType();
            subTotalINCBolsa.setTaxAmount(valorINCBolsa);
            BaseUnitMeasureType unidadBolsa = new BaseUnitMeasureType();
            unidadBolsa.setUnitCode("NIU");
            subTotalINCBolsa.setBaseUnitMeasure(unidadBolsa);
            BigDecimal bdunidadBolsa = new BigDecimal(1);
            bdunidadBolsa = bdunidadBolsa.setScale(2, RoundingMode.HALF_UP);
            unidadBolsa.setValue(bdunidadBolsa);
            PerUnitAmountType perUnit = new PerUnitAmountType();
            perUnit.setCurrencyID("COP");
            perUnit.setValue(bdunidad);
            subTotalINCBolsa.setPerUnitAmount(perUnit);
            TaxCategoryType categoriaINC = new TaxCategoryType();
            TaxSchemeType taxSchemeINC = new TaxSchemeType();
            IDType idSchemeINC = new IDType();
            idSchemeINC.setValue("22");
            taxSchemeINC.setID(idSchemeINC);
            NameType nameINC = new NameType();
            nameINC.setValue("INC Bolsas");
            taxSchemeINC.setName(nameINC);
            categoriaINC.setTaxScheme(taxSchemeINC);
            subTotalINCBolsa.setTaxCategory(categoriaINC);
            totalINCBolsa.getTaxSubtotal().add(subTotalINCBolsa);
            totalINC.add(totalINCBolsa);
            System.out.println("total INC Bolsa: " + total);
            return totalINC;
        }
        return null;
    }

    private List<TaxTotalType> totalRetenciones(String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0021", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        ArrayList<TaxTotalType> totalRetenciones = new ArrayList<TaxTotalType>();
        while (RSdata.next()) {
            double vretencion = RSdata.getDouble("valor_retencion");
            this.totalRet += vretencion;
            BigDecimal bdretencion = new BigDecimal(vretencion);
            bdretencion = bdretencion.setScale(2, RoundingMode.HALF_UP);
            TaxTotalType totalRet = new TaxTotalType();
            TaxAmountType valorRetencion = new TaxAmountType();
            valorRetencion.setCurrencyID("COP");
            valorRetencion.setValue(bdretencion);
            totalRet.setTaxAmount(valorRetencion);
            TaxSubtotalType subTotalRet = new TaxSubtotalType();
            TaxableAmountType baseRet = new TaxableAmountType();
            baseRet.setCurrencyID("COP");
            double vbase = RSdata.getDouble("valor_base");
            BigDecimal bdbase = new BigDecimal(vbase);
            bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
            baseRet.setValue(bdbase);
            subTotalRet.setTaxableAmount(baseRet);
            subTotalRet.setTaxAmount(valorRetencion);
            PercentType porcentajeRet = new PercentType();
            double vporcentaje = RSdata.getDouble("porcentaje");
            BigDecimal bdporcentaje = new BigDecimal(vporcentaje);
            bdporcentaje = bdporcentaje.setScale(2, RoundingMode.HALF_UP);
            porcentajeRet.setValue(bdporcentaje);
            TaxCategoryType taxCategoryRet = new TaxCategoryType();
            taxCategoryRet.setPercent(porcentajeRet);
            TaxSchemeType taxShemeRet = new TaxSchemeType();
            IDType idShemeRet = new IDType();
            idShemeRet.setValue(RSdata.getString("id_retenciones_taxscheme"));
            taxShemeRet.setID(idShemeRet);
            NameType nameSchemeRet = new NameType();
            nameSchemeRet.setValue(RSdata.getString("descripcion"));
            taxShemeRet.setName(nameSchemeRet);
            taxCategoryRet.setTaxScheme(taxShemeRet);
            subTotalRet.setTaxCategory(taxCategoryRet);
            totalRet.getTaxSubtotal().add(subTotalRet);
            totalRetenciones.add(totalRet);
        }
        System.out.println("total Retenciones: " + this.totalRet);
        return totalRetenciones;
    }

    private List<InvoiceLineType> listProductos(String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ElectronicDocumentException {
        ArrayList<InvoiceLineType> listProductos = new ArrayList<InvoiceLineType>();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0003", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        double tsubtotal = 0.0;
        double tdescuento = 0.0;
        double tbase = 0.0;
        double tiva = 0.0;
        int line = 1;
        ResultSetMetaData rsmd = RSdata.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        while (RSdata.next()) {
            this.validValuesProdServ(RSdata.getString("descripcion"), RSdata.getDouble("cant"), RSdata.getDouble("neto"), RSdata.getDouble("pdescuento"), RSdata.getDouble("stotal"), RSdata.getDouble("vdescuento"), RSdata.getDouble("viva"), RSdata.getDouble("piva"), RSdata.getDouble("pventa"));
            InvoiceLineType productos = new InvoiceLineType();
            IDType IDp1 = new IDType();
            IDp1.setValue(String.valueOf(line++));
            productos.setID(IDp1);
            InvoicedQuantityType cant1 = new InvoicedQuantityType();
            cant1.setUnitCode("NIU");
            cant1.setValue(new BigDecimal(RSdata.getString("cant")));
            productos.setInvoicedQuantity(cant1);
            LineExtensionAmountType valorBase1 = new LineExtensionAmountType();
            valorBase1.setCurrencyID("COP");
            BigDecimal dvalorBase1 = new BigDecimal(RSdata.getDouble("neto"));
            dvalorBase1 = dvalorBase1.setScale(2, RoundingMode.HALF_UP);
            valorBase1.setValue(dvalorBase1);
            productos.setLineExtensionAmount(valorBase1);
            tsubtotal += dvalorBase1.doubleValue();
            FreeOfChargeIndicatorType freeOfCharger = new FreeOfChargeIndicatorType();
            freeOfCharger.setValue(false);
            productos.setFreeOfChargeIndicator(freeOfCharger);
            double pdescuento = RSdata.getDouble("pdescuento");
            double bdescuento = RSdata.getDouble("stotal");
            BigDecimal bdesc = new BigDecimal(bdescuento);
            bdesc = bdesc.setScale(2, RoundingMode.HALF_UP);
            if (pdescuento > 0.0) {
                AllowanceChargeType descuento = new AllowanceChargeType();
                ChargeIndicatorType chargerDesc = new ChargeIndicatorType();
                chargerDesc.setValue(false);
                descuento.setChargeIndicator(chargerDesc);
                IDType idDescuento = new IDType();
                idDescuento.setValue("1");
                descuento.setID(idDescuento);
                AllowanceChargeReasonType conceptoDescuento = new AllowanceChargeReasonType();
                conceptoDescuento.setValue("Descuento pie factura");
                descuento.getAllowanceChargeReason().add(conceptoDescuento);
                MultiplierFactorNumericType porcentajeDescuento = new MultiplierFactorNumericType();
                BigDecimal pdesc = new BigDecimal(pdescuento);
                pdesc = pdesc.setScale(2, RoundingMode.HALF_UP);
                porcentajeDescuento.setValue(pdesc);
                descuento.setMultiplierFactorNumeric(porcentajeDescuento);
                AmountType descAmount = new AmountType();
                double ddescuento = RSdata.getDouble("vdescuento");
                BigDecimal vdesc = new BigDecimal(ddescuento);
                vdesc = vdesc.setScale(2, RoundingMode.HALF_UP);
                descAmount.setValue(vdesc);
                tdescuento += ddescuento;
                descAmount.setCurrencyID("COP");
                descuento.setAmount(descAmount);
                BaseAmountType baseDescuento = new BaseAmountType();
                baseDescuento.setCurrencyID("COP");
                baseDescuento.setValue(bdesc);
                descuento.setBaseAmount(baseDescuento);
                productos.getAllowanceCharge().add(descuento);
            }
            TaxTotalType impuestos = new TaxTotalType();
            TaxAmountType iva = new TaxAmountType();
            double diva = RSdata.getDouble("viva");
            BigDecimal bdiva = new BigDecimal(diva);
            bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
            iva.setValue(bdiva);
            tiva += diva;
            iva.setCurrencyID("COP");
            impuestos.setTaxAmount(iva);
            TaxSubtotalType baseImpuesto = new TaxSubtotalType();
            TaxableAmountType base = new TaxableAmountType();
            double dbase = RSdata.getDouble("neto");
            BigDecimal bdbase = new BigDecimal(dbase);
            bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
            tbase += dbase;
            base.setValue(bdbase);
            base.setCurrencyID("COP");
            baseImpuesto.setTaxableAmount(base);
            TaxAmountType viva = new TaxAmountType();
            viva.setValue(bdiva);
            viva.setCurrencyID("COP");
            baseImpuesto.setTaxAmount(viva);
            TaxCategoryType taxCategory = new TaxCategoryType();
            PercentType piva = new PercentType();
            double dpiva = RSdata.getDouble("piva");
            BigDecimal bdpiva = new BigDecimal(dpiva);
            bdpiva = bdpiva.setScale(2, RoundingMode.HALF_UP);
            piva.setValue(bdpiva);
            taxCategory.setPercent(piva);
            impuestos.getTaxSubtotal().add(baseImpuesto);
            productos.getTaxTotal().add(impuestos);
            TaxTotal atotales = this.taxTotal.get(bdpiva.toString());
            double nbase = (atotales == null ? 0.0 : atotales.getBase()) + dbase;
            double niva = (atotales == null ? 0.0 : atotales.getIva()) + diva;
            System.out.println("ingresando valores de impuestos: porcentaje: " + bdpiva.toString() + " base " + nbase + " niva " + niva);
            this.taxTotal.put(bdpiva.toString(), new TaxTotal(nbase, niva));
            TaxSchemeType taxSheme1 = new TaxSchemeType();
            IDType idSheme1 = new IDType();
            idSheme1.setValue("01");
            taxSheme1.setID(idSheme1);
            NameType taxName1 = new NameType();
            taxName1.setValue("IVA");
            taxSheme1.setName(taxName1);
            taxCategory.setTaxScheme(taxSheme1);
            baseImpuesto.setTaxCategory(taxCategory);
            ItemType item1 = new ItemType();
            DescriptionType descripcionPpal = new DescriptionType();
            descripcionPpal.setValue(RSdata.getString("descripcion"));
            item1.getDescription().add(descripcionPpal);
            ItemIdentificationType idItem = new ItemIdentificationType();
            IDType codId = new IDType();
            codId.setSchemeID("999");
            codId.setValue(RSdata.getString("codigo").trim());
            idItem.setID(codId);
            item1.setStandardItemIdentification(idItem);
            String referencia = RSdata.getString("referencia");
            if (referencia != null) {
                ItemIdentificationType idReferencia = new ItemIdentificationType();
                IDType codRef = new IDType();
                codRef.setSchemeName("referencia");
                codRef.setValue(referencia);
                idReferencia.setID(codRef);
                item1.getAdditionalItemIdentification().add(idReferencia);
            }
            for (int i = 13; i <= columnsNumber; ++i) {
                ItemPropertyType add = new ItemPropertyType();
                NameType nameAddItem = new NameType();
                nameAddItem.setValue(rsmd.getColumnName(i));
                add.setName(nameAddItem);
                ValueType data = new ValueType();
                data.setValue(RSdata.getString(i));
                add.setValue(data);
                item1.getAdditionalItemProperty().add(add);
            }
            PriceType precio = new PriceType();
            PriceAmountType priceAmount = new PriceAmountType();
            double pventa = RSdata.getDouble("pventa");
            BigDecimal bdpventa = new BigDecimal(pventa);
            bdpventa = bdpventa.setScale(2, RoundingMode.HALF_UP);
            priceAmount.setValue(bdpventa);
            priceAmount.setCurrencyID("COP");
            precio.setPriceAmount(priceAmount);
            productos.setPrice(precio);
            productos.setItem(item1);
            PriceType precioItem1 = new PriceType();
            BigDecimal dunitario = new BigDecimal(RSdata.getDouble("pventa"));
            dunitario = dunitario.setScale(2, RoundingMode.HALF_UP);
            PriceAmountType precio1 = new PriceAmountType();
            precio1.setValue(dunitario);
            BaseQuantityType cantUnidad = new BaseQuantityType();
            cantUnidad.setUnitCode("NIU");
            cantUnidad.setValue(new BigDecimal(RSdata.getString("cant")));
            precioItem1.setBaseQuantity(cantUnidad);
            precio1.setCurrencyID("COP");
            precioItem1.setPriceAmount(precio1);
            productos.setPrice(precioItem1);
            if (dvalorBase1.doubleValue() == 0.0) {
                PricingReferenceType valorReferencia = new PricingReferenceType();
                PriceType valorComercial = new PriceType();
                valorComercial.setBaseQuantity(cantUnidad);
                PriceAmountType valorComercial1 = new PriceAmountType();
                valorComercial1.setValue(bdesc);
                valorComercial1.setCurrencyID("COP");
                valorComercial.setPriceAmount(valorComercial1);
                valorReferencia.getAlternativeConditionPrice().add(valorComercial);
                productos.setPricingReference(valorReferencia);
            }
            listProductos.add(productos);
        }
        List<InvoiceLineType> productosExcluidos = this.listProductosExcluidos(ndocumento, listProductos.size());
        double eSubtotal = 0.0;
        double eDescuento = 0.0;
        double eTbase = 0.0;
        double eTaxableAmount = 0.0;
        double eTotal = 0.0;
        double eTotalsinret = 0.0;
        double eArticulos = 0.0;
        System.out.println("Productos Excluidos: " + productosExcluidos.size());
        if (productosExcluidos.size() > 0) {
            listProductos.addAll(productosExcluidos);
            eSubtotal = this.vtotales.get("subtotal");
            eTbase = this.vtotales.get("base");
            eTaxableAmount = this.vtotales.get("taxableAmount");
            eTotal = this.vtotales.get("total");
            eTotalsinret = this.vtotales.get("totalsinret");
            System.out.println("eSubtotal: " + eSubtotal + "\n eDescuento: " + eDescuento + "\n eTbase " + eTbase + "\n eTaxableAmount " + eTaxableAmount + "\n eTotal " + eTotal + "\n eTotalsinret " + eTotalsinret);
        }
        this.vtotales.put("subtotal", eSubtotal + tsubtotal);
        this.vtotales.put("base", eTbase + tbase);
        this.vtotales.put("taxableAmount", eTaxableAmount + tbase);
        this.vtotales.put("iva", tiva);
        this.vtotales.put("inc", new Double(0.0));
        this.vtotales.put("ica", new Double(0.0));
        System.out.println("-+-+-+-+-+-+-++-+-+-+-Total REtenciones: " + this.totalRet);
        this.vtotales.put("total", eTotal + (tbase + tiva + this.totalINCBolsa - this.totalRet));
        this.vtotales.put("totalsinret", eTotalsinret + (tbase + tiva + this.totalINCBolsa));
        System.out.println("total articulos inc: " + eArticulos + " exentos: " + productosExcluidos.size() + " grabados " + listProductos.size());
        this.vtotales.put("articulos", new Double(listProductos.size()));
        RSdata.close();
        return listProductos;
    }

    private void validValuesProdServ(String prod_serv, double cant, double neto, double pdescuento, double stotal, double vdescuento, double viva, double piva, double pventa) throws ElectronicDocumentException {
        if (cant < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra una cantidad negativa (" + cant + "), por favor informe a soporte tecnico", false);
        }
        if (neto < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un valor neto negativo (" + neto + "), por favor informe a soporte tecnico", false);
        }
        if (pdescuento < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un valor porcentaje de descuento negativo (" + pdescuento + "), por favor informe a soporte tecnico", false);
        }
        if (pdescuento > 100.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un valor porcentaje de descuento superior a 100% (" + pdescuento + "), por favor informe a soporte tecnico", false);
        }
        if (stotal < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un valor subtotal negativo (" + stotal + "), por favor informe a soporte tecnico", false);
        }
        if (vdescuento < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un valor de descuento negativo (" + vdescuento + "), por favor informe a soporte tecnico", false);
        }
        if (viva < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un valor de iva negativo (" + viva + "), por favor informe a soporte tecnico", false);
        }
        if (piva < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra un porcentaje de iva negativo (" + piva + "), por favor informe a soporte tecnico", false);
        }
        if (pventa < 0.0) {
            throw new ElectronicDocumentException("Error, la consulta del producto " + prod_serv + "\nmuestra una precio de venta negativo (" + pventa + "), por favor informe a soporte tecnico", false);
        }
    }

    private List<InvoiceLineType> listProductosExcluidos(String ndocumento, int line) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ElectronicDocumentException {
        ArrayList<InvoiceLineType> listProductos = new ArrayList<InvoiceLineType>();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0026", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        double tsubtotal = 0.0;
        double tdescuento = 0.0;
        double tbase = 0.0;
        int id = line;
        ResultSetMetaData rsmd = RSdata.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        while (RSdata.next()) {
            InvoiceLineType productos = new InvoiceLineType();
            IDType IDp1 = new IDType();
            IDp1.setValue(String.valueOf(++id));
            productos.setID(IDp1);
            this.validValuesProdServ(RSdata.getString("descripcion"), RSdata.getDouble("cant"), RSdata.getDouble("neto"), RSdata.getDouble("pdescuento"), RSdata.getDouble("stotal"), RSdata.getDouble("vdescuento"), RSdata.getDouble("viva"), RSdata.getDouble("piva"), RSdata.getDouble("pventa"));
            InvoicedQuantityType cant1 = new InvoicedQuantityType();
            cant1.setUnitCode("NIU");
            cant1.setValue(new BigDecimal(RSdata.getString("cant")));
            productos.setInvoicedQuantity(cant1);
            LineExtensionAmountType valorBase1 = new LineExtensionAmountType();
            valorBase1.setCurrencyID("COP");
            BigDecimal dvalorBase1 = new BigDecimal(RSdata.getDouble("neto"));
            dvalorBase1 = dvalorBase1.setScale(2, RoundingMode.HALF_UP);
            valorBase1.setValue(dvalorBase1);
            productos.setLineExtensionAmount(valorBase1);
            tsubtotal += dvalorBase1.doubleValue();
            FreeOfChargeIndicatorType freeOfCharger = new FreeOfChargeIndicatorType();
            freeOfCharger.setValue(false);
            productos.setFreeOfChargeIndicator(freeOfCharger);
            ItemType item1 = new ItemType();
            DescriptionType descripcionPpal = new DescriptionType();
            descripcionPpal.setValue(RSdata.getString("descripcion"));
            item1.getDescription().add(descripcionPpal);
            ItemIdentificationType idItem = new ItemIdentificationType();
            IDType codId = new IDType();
            codId.setValue(RSdata.getString("codigo").trim());
            idItem.setID(codId);
            codId.setSchemeID("999");
            item1.setStandardItemIdentification(idItem);
            String referencia = RSdata.getString("referencia");
            if (referencia != null) {
                ItemIdentificationType idReferencia = new ItemIdentificationType();
                IDType codRef = new IDType();
                codRef.setSchemeName("referencia");
                codRef.setValue(referencia);
                idReferencia.setID(codRef);
                item1.getAdditionalItemIdentification().add(idReferencia);
            }
            double pdescuento = RSdata.getDouble("pdescuento");
            double bdescuento = RSdata.getDouble("stotal");
            BigDecimal bdesc = new BigDecimal(bdescuento);
            bdesc = bdesc.setScale(2, RoundingMode.HALF_UP);
            if (pdescuento > 0.0) {
                AllowanceChargeType descuento = new AllowanceChargeType();
                ChargeIndicatorType chargerDesc = new ChargeIndicatorType();
                chargerDesc.setValue(false);
                descuento.setChargeIndicator(chargerDesc);
                IDType idDescuento = new IDType();
                idDescuento.setValue("1");
                descuento.setID(idDescuento);
                AllowanceChargeReasonType conceptoDescuento = new AllowanceChargeReasonType();
                conceptoDescuento.setValue("Descuento pie factura");
                descuento.getAllowanceChargeReason().add(conceptoDescuento);
                MultiplierFactorNumericType porcentajeDescuento = new MultiplierFactorNumericType();
                BigDecimal pdesc = new BigDecimal(pdescuento);
                pdesc = pdesc.setScale(2, RoundingMode.HALF_UP);
                porcentajeDescuento.setValue(pdesc);
                descuento.setMultiplierFactorNumeric(porcentajeDescuento);
                AmountType descAmount = new AmountType();
                double ddescuento = RSdata.getDouble("vdescuento");
                BigDecimal vdesc = new BigDecimal(ddescuento);
                vdesc = vdesc.setScale(2, RoundingMode.HALF_UP);
                descAmount.setValue(vdesc);
                tdescuento += ddescuento;
                descAmount.setCurrencyID("COP");
                descuento.setAmount(descAmount);
                BaseAmountType baseDescuento = new BaseAmountType();
                baseDescuento.setCurrencyID("COP");
                descuento.setBaseAmount(baseDescuento);
                baseDescuento.setValue(bdesc);
                productos.getAllowanceCharge().add(descuento);
            }
            for (int i = 13; i <= columnsNumber; ++i) {
                ItemPropertyType add = new ItemPropertyType();
                NameType nameAddItem = new NameType();
                nameAddItem.setValue(rsmd.getColumnName(i));
                add.setName(nameAddItem);
                ValueType data = new ValueType();
                data.setValue(RSdata.getString(i));
                add.setValue(data);
                item1.getAdditionalItemProperty().add(add);
            }
            PriceType precio = new PriceType();
            PriceAmountType priceAmount = new PriceAmountType();
            double pventa = RSdata.getDouble("pventa");
            BigDecimal bdpventa = new BigDecimal(pventa);
            bdpventa = bdpventa.setScale(2, RoundingMode.HALF_UP);
            priceAmount.setValue(bdpventa);
            priceAmount.setCurrencyID("COP");
            precio.setPriceAmount(priceAmount);
            productos.setPrice(precio);
            productos.setItem(item1);
            PriceType precioItem1 = new PriceType();
            BigDecimal dunitario = new BigDecimal(RSdata.getDouble("pventa"));
            dunitario = dunitario.setScale(2, RoundingMode.HALF_UP);
            PriceAmountType precio1 = new PriceAmountType();
            precio1.setValue(dunitario);
            BaseQuantityType cantUnidad = new BaseQuantityType();
            cantUnidad.setUnitCode("NIU");
            cantUnidad.setValue(new BigDecimal(RSdata.getString("cant")));
            precioItem1.setBaseQuantity(cantUnidad);
            precio1.setCurrencyID("COP");
            precioItem1.setPriceAmount(precio1);
            productos.setPrice(precioItem1);
            if (dvalorBase1.doubleValue() == 0.0) {
                PricingReferenceType valorReferencia = new PricingReferenceType();
                PriceType valorComercial = new PriceType();
                valorComercial.setBaseQuantity(cantUnidad);
                PriceAmountType valorComercial1 = new PriceAmountType();
                valorComercial1.setValue(bdesc);
                valorComercial1.setCurrencyID("COP");
                valorComercial.setPriceAmount(valorComercial1);
                valorReferencia.getAlternativeConditionPrice().add(valorComercial);
                productos.setPricingReference(valorReferencia);
            }
            listProductos.add(productos);
        }
        double nbase = 0.0;
        double niva = 0.0;
        System.out.println("ingresando valores de impuestos: porcentaje: 0 base " + nbase + " niva " + niva);
        InvoiceLineType incBolsa = this.incBolsaList(ndocumento, line + listProductos.size());
        if (incBolsa != null) {
            listProductos.add(incBolsa);
            this.vtotales.put("articulos", new Double(1.0));
        }
        this.vtotales.put("subtotal", tsubtotal);
        this.vtotales.put("descuento", tdescuento);
        this.vtotales.put("base", tbase);
        this.vtotales.put("taxableAmount", new Double(0.0));
        this.vtotales.put("iva", new Double(0.0));
        this.vtotales.put("inc", new Double(0.0));
        this.vtotales.put("ica", new Double(0.0));
        System.out.println("-+-+-+-+-+-+-++-+-+-+-Total REtenciones: " + this.totalRet);
        this.vtotales.put("total", tsubtotal);
        this.vtotales.put("totalsinret", tsubtotal);
        this.vtotales.put("base_excluida", tsubtotal);
        RSdata.close();
        return listProductos;
    }

    private List<TaxTotalType> totalIVAS() {
        System.out.println("--------------------------------");
        Enumeration<String> porcentajes = this.taxTotal.keys();
        ArrayList<TaxTotalType> totalImpuestos = new ArrayList<TaxTotalType>();
        TaxTotalType totalIVA = new TaxTotalType();
        TaxAmountType valorIVA = new TaxAmountType();
        valorIVA.setCurrencyID("COP");
        boolean tarifas = false;
        double viva = 0.0;
        while (porcentajes.hasMoreElements()) {
            tarifas = true;
            String siva = porcentajes.nextElement();
            System.out.println("portentaje: " + siva);
            TaxAmountType svalorIVA = new TaxAmountType();
            svalorIVA.setCurrencyID("COP");
            TaxTotal totalImp = this.taxTotal.get(siva);
            double sviva = totalImp.getIva();
            viva += sviva;
            BigDecimal bdsiva = new BigDecimal(sviva);
            bdsiva = bdsiva.setScale(2, RoundingMode.HALF_UP);
            svalorIVA.setValue(bdsiva);
            TaxSubtotalType subTotal1 = new TaxSubtotalType();
            TaxableAmountType base1 = new TaxableAmountType();
            base1.setCurrencyID("COP");
            double vbase = totalImp.getBase();
            BigDecimal bdbase = new BigDecimal(vbase);
            bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
            base1.setValue(bdbase);
            subTotal1.setTaxableAmount(base1);
            subTotal1.setTaxAmount(svalorIVA);
            PercentType porcentaje1 = new PercentType();
            double diva = Double.parseDouble(siva);
            BigDecimal bdpiva = new BigDecimal(diva);
            bdpiva = bdpiva.setScale(2, RoundingMode.HALF_UP);
            porcentaje1.setValue(bdpiva);
            TaxCategoryType taxCategory1 = new TaxCategoryType();
            taxCategory1.setPercent(porcentaje1);
            TaxSchemeType taxSheme1 = new TaxSchemeType();
            IDType idSheme1 = new IDType();
            if (totalImp.getBase() == 0.0 && totalImp.getIva() == 0.0) {
                idSheme1.setValue("YZ");
            } else {
                idSheme1.setValue("01");
            }
            taxSheme1.setID(idSheme1);
            NameType nameImp = new NameType();
            if (totalImp.getBase() == 0.0 && totalImp.getIva() == 0.0) {
                nameImp.setValue("No Causa");
            } else {
                nameImp.setValue("IVA");
            }
            RoundingAmountType redondeo = new RoundingAmountType();
            redondeo.setCurrencyID("COP");
            BigDecimal bdround = new BigDecimal(0);
            bdround = bdround.setScale(2, RoundingMode.HALF_UP);
            redondeo.setValue(bdround);
            totalIVA.setRoundingAmount(redondeo);
            taxSheme1.setName(nameImp);
            taxCategory1.setTaxScheme(taxSheme1);
            subTotal1.setTaxCategory(taxCategory1);
            totalIVA.getTaxSubtotal().add(subTotal1);
        }
        BigDecimal bdiva = new BigDecimal(viva);
        bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
        valorIVA.setValue(bdiva);
        totalIVA.setTaxAmount(valorIVA);
        if (tarifas) {
            totalImpuestos.add(totalIVA);
        }
        return totalImpuestos;
    }

    private UBLExtensionType valueUBLExtensionHeadersInvoice(String factura, String adquiriente, String fechaFactura, BigDecimal valorFactura, String CUFE, String numerofac, String fechai, String fechaf, long desde, long hasta) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        UBLExtensionType valueUBLExtensionHeaders = new UBLExtensionType();
        ExtensionContentType extensionContentTypeHeaders = new ExtensionContentType();
        DianExtensionsType dianExtensionsType = new DianExtensionsType();
        InvoiceControl invoiceControl = new InvoiceControl();
        invoiceControl.setInvoiceAuthorization(new BigDecimal(numerofac));
        PeriodType authorizationPeriod = new PeriodType();
        StartDateType startDate = new StartDateType();
        EndDateType endDate = new EndDateType();
        try {
            startDate.setValue(fechai);
            endDate.setValue(fechaf);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        authorizationPeriod.setStartDate(startDate);
        authorizationPeriod.setEndDate(endDate);
        invoiceControl.setAuthorizationPeriod(authorizationPeriod);
        AuthrorizedInvoices authorizedInvoices = new AuthrorizedInvoices();
        authorizedInvoices.setPrefix(this.prefijoFA);
        authorizedInvoices.setFrom((long)((int)desde));
        authorizedInvoices.setTo((long)((int)hasta));
        invoiceControl.setAuthorizedInvoices(authorizedInvoices);
        CountryType country = new CountryType();
        IdentificationCodeType codeCountry = new IdentificationCodeType();
        codeCountry.setListAgencyID("6");
        codeCountry.setListSchemeURI("urn:oasis:names:specification:ubl:codelist:gc:CountryIdentificationCode-2.1");
        country.setIdentificationCode(codeCountry);
        codeCountry.setListAgencyName("United Nations Economic Commission for Europe");
        codeCountry.setValue("CO");
        dianExtensionsType.setInvoiceSource(country);
        SoftwareProvider softwareProvider = new SoftwareProvider();
        CoID2Type idProviderSoftware = new CoID2Type();
        idProviderSoftware.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        idProviderSoftware.setSchemeAgencyID("195");
        idProviderSoftware.setValue(LinkingCache.getNit(this.bd));
        idProviderSoftware.setSchemeID(LinkingCache.getDV(this.bd));
        idProviderSoftware.setSchemeName("31");
        IdentificationIDType idSoftware = new IdentificationIDType();
        idSoftware.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        idSoftware.setSchemeAgencyID("195");
        idSoftware.setValue(this.id_software_dian);
        System.out.println("Software security code id_software_dian=" + this.id_software_dian + "+ pin " + this.pin + "+ factura " + factura);
        String sec = Crypto.toSha384(this.id_software_dian + this.pin + factura);
        IdentifierType softwareSecurity = new IdentifierType();
        softwareSecurity.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        softwareSecurity.setSchemeAgencyID("195");
        softwareSecurity.setValue(sec);
        CoID2Type authorizationProviderID = new CoID2Type();
        authorizationProviderID.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        authorizationProviderID.setSchemeAgencyID("195");
        authorizationProviderID.setSchemeID("4");
        authorizationProviderID.setSchemeName("31");
        authorizationProviderID.setValue("800197268");
        AuthorizationProvider authorizationProvider = new AuthorizationProvider();
        authorizationProvider.setAuthorizationProviderID(authorizationProviderID);
        String qr = "NroFactura=" + factura + "\nNitFacturador=" + LinkingCache.getNit(this.bd) + "\nNitAdquiriente=" + adquiriente + "\nFechaFactura=" + fechaFactura + "\nValorTotalFactura=" + valorFactura + "\nCUFE=" + CUFE + "\nURL=https://catalogo-vpfe-hab.dian.gov.co/Document/FindDocument?documentKey=" + CUFE;
        softwareProvider.setProviderID(idProviderSoftware);
        softwareProvider.setSoftwareID((IdentifierType)idSoftware);
        dianExtensionsType.setSoftwareProvider(softwareProvider);
        dianExtensionsType.setSoftwareSecurityCode(softwareSecurity);
        dianExtensionsType.setAuthorizationProvider(authorizationProvider);
        dianExtensionsType.setQRCode(qr);
        dianExtensionsType.setInvoiceControl(invoiceControl);
        extensionContentTypeHeaders.setDianExtensionsType(dianExtensionsType);
        valueUBLExtensionHeaders.setExtensionContent(extensionContentTypeHeaders);
        return valueUBLExtensionHeaders;
    }

    private ArrayList<PaymentMeansType> formaPago(String documento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException {
        ArrayList<PaymentMeansType> listaFormaPago = new ArrayList<PaymentMeansType>();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0029", new String[]{documento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        RSdata.next();
        double efectivo = RSdata.getDouble("efectivo");
        double tcredito = RSdata.getDouble("tcredito");
        double cheque = RSdata.getDouble("cheque");
        double consignacion = RSdata.getDouble("consignacion");
        double traslado = RSdata.getDouble("traslado");
        double tdebito = RSdata.getDouble("tdebito");
        double cxc = RSdata.getDouble("cxc");
        RSdata.close();
        if (efectivo > 0.0) {
            listaFormaPago.add(this.formaPago(1, 10));
        }
        if (tcredito > 0.0) {
            listaFormaPago.add(this.formaPago(1, 48));
        }
        if (cheque > 0.0) {
            listaFormaPago.add(this.formaPago(1, 20));
        }
        if (consignacion > 0.0) {
            listaFormaPago.add(this.formaPago(1, 42));
        }
        if (traslado > 0.0) {
            listaFormaPago.add(this.formaPago(1, 47));
        }
        if (tdebito > 0.0) {
            listaFormaPago.add(this.formaPago(1, 49));
        }
        if (cxc > 0.0) {
            PaymentMeansType formaPago = this.formaPago(2, 30);
            RQdata = new QueryRunner(this.bd, "SCSDE0022", new String[]{documento});
            RSdata = RQdata.ejecutarMTSELECT(this.conn);
            RSdata.next();
            String vencimiento = RSdata.getString("vencimiento");
            RSdata.close();
            PaymentDueDateType paymentDueDate = new PaymentDueDateType();
            paymentDueDate.setValue(vencimiento);
            formaPago.setPaymentDueDate(paymentDueDate);
            listaFormaPago.add(formaPago);
        }
        return listaFormaPago;
    }

    private PaymentMeansType formaPago(int tipopago, int pago) {
        PaymentMeansType formaPago = new PaymentMeansType();
        IDType tipo = new IDType();
        tipo.setValue("" + tipopago);
        formaPago.setID(tipo);
        PaymentMeansCodeType paymentMeansCode = new PaymentMeansCodeType();
        paymentMeansCode.setValue("" + pago);
        formaPago.setPaymentMeansCode(paymentMeansCode);
        return formaPago;
    }

    private void generateXMLFile(JAXBElement<InvoiceType> je, Date date, String ndocument_db) throws SendDianException, Exception {
        Element reportNode;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{InvoiceType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        String sdate = format.format(date);
        String nit = LinkingCache.getNit(this.bd).trim();
        String nitPath = "0000000000".substring(nit.length()) + nit;
        String pathInvoice = new String("/home/emaku/ElectronicDocuments/" + LinkingCache.getNit(this.bd) + "/" + sdate + "/Invoice/" + this.codigo_tipo);
        String year2 = sdate.substring(2, 4);
        String envios = "1";
        if (this.type_document == 1) {
            QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0025");
            ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
            if (RSdata.next()) {
                envios = RSdata.getString("consecutivo_envio");
            }
            RSdata.close();
        } else {
            envios = this.consecutive;
        }
        String typeDocument = "Invoice";
        String nenvio = "00000000".substring(envios.length()) + envios;
        String namefile = "fv" + nitPath + "000" + year2 + nenvio + ".xml";
        String fullPath = new String("/home/emaku/ElectronicDocuments/" + LinkingCache.getNit(this.bd) + "/" + sdate + "/" + typeDocument + "/" + this.codigo_tipo + "/" + namefile);
        String bdPath = new String(LinkingCache.getNit(this.bd) + "/" + sdate + "/" + typeDocument + "/" + this.codigo_tipo + "/" + namefile);
        SaveCUFE saveCUFE = new SaveCUFE(this.bd, this.idTransaction, this.id_registro_software, this.type_document, this.consecutive, this.consecutivenc, this.vtotales, this.cliente, this.fecfac, this.CUFE);
        saveCUFE.save(bdPath);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        marshaller.marshal(je, (Node)document);
        long inicio = System.currentTimeMillis();
        document.getElementsByTagName("fe:Invoice");
        Element reportElement = reportNode = document.getDocumentElement();
        document.renameNode(reportElement, "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2", "Invoice");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xmlns:xsi");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeRootAttribute(document, "xmlns:fe");
        document = UtilsXML.removeRootAttribute(document, "xmlns:ns7");
        document = UtilsXML.removeRootAttribute(document, "xmlns:xs");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades141", "http://uri.etsi.org/01903/v1.4.1#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document = UtilsXML.addRootAttribute(document, "xsi:schemaLocation", "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2     http://docs.oasis-open.org/ubl/os-UBL-2.1/xsd/maindoc/UBL-Invoice-2.1.xsd");
        long fin = System.currentTimeMillis();
        double tiempo = (fin - inicio) / 1000L;
        System.out.println("tiempo de re-etiquetado " + tiempo + " segundos");
        System.out.println("------------------inicio factura electronica ----------------");
        marshaller.marshal(je, (OutputStream)System.out);
        Document docEpes = PrintXML.parser(document);
        System.out.println("------------------fin factura electronica ----------------");
        File pathDocument = new File(pathInvoice);
        if (!pathDocument.exists()) {
            pathDocument.mkdirs();
        }
        if (this.type_document != 7) {
            SignedDocument sign = new SignedDocument(this.bd, ndocument_db, this.idTransaction, this.type_document);
            sign.signEpes(this.urlAmbiente, this.id_tipo_ambiente, docEpes, fullPath);
        } else {
            DOMSource source = new DOMSource(docEpes);
            FileWriter writer = new FileWriter(new File(fullPath));
            StreamResult result = new StreamResult(writer);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, result);
        }
    }

    private InvoiceLineType incBolsaList(String ndocumento, int id) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        InvoiceLineType incBolsa = new InvoiceLineType();
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSDE0024", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(this.conn);
        if (RSdata.next()) {
            IDType idBolsa = new IDType();
            idBolsa.setValue(String.valueOf(++id));
            incBolsa.setID(idBolsa);
            InvoicedQuantityType quantityBolsa = new InvoicedQuantityType();
            BigDecimal bdcantBolsa = new BigDecimal(RSdata.getDouble("cant"));
            bdcantBolsa = bdcantBolsa.setScale(2, RoundingMode.HALF_UP);
            quantityBolsa.setUnitCode("NIU");
            quantityBolsa.setValue(bdcantBolsa);
            incBolsa.setInvoicedQuantity(quantityBolsa);
            LineExtensionAmountType lineBolsa = new LineExtensionAmountType();
            lineBolsa.setCurrencyID("COP");
            lineBolsa.setValue(new BigDecimal(0));
            incBolsa.setLineExtensionAmount(lineBolsa);
            PricingReferenceType precioReferencia = new PricingReferenceType();
            PriceType precioAlterno = new PriceType();
            PriceAmountType precioBolsa = new PriceAmountType();
            precioBolsa.setCurrencyID("COP");
            precioBolsa.setValue(new BigDecimal(1));
            precioAlterno.setPriceAmount(precioBolsa);
            PriceTypeCodeType priceTypeCode = new PriceTypeCodeType();
            priceTypeCode.setValue("01");
            precioAlterno.setPriceTypeCode(priceTypeCode);
            precioReferencia.getAlternativeConditionPrice().add(precioAlterno);
            incBolsa.setPricingReference(precioReferencia);
            TaxTotalType taxBolsa = new TaxTotalType();
            TaxAmountType taxAmountBolsa = new TaxAmountType();
            taxAmountBolsa.setCurrencyID("COP");
            BigDecimal bdtotalBolsas = new BigDecimal(RSdata.getDouble("total_bolsas"));
            bdtotalBolsas = bdtotalBolsas.setScale(2, RoundingMode.HALF_UP);
            this.totalINCBolsa = bdtotalBolsas.doubleValue();
            taxAmountBolsa.setValue(bdtotalBolsas);
            taxBolsa.setTaxAmount(taxAmountBolsa);
            TaxSubtotalType subTotalBolsa = new TaxSubtotalType();
            subTotalBolsa.setTaxAmount(taxAmountBolsa);
            BaseUnitMeasureType baseBolsa = new BaseUnitMeasureType();
            baseBolsa.setUnitCode("NIU");
            baseBolsa.setValue(new BigDecimal(1));
            subTotalBolsa.setBaseUnitMeasure(baseBolsa);
            PerUnitAmountType perBolsa = new PerUnitAmountType();
            perBolsa.setCurrencyID("COP");
            BigDecimal bdvunitarioBolsas = new BigDecimal(RSdata.getDouble("vunitario_bolsa"));
            bdvunitarioBolsas = bdvunitarioBolsas.setScale(2, RoundingMode.HALF_UP);
            perBolsa.setValue(bdvunitarioBolsas);
            subTotalBolsa.setPerUnitAmount(perBolsa);
            TaxCategoryType taxCategory = new TaxCategoryType();
            TaxSchemeType taxSheme1 = new TaxSchemeType();
            IDType idSheme1 = new IDType();
            idSheme1.setValue("22");
            taxSheme1.setID(idSheme1);
            NameType taxName1 = new NameType();
            taxName1.setValue("BOLSAS");
            taxSheme1.setName(taxName1);
            taxCategory.setTaxScheme(taxSheme1);
            subTotalBolsa.setTaxCategory(taxCategory);
            taxBolsa.getTaxSubtotal().add(subTotalBolsa);
            incBolsa.getTaxTotal().add(taxBolsa);
            ItemType itemBolsa = new ItemType();
            DescriptionType descripcionBolsa = new DescriptionType();
            descripcionBolsa.setValue("INC Bolsa Plastica");
            itemBolsa.getDescription().add(descripcionBolsa);
            PackSizeNumericType packBolsa = new PackSizeNumericType();
            packBolsa.setValue(new BigDecimal(1));
            itemBolsa.setPackSizeNumeric(packBolsa);
            ItemIdentificationType idItem = new ItemIdentificationType();
            IDType codigoInternoBolsa = new IDType();
            codigoInternoBolsa.setValue(RSdata.getString("codigo").trim());
            idItem.setID(codigoInternoBolsa);
            codigoInternoBolsa.setSchemeID("999");
            codigoInternoBolsa.setValue(RSdata.getString("codigo").trim());
            itemBolsa.setStandardItemIdentification(idItem);
            incBolsa.setItem(itemBolsa);
            PriceType precioItem1 = new PriceType();
            BigDecimal dunitario = new BigDecimal(0);
            dunitario = dunitario.setScale(2, RoundingMode.HALF_UP);
            PriceAmountType precio1 = new PriceAmountType();
            precio1.setCurrencyID("COP");
            precio1.setValue(dunitario);
            precioItem1.setPriceAmount(precio1);
            BaseQuantityType cantUnidad = new BaseQuantityType();
            cantUnidad.setUnitCode("NIU");
            cantUnidad.setValue(new BigDecimal(1));
            precioItem1.setBaseQuantity(cantUnidad);
            incBolsa.setPrice(precioItem1);
            return incBolsa;
        }
        return null;
    }

    public org.jdom.Element getQRCUFE() {
        org.jdom.Element cufe = new org.jdom.Element("CUFE");
        double vbase = this.vtotales.get("base") + this.vtotales.get("base_excluida");
        BigDecimal bdbase = new BigDecimal(vbase);
        bdbase = bdbase.setScale(2, RoundingMode.HALF_UP);
        double viva = this.vtotales.get("iva");
        BigDecimal bdiva = new BigDecimal(viva);
        bdiva = bdiva.setScale(2, RoundingMode.HALF_UP);
        double vtotal = this.vtotales.get("totalsinret");
        BigDecimal bdtotal = new BigDecimal(vtotal);
        bdtotal = bdtotal.setScale(2, RoundingMode.HALF_UP);
        String numero = null;
        numero = this.prefijoFA != null ? this.prefijoFA + this.consecutive : this.consecutive;
        System.out.println("numero de factura desde qrCufe: " + numero);
        cufe.addContent((Content)new org.jdom.Element("numfac").setText(numero));
        cufe.addContent((Content)new org.jdom.Element("fecfac").setText(this.fecfac));
        cufe.addContent((Content)new org.jdom.Element("horfac").setText(this.gTimeFormatted));
        cufe.addContent((Content)new org.jdom.Element("nitfac").setText(LinkingCache.getNit(this.bd)));
        cufe.addContent((Content)new org.jdom.Element("docadq").setText(this.cliente.get("nit")));
        cufe.addContent((Content)new org.jdom.Element("valfac").setText(bdbase.toString()));
        cufe.addContent((Content)new org.jdom.Element("valiva").setText(bdiva.toString()));
        cufe.addContent((Content)new org.jdom.Element("valotroim").setText("0.00"));
        cufe.addContent((Content)new org.jdom.Element("valfacim").setText(bdtotal.toString()));
        cufe.addContent((Content)new org.jdom.Element("cufe").setText("CUFE: " + this.CUFE));
        if (this.id_tipo_ambiente == 2) {
            cufe.addContent((Content)new org.jdom.Element("qr").setText("URL=https://catalogo-vpfe-hab.dian.gov.co/document/searchqr?documentkey=" + this.CUFE));
        } else {
            cufe.addContent((Content)new org.jdom.Element("qr").setText("URL=https://catalogo-vpfe.dian.gov.co/document/searchqr?documentkey=" + this.CUFE));
        }
        return cufe;
    }

    class TaxTotal {
        double base;
        double iva;

        public TaxTotal(double base, double iva) {
            this.base = base;
            this.iva = iva;
        }

        public double getBase() {
            return this.base;
        }

        public double getIva() {
            return this.iva;
        }
    }
}

