/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import common.misc.settings.ServerConfigFileHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import server.businessrules.electronicdocuments.SendDianException;
import server.database.sql.LinkingCache;

public class SoapClientFE {
    private String alias;
    private String bd;
    private SOAPMessage msg;
    private final int SEND_ELECTRONIC_DOCUMENT = 1;
    private final int SEND_GETSTATUSZIP = 2;
    private final int SEND_RESOLUTION = 3;
    private final int SEND_NOMINA = 4;
    private final String PREFERRED_PREFIX = "soap";
    private final String SOAP_ENV_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";
    private final String DIAN_PREFIX = "wcf";
    private String DIAN_NAMESPACE = null;
    private final String WSA_PREFIX = "wsa";
    private final String WSA_NAMESAPCE = "http://www.w3.org/2005/08/addressing";
    private final String WSSE_PREFIX = "wsse";
    private final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private final String WSU_PREFIX = "wsu";
    private final String WSU_NAMESAPCE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private final String DS_PREFIX = "ds";
    private final String DS_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private final String WCF_PREFIX = "wcf";
    private String WCF_NAMESPACE = null;
    private String trackIdValue;
    private String accountCode;
    private String softwareCode;
    private int id_tipo_ambiente;
    private static final int AMBIENTE_PRODUCCION = 1;
    private static final int AMBIENTE_PRUEBAS = 2;

    public SoapClientFE(String bd, String url_ambiente, String alias, String file, String base64, int id_tipo_ambiente) throws SendDianException {
        this.bd = bd;
        this.alias = alias;
        this.id_tipo_ambiente = id_tipo_ambiente;
        try {
            URL url_namespace = null;
            String get_url = null;
            get_url = id_tipo_ambiente == 1 ? LinkingCache.getSoapAction(bd) : LinkingCache.getSoapActionTest(bd);
            if (get_url != null) {
                url_namespace = new URL(get_url);
            } else {
                String url = LinkingCache.getURLAmbiente(bd);
                LinkingCache.loadSoapInfo(bd, url);
                get_url = id_tipo_ambiente == 1 ? LinkingCache.getSoapAction(bd) : LinkingCache.getSoapActionTest(bd);
                if (get_url != null) {
                    url_namespace = new URL(get_url);
                } else {
                    throw new SendDianException();
                }
            }
            this.WCF_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
            this.DIAN_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_2.SOAPMessageFactory1_2Impl");
        System.setProperty("javax.xml.bind.JAXBContext", "com.sun.xml.internal.bind.v2.ContextFactory");
        try {
            this.msg = this.createSOAPEnvelope(file, base64, 1);
            this.msg = this.signSOAPMessage(this.msg, 1);
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SoapClientFE(String bd, String url_ambiente, String alias, String file, String base64, int id_tipo_ambiente, int type_send) throws SendDianException {
        this.bd = bd;
        this.alias = alias;
        this.id_tipo_ambiente = id_tipo_ambiente;
        try {
            URL url_namespace = null;
            String get_url = null;
            get_url = id_tipo_ambiente == 1 ? LinkingCache.getSoapAction(bd) : LinkingCache.getSoapActionTest(bd);
            if (get_url != null) {
                url_namespace = new URL(get_url);
            } else {
                String url = LinkingCache.getURLAmbiente(bd);
                LinkingCache.loadSoapInfo(bd, url);
                get_url = id_tipo_ambiente == 1 ? LinkingCache.getSoapAction(bd) : LinkingCache.getSoapActionTest(bd);
                if (get_url != null) {
                    url_namespace = new URL(get_url);
                } else {
                    throw new SendDianException();
                }
            }
            this.WCF_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
            this.DIAN_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_2.SOAPMessageFactory1_2Impl");
        System.setProperty("javax.xml.bind.JAXBContext", "com.sun.xml.internal.bind.v2.ContextFactory");
        try {
            this.msg = this.createSOAPEnvelope(file, base64, 4);
            this.msg = this.signSOAPMessage(this.msg, 4);
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SoapClientFE(String bd, String url_ambiente, String alias, int id_tipo_ambiente, String trackIdValue) {
        this.bd = bd;
        this.alias = alias;
        this.id_tipo_ambiente = id_tipo_ambiente;
        this.trackIdValue = trackIdValue;
        try {
            URL url_namespace = null;
            url_namespace = id_tipo_ambiente == 1 ? new URL(LinkingCache.getSoapAction(bd)) : new URL(LinkingCache.getSoapActionTest(bd));
            this.WCF_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
            this.DIAN_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_2.SOAPMessageFactory1_2Impl");
        System.setProperty("javax.xml.bind.JAXBContext", "com.sun.xml.internal.bind.v2.ContextFactory");
        try {
            this.msg = this.createSOAPEnvelope(null, null, 2);
            this.msg = this.signSOAPMessage(this.msg, 2);
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SoapClientFE(String bd, String url_ambiente, String alias, int id_tipo_ambiente, String accountCode, String softwareCode) {
        this.bd = bd;
        this.alias = alias;
        this.id_tipo_ambiente = id_tipo_ambiente;
        this.accountCode = accountCode;
        this.softwareCode = softwareCode;
        try {
            URL url_namespace = null;
            url_namespace = id_tipo_ambiente == 1 ? new URL(LinkingCache.getSoapAction(bd)) : new URL(LinkingCache.getSoapActionTest(bd));
            this.WCF_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
            this.DIAN_NAMESPACE = url_namespace.getProtocol() + "://" + url_namespace.getHost();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.internal.messaging.saaj.soap.ver1_2.SOAPMessageFactory1_2Impl");
        System.setProperty("javax.xml.bind.JAXBContext", "com.sun.xml.internal.bind.v2.ContextFactory");
        try {
            this.msg = this.createSOAPEnvelope(null, null, 3);
            this.msg = this.signSOAPMessage(this.msg, 3);
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HttpEntity getSoap() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.msg.writeTo((OutputStream)out);
            System.out.println("------");
            System.out.println(out.toString());
            System.out.println("------");
            return new ByteArrayEntity(out.toByteArray());
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private SOAPMessage createSOAPEnvelope(String file, String base64, int type_send) throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        soapEnvelope.removeNamespaceDeclaration(soapEnvelope.getPrefix());
        soapEnvelope.addNamespaceDeclaration("soap", "http://www.w3.org/2003/05/soap-envelope");
        soapEnvelope.addNamespaceDeclaration("wcf", this.DIAN_NAMESPACE);
        soapEnvelope.setPrefix("soap");
        SOAPBody soapBody = null;
        soapBody = soapMessage.getSOAPBody();
        soapBody.setPrefix("soap");
        if (type_send == 1) {
            SOAPElement sendBillSync = null;
            sendBillSync = this.id_tipo_ambiente == 1 ? soapBody.addChildElement("SendBillSync", "wcf") : soapBody.addChildElement("SendTestSetAsync", "wcf");
            SOAPElement fileName = sendBillSync.addChildElement("fileName", "wcf");
            SOAPElement contentFile = sendBillSync.addChildElement("contentFile", "wcf");
            SOAPElement testSetId = null;
            if (this.id_tipo_ambiente == 2) {
                testSetId = sendBillSync.addChildElement("testSetId", "wcf");
                testSetId.setValue(LinkingCache.getTestSedId(this.bd));
            }
            fileName.setValue(file);
            contentFile.setValue(base64);
        } else if (type_send == 2) {
            SOAPElement GetStatusZip = soapBody.addChildElement("GetStatusZip", "wcf");
            SOAPElement trackId = GetStatusZip.addChildElement("trackId", "wcf");
            trackId.setValue(this.trackIdValue);
        } else if (type_send == 3) {
            SOAPElement GetStatusZip = soapBody.addChildElement("GetNumberingRange", "wcf");
            SOAPElement saccountCode = GetStatusZip.addChildElement("accountCode", "wcf");
            SOAPElement saccountCodeT = GetStatusZip.addChildElement("accountCodeT", "wcf");
            SOAPElement ssoftwareCode = GetStatusZip.addChildElement("softwareCode", "wcf");
            saccountCode.setValue(this.accountCode);
            saccountCodeT.setValue(this.accountCode);
            ssoftwareCode.setValue(this.softwareCode);
        } else if (type_send == 4) {
            SOAPElement sendBillSync = null;
            SOAPElement fileName = null;
            SOAPElement contentFile = null;
            SOAPElement testSetId = null;
            if (this.id_tipo_ambiente == 2) {
                sendBillSync = soapBody.addChildElement("SendNominaSync", "wcf");
                fileName = sendBillSync.addChildElement("fileName", "wcf");
                contentFile = sendBillSync.addChildElement("contentFile", "wcf");
                testSetId = sendBillSync.addChildElement("testSetId", "wcf");
                testSetId.setValue(LinkingCache.getTestSedId(this.bd));
            } else {
                sendBillSync = soapBody.addChildElement("SendNominaSync", "wcf");
                fileName = sendBillSync.addChildElement("fileName", "wcf");
                contentFile = sendBillSync.addChildElement("contentFile", "wcf");
            }
            fileName.setValue(file);
            contentFile.setValue(base64);
        }
        return soapMessage;
    }

    private SOAPMessage signSOAPMessage(SOAPMessage soapMessage, int type_send) throws Exception {
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        soapHeader.setPrefix("soap");
        soapHeader.addNamespaceDeclaration("wsa", "http://www.w3.org/2005/08/addressing");
        SOAPElement securityElement = soapHeader.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        securityElement.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        Certificate cert = this.getCertificate();
        SOAPElement timestamp = this.addTimestamp(securityElement, soapMessage);
        this.addBinarySecurityToken(securityElement, cert);
        SOAPElement to = this.addTo((SOAPElement)soapHeader, soapMessage);
        this.addSignature(securityElement, soapMessage.getSOAPBody(), to);
        if (type_send == 1) {
            this.addAction((SOAPElement)soapHeader);
        } else if (type_send == 2) {
            this.addActionGetStatusZip((SOAPElement)soapHeader);
        } else if (type_send == 3) {
            this.addActionSendResolution((SOAPElement)soapHeader);
        } else if (type_send == 4) {
            this.addActionNomina((SOAPElement)soapHeader);
        }
        return soapMessage;
    }

    private Certificate getCertificate() throws Exception {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(new File(ServerConfigFileHandler.getCertfile((String)this.bd))), ServerConfigFileHandler.getCertpassword((String)this.bd).toCharArray());
        Certificate cert = keystore.getCertificate(this.alias);
        return cert;
    }

    private SOAPElement addTimestamp(SOAPElement securityElement, SOAPMessage soapMessage) throws SOAPException {
        SOAPElement timestamp = securityElement.addChildElement("Timestamp", "wsu");
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        timestamp.addAttribute(soapEnvelope.createName("Id", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"), "TS");
        String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
        DateTimeFormatter timeStampFormatter = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
        timestamp.addChildElement("Created", "wsu").setValue(timeStampFormatter.format(ZonedDateTime.now().toInstant().atZone(ZoneId.of("UTC"))));
        timestamp.addChildElement("Expires", "wsu").setValue(timeStampFormatter.format(ZonedDateTime.now().plusSeconds(6000L).toInstant().atZone(ZoneId.of("UTC"))));
        return timestamp;
    }

    private void addAction(SOAPElement soapHeader) throws SOAPException {
        SOAPElement action = soapHeader.addChildElement("Action", "wsa");
        if (this.id_tipo_ambiente == 1) {
            action.setValue(LinkingCache.getSoapAction(this.bd));
        } else {
            action.setValue(LinkingCache.getSoapActionTest(this.bd));
        }
    }

    private void addActionNomina(SOAPElement soapHeader) throws SOAPException {
        SOAPElement action = soapHeader.addChildElement("Action", "wsa");
        if (this.id_tipo_ambiente == 1) {
            action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/SendNominaSync");
        } else {
            action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/SendNominaSync");
        }
    }

    private void addActionGetStatusZip(SOAPElement soapHeader) throws SOAPException {
        SOAPElement action = soapHeader.addChildElement("Action", "wsa");
        if (this.id_tipo_ambiente == 1) {
            action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/GetStatusZip");
        } else {
            action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/GetStatusZip");
        }
    }

    private void addActionSendResolution(SOAPElement soapHeader) throws SOAPException {
        SOAPElement action = soapHeader.addChildElement("Action", "wsa");
        if (this.id_tipo_ambiente == 1) {
            action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/GetNumberingRange");
        } else {
            action.setValue("http://wcf.dian.colombia/IWcfDianCustomerServices/GetNumberingRange");
        }
    }

    private SOAPElement addTo(SOAPElement soapHeader, SOAPMessage soapMessage) throws SOAPException {
        SOAPElement to = soapHeader.addChildElement("To", "wsa");
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        to.addAttribute(soapEnvelope.createName("Id", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"), "id");
        to.setValue(LinkingCache.getUrlAddress(this.bd));
        return to;
    }

    private SOAPElement addBinarySecurityToken(SOAPElement securityElement, Certificate cert) throws Exception {
        byte[] certByte = cert.getEncoded();
        SOAPElement binarySecurityToken = securityElement.addChildElement("BinarySecurityToken", "wsse");
        binarySecurityToken.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        binarySecurityToken.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        binarySecurityToken.setAttribute("wsu:Id", "X509");
        binarySecurityToken.addTextNode(Base64.getEncoder().encodeToString(certByte));
        return securityElement;
    }

    private SOAPElement addSignature(SOAPElement securityElement, SOAPBody soapBody, SOAPElement to) throws Exception {
        PrivateKey key = this.getKeyFormCert();
        SOAPElement securityTokenReference = this.addSecurityToken(securityElement);
        this.createDetachedSignature(securityElement, key, securityTokenReference, soapBody, to);
        return securityElement;
    }

    private PrivateKey getKeyFormCert() throws Exception {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(new FileInputStream(new File(ServerConfigFileHandler.getCertfile((String)this.bd))), ServerConfigFileHandler.getCertpassword((String)this.bd).toCharArray());
        PrivateKey key = (PrivateKey)keystore.getKey(this.alias, ServerConfigFileHandler.getCertpassword((String)this.bd).toCharArray());
        return key;
    }

    private SOAPElement addSecurityToken(SOAPElement signature) throws SOAPException {
        SOAPElement securityTokenReference = signature.addChildElement("SecurityTokenReference", "wsse");
        securityTokenReference.setAttribute("wsu:Id", "STR");
        SOAPElement reference = securityTokenReference.addChildElement("Reference", "wsse");
        reference.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        reference.setAttribute("URI", "#X509");
        return securityTokenReference;
    }

    private void createDetachedSignature(SOAPElement signatureElement, PrivateKey privateKey, SOAPElement securityTokenReference, SOAPBody soapBody, SOAPElement to) throws Exception {
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        ArrayList<String> transformListNamespaces = new ArrayList<String>();
        transformListNamespaces.add("soap wcf");
        ExcC14NParameterSpec inclusiveTransforms = new ExcC14NParameterSpec(transformListNamespaces);
        Transform envTransform = xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", inclusiveTransforms);
        transformList.add(envTransform);
        ArrayList<Reference> refList = new ArrayList<Reference>();
        Reference refTS = xmlSignatureFactory.newReference("#id", digestMethod, transformList, null, null);
        refList.add(refTS);
        ArrayList<String> prefixList = new ArrayList<String>();
        prefixList.add("wsa soap wcf");
        ExcC14NParameterSpec inclusiveNamespace = new ExcC14NParameterSpec(prefixList);
        CanonicalizationMethod cm = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", inclusiveNamespace);
        SignatureMethod sm = xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(cm, sm, refList);
        DOMSignContext signContext = new DOMSignContext(privateKey, (Node)signatureElement);
        signContext.setDefaultNamespacePrefix("ds");
        signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        signContext.setIdAttributeNS((Element)to, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        KeyInfoFactory keyFactory = KeyInfoFactory.getInstance();
        DOMStructure domKeyInfo = new DOMStructure((Node)securityTokenReference);
        KeyInfo keyInfo = keyFactory.newKeyInfo(Collections.singletonList(domKeyInfo), "KI");
        XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, null, "SIG", null);
        signContext.setBaseURI("");
        signature.sign(signContext);
    }
}

