/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments.nomina;

import dian.gov.co.facturaelectronica.nominaindividual.NominaIndividualType;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import server.database.sql.QueryRunner;

public class Deducciones
extends NominaIndividualType.Deducciones {
    private String ndocumento;
    private String nitcc;
    private QueryRunner query;
    private Connection conn;
    private double deducidoTotal;

    public Deducciones(String bd, Connection conn, String ndocumento, String nitcc) {
        this.ndocumento = ndocumento;
        this.nitcc = nitcc;
        this.conn = conn;
        this.query = new QueryRunner(bd);
    }

    public Deducciones getDeducciones() throws SQLException, ParseException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0003", new String[]{this.ndocumento, this.nitcc});
        rsdata.next();
        String pensionVoluntaria = rsdata.getString("pension_voluntaria");
        String retencionFuente = rsdata.getString("retencion_fuente");
        String afc = rsdata.getString("afc");
        String cooperativa = rsdata.getString("cooperativa");
        String embargoFiscal = rsdata.getString("embargo_fiscal");
        String planComplementarios = rsdata.getString("plan_Complementarios");
        String educacion = rsdata.getString("educacion");
        String reintegro = rsdata.getString("reintegro");
        String deuda = rsdata.getString("deuda");
        this.setSalud(this.getSalud(this.ndocumento, this.nitcc));
        this.setFondoPension(this.getFondoPension(this.ndocumento, this.nitcc));
        this.setSanciones(this.getSanciones(this.ndocumento, this.nitcc));
        this.setLibranzas(this.getLibranzas(this.ndocumento, this.nitcc));
        this.setPagosTerceros(this.getPagosTerceros(this.ndocumento, this.nitcc));
        this.setAnticipos(this.getAnticipos(this.ndocumento, this.nitcc));
        this.setOtrasDeducciones(this.getOtrasDeducciones(this.ndocumento, this.nitcc));
        if (pensionVoluntaria != null) {
            this.setPensionVoluntaria(new BigDecimal(pensionVoluntaria));
        }
        if (retencionFuente != null) {
            this.setRetencionFuente(new BigDecimal(retencionFuente));
        }
        if (afc != null) {
            this.setAFC(new BigDecimal(afc));
        }
        if (cooperativa != null) {
            this.setCooperativa(new BigDecimal(cooperativa));
        }
        if (embargoFiscal != null) {
            this.setEmbargoFiscal(new BigDecimal(embargoFiscal));
        }
        if (planComplementarios != null) {
            this.setPlanComplementarios(new BigDecimal(planComplementarios));
        }
        if (educacion != null) {
            this.setEducacion(new BigDecimal(educacion));
        }
        if (reintegro != null) {
            this.setReintegro(new BigDecimal(reintegro));
        }
        if (deuda != null) {
            this.setDeuda(new BigDecimal(deuda));
        }
        return this;
    }

    public NominaIndividualType.Deducciones.Salud getSalud(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Deducciones.Salud salud = new NominaIndividualType.Deducciones.Salud();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0025", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String porcentaje = rsdata.getString("porcentaje");
            String deduccion = rsdata.getString("deduccion");
            salud.setPorcentaje(new BigDecimal(porcentaje));
            salud.setDeduccion(new BigDecimal(deduccion));
            this.sumDeducido(deduccion);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return salud;
        }
        return null;
    }

    public NominaIndividualType.Deducciones.FondoPension getFondoPension(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Deducciones.FondoPension fondoPension = new NominaIndividualType.Deducciones.FondoPension();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0026", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String porcentaje = rsdata.getString("porcentaje");
            String deduccion = rsdata.getString("deduccion");
            fondoPension.setPorcentaje(new BigDecimal(porcentaje));
            fondoPension.setDeduccion(new BigDecimal(deduccion));
            this.sumDeducido(deduccion);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return fondoPension;
        }
        return null;
    }

    public NominaIndividualType.Deducciones.FondoSP getFondoSP(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Deducciones.FondoSP fondoSP = new NominaIndividualType.Deducciones.FondoSP();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0027", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String porcentaje = rsdata.getString("porcentaje");
            String deduccionSP = rsdata.getString("deduccion_sp");
            String porcentajeSub = rsdata.getString("porcentaje_sub");
            String deduccionSub = rsdata.getString("deduccion_sub");
            fondoSP.setPorcentaje(new BigDecimal(porcentaje));
            fondoSP.setDeduccion(new BigDecimal(deduccionSP));
            this.sumDeducido(deduccionSP);
            fondoSP.setPorcentajeSub(new BigDecimal(porcentajeSub));
            fondoSP.setDeduccionSub(new BigDecimal(deduccionSub));
            this.sumDeducido(deduccionSub);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return fondoSP;
        }
        return null;
    }

    public NominaIndividualType.Deducciones.Sanciones getSanciones(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Deducciones.Sanciones sanciones = new NominaIndividualType.Deducciones.Sanciones();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0028", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String sancionPublic = rsdata.getString("sancion_public");
            String sancionPriv = rsdata.getString("sancion_priv");
            NominaIndividualType.Deducciones.Sanciones.Sancion sancion = new NominaIndividualType.Deducciones.Sanciones.Sancion();
            sancion.setSancionPublic(new BigDecimal(sancionPublic));
            this.sumDeducido(sancionPublic);
            sancion.setSancionPriv(new BigDecimal(sancionPriv));
            this.sumDeducido(sancionPriv);
            sanciones.getSancion().add(sancion);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return sanciones;
        }
        return null;
    }

    public NominaIndividualType.Deducciones.Libranzas getLibranzas(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Deducciones.Libranzas libranzas = new NominaIndividualType.Deducciones.Libranzas();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0029", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String descripcion = rsdata.getString("descpipcion");
            String deduccion = rsdata.getString("deduccion");
            NominaIndividualType.Deducciones.Libranzas.Libranza libranza = new NominaIndividualType.Deducciones.Libranzas.Libranza();
            libranza.setDescripcion(descripcion);
            libranza.setDeduccion(new BigDecimal(deduccion));
            this.sumDeducido(deduccion);
            libranzas.getLibranza().add(libranza);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return libranzas;
        }
        return null;
    }

    private NominaIndividualType.Deducciones.PagosTerceros getPagosTerceros(String ndocumento, String nitcc) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0030", new String[]{ndocumento, nitcc});
        NominaIndividualType.Deducciones.PagosTerceros pagosTerceros = new NominaIndividualType.Deducciones.PagosTerceros();
        boolean empty = true;
        if (rsdata.next()) {
            String pagosterceros = rsdata.getString("pagos_terceros");
            pagosTerceros.getPagoTercero().add(new BigDecimal(pagosterceros));
            this.sumDeducido(pagosterceros);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return pagosTerceros;
        }
        return null;
    }

    private NominaIndividualType.Deducciones.Anticipos getAnticipos(String ndocumento, String nitcc) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0031", new String[]{ndocumento, nitcc});
        boolean empty = true;
        NominaIndividualType.Deducciones.Anticipos anticipos = new NominaIndividualType.Deducciones.Anticipos();
        if (rsdata.next()) {
            String anticipo = rsdata.getString("anticipo");
            anticipos.getAnticipo().add(new BigDecimal(anticipo));
            this.sumDeducido(anticipo);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return anticipos;
        }
        return null;
    }

    private NominaIndividualType.Deducciones.OtrasDeducciones getOtrasDeducciones(String ndocumento, String nitcc) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0032", new String[]{ndocumento, nitcc});
        boolean empty = true;
        NominaIndividualType.Deducciones.OtrasDeducciones otrasDeducciones = new NominaIndividualType.Deducciones.OtrasDeducciones();
        if (rsdata.next()) {
            String otraDeduccion = rsdata.getString("otra_deduccion");
            otrasDeducciones.getOtraDeduccion().add(new BigDecimal(otraDeduccion));
            this.sumDeducido(otraDeduccion);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return otrasDeducciones;
        }
        return null;
    }

    public BigDecimal getTotales() {
        return new BigDecimal(this.deducidoTotal);
    }

    private void sumDeducido(String value) {
        BigDecimal valorPago = new BigDecimal(value);
        this.deducidoTotal += valorPago.doubleValue();
    }
}

