/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments.nomina;

import dian.gov.co.facturaelectronica.nominaindividual.NominaIndividualType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import server.database.sql.QueryRunner;

public class Devengados
extends NominaIndividualType.Devengados {
    private String ndocumento;
    private String nitcc;
    private QueryRunner query;
    private Connection conn;
    private double devengadoTotal;

    public Devengados(String bd, Connection conn, String ndocumento, String nitcc) {
        this.ndocumento = ndocumento;
        this.nitcc = nitcc;
        this.query = new QueryRunner(bd);
        this.conn = conn;
        this.devengadoTotal = 0.0;
    }

    public Devengados getDevengados() throws SQLException, ParseException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0034", new String[]{this.ndocumento, this.nitcc});
        if (rsdata.next()) {
            String diasTrabajados = rsdata.getString("dias_trabajados");
            String salarioBase = rsdata.getString("salario_base");
            String auxilioTransporte = rsdata.getString("auxilio_transporte");
            String diasPrima = rsdata.getString("dias_prima");
            String valorPrima = rsdata.getString("valor_prima");
            String valorPrimaNS = rsdata.getString("valor_primaNS");
            String pagoCesantias = rsdata.getString("pago_cesantias");
            String porcentajeCesantias = rsdata.getString("porcentaje_cesantias");
            String interesesCesantias = rsdata.getString("intereses_cesantias");
            String dotacion = rsdata.getString("dotacion");
            String apoyoSost = rsdata.getString("apoyo_sost");
            String teletrabajo = rsdata.getString("teletrabajo");
            String bonifRetiro = rsdata.getString("bonif_retiro");
            String indemnizacion = rsdata.getString("indemnizacion");
            String reintegro = rsdata.getString("reintegro");
            System.out.println("ndocumento: " + this.ndocumento + " nitcc: " + this.nitcc + " dias: " + diasTrabajados + " salarioBase " + salarioBase);
            this.setBasico(this.getBasico(diasTrabajados, salarioBase));
            this.getTransporte().add(this.getTransporte(auxilioTransporte));
            this.setHEDs(this.getHEDs(this.ndocumento, this.nitcc));
            this.setHENs(this.getHENs(this.ndocumento, this.nitcc));
            this.setHRNs(this.getHRNs(this.ndocumento, this.nitcc));
            this.setHEDDFs(this.getHEDDFs(this.ndocumento, this.nitcc));
            this.setHRDDFs(this.getHRDDFs(this.ndocumento, this.nitcc));
            this.setHENDFs(this.getHENDFs(this.ndocumento, this.nitcc));
            this.setHRNDFs(this.getHRNDFs(this.ndocumento, this.nitcc));
            this.setVacaciones(this.getVacaciones(this.ndocumento, this.nitcc));
            this.setPrimas(this.getPrimas(diasPrima, valorPrima, valorPrimaNS));
            this.setCesantias(this.getCesantias(pagoCesantias, porcentajeCesantias, interesesCesantias));
            this.setIncapacidades(this.getIncapacidades(this.ndocumento, this.nitcc));
            this.setLicencias(this.getAllLicencias(this.ndocumento, this.nitcc));
            this.setBonificaciones(this.getBonificaciones(this.ndocumento, this.nitcc));
            this.setAuxilios(this.getAuxilios(this.ndocumento, this.nitcc));
            this.setOtrosConceptos(this.getOtrosConceptos(this.ndocumento, this.nitcc));
            this.setBonoEPCTVs(this.getBonoEPCTVs(this.ndocumento, this.nitcc));
            this.setComisiones(this.getComisiones(this.ndocumento, this.nitcc));
            this.setPagosTerceros(this.getPagosTerceros(this.ndocumento, this.nitcc));
            this.setAnticipos(this.getAnticipos(this.ndocumento, this.nitcc));
            if (dotacion != null) {
                this.setDotacion(new BigDecimal(dotacion));
            }
            if (apoyoSost != null) {
                this.setApoyoSost(new BigDecimal(apoyoSost));
            }
            if (teletrabajo != null) {
                this.setTeletrabajo(new BigDecimal(teletrabajo));
            }
            if (bonifRetiro != null) {
                this.setBonifRetiro(new BigDecimal(bonifRetiro));
            }
            if (indemnizacion != null) {
                this.setIndemnizacion(new BigDecimal(indemnizacion));
            }
            if (reintegro != null) {
                this.setReintegro(new BigDecimal(reintegro));
            }
            return this;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Basico getBasico(String diasTrabajados, String salarioBase) {
        NominaIndividualType.Devengados.Basico basico = new NominaIndividualType.Devengados.Basico();
        basico.setDiasTrabajados(new BigInteger(diasTrabajados));
        BigDecimal valorBasico = new BigDecimal(salarioBase);
        basico.setSueldoTrabajado(valorBasico);
        this.sumDevengado(salarioBase);
        return basico;
    }

    public NominaIndividualType.Devengados.Transporte getTransporte(String valor) {
        NominaIndividualType.Devengados.Transporte transporte = new NominaIndividualType.Devengados.Transporte();
        BigDecimal valorTransporte = new BigDecimal(valor);
        transporte.setAuxilioTransporte(valorTransporte);
        this.sumDevengado(valor);
        return transporte;
    }

    public NominaIndividualType.Devengados.HEDs getHEDs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HEDs heds = new NominaIndividualType.Devengados.HEDs();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0004", new String[]{ndocumento, nitcc});
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HEDs.HED hed = new NominaIndividualType.Devengados.HEDs.HED();
            hed.setCantidad(new BigDecimal(cantidad));
            hed.setPorcentaje(new BigDecimal(porcentaje));
            BigDecimal valorHED = new BigDecimal(pago);
            hed.setPago(valorHED);
            this.sumDevengado(pago);
            heds.getHED().add(hed);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return heds;
        }
        return null;
    }

    public NominaIndividualType.Devengados.HENs getHENs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HENs hens = new NominaIndividualType.Devengados.HENs();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0005", new String[]{ndocumento, nitcc});
        boolean empty = true;
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HENs.HEN hen = new NominaIndividualType.Devengados.HENs.HEN();
            hen.setCantidad(new BigDecimal(cantidad));
            hen.setPorcentaje(new BigDecimal(porcentaje));
            BigDecimal valorHEN = new BigDecimal(pago);
            hen.setPago(valorHEN);
            this.sumDevengado(pago);
            hens.getHEN().add(hen);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return hens;
        }
        return null;
    }

    public NominaIndividualType.Devengados.HRNs getHRNs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HRNs hrns = new NominaIndividualType.Devengados.HRNs();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0006", new String[]{ndocumento, nitcc});
        boolean empty = true;
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HRNs.HRN hrn = new NominaIndividualType.Devengados.HRNs.HRN();
            hrn.setCantidad(new BigDecimal(cantidad));
            hrn.setPorcentaje(new BigDecimal(porcentaje));
            hrn.setPago(new BigDecimal(pago));
            BigDecimal valorHRN = new BigDecimal(pago);
            hrn.setPago(valorHRN);
            this.sumDevengado(pago);
            hrns.getHRN().add(hrn);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return hrns;
        }
        return null;
    }

    public NominaIndividualType.Devengados.HEDDFs getHEDDFs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HEDDFs heddfs = new NominaIndividualType.Devengados.HEDDFs();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0007", new String[]{ndocumento, nitcc});
        boolean empty = true;
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HEDDFs.HEDDF heddf = new NominaIndividualType.Devengados.HEDDFs.HEDDF();
            heddf.setCantidad(new BigDecimal(cantidad));
            heddf.setPorcentaje(new BigDecimal(porcentaje));
            BigDecimal valorHEDDF = new BigDecimal(pago);
            heddf.setPago(valorHEDDF);
            this.sumDevengado(pago);
            heddfs.getHEDDF().add(heddf);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return heddfs;
        }
        return null;
    }

    public NominaIndividualType.Devengados.HRDDFs getHRDDFs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HRDDFs hrddfs = new NominaIndividualType.Devengados.HRDDFs();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0008", new String[]{ndocumento, nitcc});
        boolean empty = true;
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HRDDFs.HRDDF hrddf = new NominaIndividualType.Devengados.HRDDFs.HRDDF();
            hrddf.setCantidad(new BigDecimal(cantidad));
            hrddf.setPorcentaje(new BigDecimal(porcentaje));
            BigDecimal valorHRDDF = new BigDecimal(pago);
            hrddf.setPago(valorHRDDF);
            this.sumDevengado(pago);
            hrddfs.getHRDDF().add(hrddf);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return hrddfs;
        }
        return null;
    }

    public NominaIndividualType.Devengados.HENDFs getHENDFs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HENDFs hendfs = new NominaIndividualType.Devengados.HENDFs();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0009", new String[]{ndocumento, nitcc});
        boolean empty = true;
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HENDFs.HENDF hendf = new NominaIndividualType.Devengados.HENDFs.HENDF();
            System.out.println("seteando hora inicial");
            hendf.setCantidad(new BigDecimal(cantidad));
            hendf.setPorcentaje(new BigDecimal(porcentaje));
            hendf.setPago(new BigDecimal(pago));
            BigDecimal valorHENDF = new BigDecimal(pago);
            hendf.setPago(valorHENDF);
            this.sumDevengado(pago);
            hendfs.getHENDF().add(hendf);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return hendfs;
        }
        return null;
    }

    public NominaIndividualType.Devengados.HRNDFs getHRNDFs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.HRNDFs hrndfs = new NominaIndividualType.Devengados.HRNDFs();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0010", new String[]{ndocumento, nitcc});
        boolean empty = true;
        while (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String porcentaje = rsdata.getString("porcentaje");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.HRNDFs.HRNDF hrndf = new NominaIndividualType.Devengados.HRNDFs.HRNDF();
            hrndf.setCantidad(new BigDecimal(cantidad));
            hrndf.setPorcentaje(new BigDecimal(porcentaje));
            BigDecimal valorHRNDF = new BigDecimal(pago);
            hrndf.setPago(valorHRNDF);
            this.sumDevengado(pago);
            hrndfs.getHRNDF().add(hrndf);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return hrndfs;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Vacaciones getVacaciones(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.Vacaciones vacaciones = new NominaIndividualType.Devengados.Vacaciones();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0011", new String[]{ndocumento, nitcc});
        boolean empty = true;
        if (rsdata.next()) {
            String fechaInicio = rsdata.getString("fecha_inicio");
            String fechaFin = rsdata.getString("fecha_fin");
            String cantidad = rsdata.getString("cantidad");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.Vacaciones.VacacionesComunes vacacionesComunes = new NominaIndividualType.Devengados.Vacaciones.VacacionesComunes();
            vacacionesComunes.setFechaInicio(this.getXMLDate(fechaInicio));
            vacacionesComunes.setFechaFin(this.getXMLDate(fechaFin));
            vacacionesComunes.setCantidad(new BigInteger(cantidad));
            vacaciones.getVacacionesComunes().add(vacacionesComunes);
            BigDecimal valorVacaciones = new BigDecimal(pago);
            vacacionesComunes.setPago(valorVacaciones);
            this.sumDevengado(pago);
            empty = false;
        }
        rsdata.close();
        rsdata = this.query.getQuery(this.conn, "SCSNM0012", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String cantidad = rsdata.getString("cantidad");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.Vacaciones.VacacionesCompensadas vacacionesCompensadas = new NominaIndividualType.Devengados.Vacaciones.VacacionesCompensadas();
            vacacionesCompensadas.setCantidad(new BigInteger(cantidad));
            BigDecimal valorVacaciones = new BigDecimal(pago);
            vacacionesCompensadas.setPago(valorVacaciones);
            this.sumDevengado(pago);
            vacaciones.getVacacionesCompensadas().add(vacacionesCompensadas);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return vacaciones;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Incapacidades getIncapacidades(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.Incapacidades incapacidades = new NominaIndividualType.Devengados.Incapacidades();
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0013", new String[]{ndocumento, nitcc});
        boolean empty = true;
        if (rsdata.next()) {
            String fechaInicio = rsdata.getString("fecha_inicio");
            String fechaFin = rsdata.getString("fecha_fin");
            String cantidad = rsdata.getString("cantidad");
            String tipo = rsdata.getString("tipo");
            String pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.Incapacidades.Incapacidad incapacidad = new NominaIndividualType.Devengados.Incapacidades.Incapacidad();
            incapacidad.setFechaInicio(this.getXMLDate(fechaInicio));
            incapacidad.setFechaFin(this.getXMLDate(fechaFin));
            incapacidad.setCantidad(new BigInteger(cantidad));
            incapacidad.setTipo(new BigInteger(tipo));
            BigDecimal valorIncapacidad = new BigDecimal(pago);
            incapacidad.setPago(valorIncapacidad);
            this.sumDevengado(pago);
            incapacidades.getIncapacidad().add(incapacidad);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return incapacidades;
        }
        return null;
    }

    private NominaIndividualType.Devengados.Primas getPrimas(String diasPrima, String pagoPrima, String pagoPrimaNS) {
        NominaIndividualType.Devengados.Primas primas = new NominaIndividualType.Devengados.Primas();
        if (diasPrima != null && pagoPrima != null) {
            primas.setCantidad(new BigInteger(diasPrima));
            BigDecimal valorPago = new BigDecimal(pagoPrima);
            primas.setPago(valorPago);
            this.sumDevengado(pagoPrima);
        }
        if (pagoPrimaNS != null) {
            primas.setPagoNS(new BigDecimal(pagoPrimaNS));
        }
        if (diasPrima != null || pagoPrimaNS != null) {
            return primas;
        }
        return null;
    }

    private NominaIndividualType.Devengados.Cesantias getCesantias(String pagoCesantias, String porcentajeCesantias, String interesesCesantias) {
        NominaIndividualType.Devengados.Cesantias cesantias = new NominaIndividualType.Devengados.Cesantias();
        if (pagoCesantias != null && porcentajeCesantias != null) {
            BigInteger valorPago = new BigInteger(pagoCesantias);
            cesantias.setPago(valorPago);
            this.sumDevengado(pagoCesantias);
            cesantias.setPorcentaje(new BigDecimal(porcentajeCesantias));
        }
        if (interesesCesantias != null) {
            cesantias.setPagoIntereses(new BigDecimal(interesesCesantias));
        }
        if (pagoCesantias != null || interesesCesantias != null) {
            return cesantias;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Licencias getAllLicencias(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        BigDecimal valorPago;
        String pago;
        String cantidad;
        String fechaFin;
        String fechaInicio;
        NominaIndividualType.Devengados.Licencias licencias = new NominaIndividualType.Devengados.Licencias();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0014", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            fechaInicio = rsdata.getString("fecha_inicio");
            fechaFin = rsdata.getString("fecha_fin");
            cantidad = rsdata.getString("cantidad");
            pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.Licencias.LicenciaMP licenciaMP = new NominaIndividualType.Devengados.Licencias.LicenciaMP();
            licenciaMP.setFechaInicio(this.getXMLDate(fechaInicio));
            licenciaMP.setFechaFin(this.getXMLDate(fechaFin));
            licenciaMP.setCantidad(new BigInteger(cantidad));
            valorPago = new BigDecimal(pago);
            licenciaMP.setPago(valorPago);
            this.sumDevengado(pago);
            licencias.getLicenciaMP().add(licenciaMP);
            empty = false;
        }
        rsdata.close();
        rsdata = this.query.getQuery(this.conn, "SCSNM0015", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            fechaInicio = rsdata.getString("fecha_inicio");
            fechaFin = rsdata.getString("fecha_fin");
            cantidad = rsdata.getString("cantidad");
            pago = rsdata.getString("pago");
            NominaIndividualType.Devengados.Licencias.LicenciaR licenciaR = new NominaIndividualType.Devengados.Licencias.LicenciaR();
            licenciaR.setFechaInicio(this.getXMLDate(fechaInicio));
            licenciaR.setFechaFin(this.getXMLDate(fechaFin));
            licenciaR.setCantidad(new BigInteger(cantidad));
            valorPago = new BigDecimal(pago);
            licenciaR.setPago(valorPago);
            this.sumDevengado(pago);
            licencias.getLicenciaR().add(licenciaR);
            empty = false;
        }
        rsdata.close();
        rsdata = this.query.getQuery(this.conn, "SCSNM0016", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            fechaInicio = rsdata.getString("fecha_inicio");
            fechaFin = rsdata.getString("fecha_fin");
            cantidad = rsdata.getString("cantidad");
            NominaIndividualType.Devengados.Licencias.LicenciaNR licenciaNR = new NominaIndividualType.Devengados.Licencias.LicenciaNR();
            licenciaNR.setFechaInicio(this.getXMLDate(fechaInicio));
            licenciaNR.setFechaFin(this.getXMLDate(fechaFin));
            licenciaNR.setCantidad(new BigInteger(cantidad));
            licencias.getLicenciaNR().add(licenciaNR);
            empty = false;
        }
        if (!empty) {
            return licencias;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Bonificaciones getBonificaciones(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.Bonificaciones bonificaciones = new NominaIndividualType.Devengados.Bonificaciones();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0017", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String bonificacionS = rsdata.getString("bonificacion_s");
            String bonificacionNS = rsdata.getString("bonificacion_ns");
            if (bonificacionS.equals("0") && bonificacionNS.equals("0")) {
                return null;
            }
            NominaIndividualType.Devengados.Bonificaciones.Bonificacion bonificacion = new NominaIndividualType.Devengados.Bonificaciones.Bonificacion();
            BigDecimal valorPago = new BigDecimal(bonificacionS);
            bonificacion.setBonificacionS(valorPago);
            this.sumDevengado(bonificacionS);
            valorPago = new BigDecimal(bonificacionNS);
            bonificacion.setBonificacionNS(valorPago);
            this.sumDevengado(bonificacionNS);
            bonificaciones.getBonificacion().add(bonificacion);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return bonificaciones;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Auxilios getAuxilios(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.Auxilios auxilios = new NominaIndividualType.Devengados.Auxilios();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0018", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String auxilioS = rsdata.getString("auxilio_s");
            String auxilioNS = rsdata.getString("auxilio_ns");
            if (!auxilioS.equals("0") || !auxilioNS.equals("0")) {
                NominaIndividualType.Devengados.Auxilios.Auxilio auxilio = new NominaIndividualType.Devengados.Auxilios.Auxilio();
                auxilio.setAuxilioS(new BigDecimal(auxilioS));
                this.sumDevengado(auxilioS);
                auxilio.setAuxilioNS(new BigDecimal(auxilioNS));
                this.sumDevengado(auxilioNS);
                auxilios.getAuxilio().add(auxilio);
            } else {
                empty = false;
            }
        }
        rsdata.close();
        if (!empty) {
            return auxilios;
        }
        return null;
    }

    public NominaIndividualType.Devengados.OtrosConceptos getOtrosConceptos(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.OtrosConceptos otrosConceptos = new NominaIndividualType.Devengados.OtrosConceptos();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0019", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String descripcionConcepto = rsdata.getString("descripcion_concepto");
            String conceptoS = rsdata.getString("devengadoss_s");
            String conceptoNS = rsdata.getString("devengados_ns");
            NominaIndividualType.Devengados.OtrosConceptos.OtroConcepto otroConcepto = new NominaIndividualType.Devengados.OtrosConceptos.OtroConcepto();
            otroConcepto.setDescripcionConcepto(descripcionConcepto);
            otroConcepto.setConceptoS(new BigDecimal(conceptoS));
            this.sumDevengado(conceptoS);
            otroConcepto.setConceptoNS(new BigDecimal(conceptoNS));
            this.sumDevengado(conceptoNS);
            otrosConceptos.getOtroConcepto().add(otroConcepto);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return otrosConceptos;
        }
        return null;
    }

    public NominaIndividualType.Devengados.Compensaciones getCompensaciones(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.Compensaciones compensaciones = new NominaIndividualType.Devengados.Compensaciones();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0020", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String compensacionO = rsdata.getString("compensacion_o");
            String compensacionE = rsdata.getString("compensacion_e");
            NominaIndividualType.Devengados.Compensaciones.Compensacion compensacion = new NominaIndividualType.Devengados.Compensaciones.Compensacion();
            compensacion.setCompensacionO(new BigDecimal(compensacionO));
            this.sumDevengado(compensacionO);
            compensacion.setCompensacionE(new BigDecimal(compensacionE));
            this.sumDevengado(compensacionE);
            compensaciones.getCompensacion().add(compensacion);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return compensaciones;
        }
        return null;
    }

    public NominaIndividualType.Devengados.BonoEPCTVs getBonoEPCTVs(String ndocumento, String nitcc) throws SQLException, ParseException, DatatypeConfigurationException {
        NominaIndividualType.Devengados.BonoEPCTVs bonoEPCTVs = new NominaIndividualType.Devengados.BonoEPCTVs();
        boolean empty = true;
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0021", new String[]{ndocumento, nitcc});
        if (rsdata.next()) {
            String pagoS = rsdata.getString("pago_s");
            String pagoNS = rsdata.getString("pago_ns");
            String pagoAlimentacionS = rsdata.getString("pago_alimentacion_s");
            String pagoAlimentacionNS = rsdata.getString("pago_alimentacion_ns");
            NominaIndividualType.Devengados.BonoEPCTVs.BonoEPCTV bonoEPCTV = new NominaIndividualType.Devengados.BonoEPCTVs.BonoEPCTV();
            bonoEPCTV.setPagoS(new BigDecimal(pagoS));
            this.sumDevengado(pagoS);
            bonoEPCTV.setPagoNS(new BigDecimal(pagoNS));
            this.sumDevengado(pagoNS);
            bonoEPCTV.setPagoAlimentacionS(new BigDecimal(pagoAlimentacionS));
            this.sumDevengado(pagoAlimentacionS);
            bonoEPCTV.setPagoAlimentacionNS(new BigDecimal(pagoAlimentacionNS));
            this.sumDevengado(pagoAlimentacionNS);
            bonoEPCTVs.getBonoEPCTV().add(bonoEPCTV);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return bonoEPCTVs;
        }
        return null;
    }

    private NominaIndividualType.Devengados.Comisiones getComisiones(String ndocumento, String nitcc) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0022", new String[]{ndocumento, nitcc});
        NominaIndividualType.Devengados.Comisiones comisiones = new NominaIndividualType.Devengados.Comisiones();
        boolean empty = true;
        if (rsdata.next()) {
            String comision = rsdata.getString("comision");
            comisiones.getComision().add(new BigDecimal(comision));
            this.sumDevengado(comision);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return comisiones;
        }
        return null;
    }

    private NominaIndividualType.Devengados.PagosTerceros getPagosTerceros(String ndocumento, String nitcc) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0023", new String[]{ndocumento, nitcc});
        NominaIndividualType.Devengados.PagosTerceros pagosTerceros = new NominaIndividualType.Devengados.PagosTerceros();
        boolean empty = true;
        if (rsdata.next()) {
            String pagosterceros = rsdata.getString("pagos_terceros");
            pagosTerceros.getPagoTercero().add(new BigDecimal(pagosterceros));
            this.sumDevengado(pagosterceros);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return pagosTerceros;
        }
        return null;
    }

    private NominaIndividualType.Devengados.Anticipos getAnticipos(String ndocumento, String nitcc) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0024", new String[]{ndocumento, nitcc});
        NominaIndividualType.Devengados.Anticipos anticipos = new NominaIndividualType.Devengados.Anticipos();
        boolean empty = true;
        if (rsdata.next()) {
            String anticipo = rsdata.getString("anticipo");
            anticipos.getAnticipo().add(new BigDecimal(anticipo));
            this.sumDevengado(anticipo);
            empty = false;
        }
        rsdata.close();
        if (!empty) {
            return anticipos;
        }
        return null;
    }

    private XMLGregorianCalendar getXMLDate(String sdate) throws ParseException, DatatypeConfigurationException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date date = format.parse(sdate);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
    }

    public BigDecimal getTotales() {
        return new BigDecimal(this.devengadoTotal);
    }

    private void sumDevengado(String value) {
        BigDecimal valorPago = new BigDecimal(value);
        this.devengadoTotal += valorPago.doubleValue();
    }
}

