/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jdom.Content;
import org.jdom.Element;
import org.postgresql.util.PSQLException;
import server.comunications.ErrorXML;
import server.comunications.SocketWriterServer;
import server.database.connection.ConnectionsPool;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class ResultSetToHtmlTable {
    private String bd;
    private String sql;
    private String[] args;
    private SocketChannel sock;
    private String id;

    public ResultSetToHtmlTable(String bd, String sql, String[] args, SocketChannel sock) {
        this.bd = bd;
        this.sql = sql;
        this.args = args;
        this.sock = sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getTable() {
        Element table = new Element("table");
        System.out.println("bd: " + this.bd);
        Connection conn = ConnectionsPool.getMultiConnection(this.bd);
        Statement st = null;
        ResultSet RSdatos = null;
        String sqlCode = null;
        try {
            int rowCount;
            st = conn.createStatement();
            sqlCode = this.args == null ? SQLFormatAgent.getSentencia(this.bd, this.sql) : SQLFormatAgent.getSentencia(this.bd, this.sql, this.args);
            System.out.println("ejecutando " + this.sql);
            long tinicio = System.currentTimeMillis();
            st.execute(sqlCode);
            while ((RSdatos = st.getResultSet()) == null && (rowCount = st.getUpdateCount()) != -1) {
                st.getMoreResults();
            }
            ResultSetMetaData RSMDinfo = RSdatos.getMetaData();
            int columnas = RSMDinfo.getColumnCount();
            SocketChannel socketChannel = this.sock;
            synchronized (socketChannel) {
                while (RSdatos.next()) {
                    Element fila = new Element("tr");
                    for (int j = 1; j <= columnas; ++j) {
                        Element columna = new Element("td");
                        columna.setText(RSdatos.getString(j));
                        fila.addContent((Content)columna);
                    }
                    table.addContent((Content)fila);
                }
                StatementsClosingHandler.close(RSdatos);
                long ttotal = System.currentTimeMillis() - tinicio;
                System.out.println("sentencia " + this.sql + " ejecutada y transmitida en " + ttotal + " milisegundos");
            }
            socketChannel = table;
            return socketChannel;
        }
        catch (PSQLException PSQLEe) {
            System.out.println("Query: " + this.sql);
            System.out.println("Error Code: " + PSQLEe.getErrorCode());
            System.out.println("Error Status: " + PSQLEe.getSQLState());
            ErrorXML error = new ErrorXML();
            String err = null;
            if ("P0001".equals(PSQLEe.getSQLState())) {
                err = PSQLEe.getMessage();
            } else {
                err = Language.getWord((String)"ERR_RS") + " " + this.sql + " " + PSQLEe.getMessage();
                LogAdmin.setMessage((String)err, (int)0);
            }
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            System.out.println("Posible SQLServer Error");
            PSQLEe.printStackTrace();
        }
        catch (SQLNotFoundException QNFEe) {
            String err = QNFEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            QNFEe.printStackTrace();
        }
        catch (SQLException SQLEe) {
            System.out.println("Query: " + this.sql);
            System.out.println("Error Code: " + SQLEe.getErrorCode());
            System.out.println("Error Status: " + SQLEe.getSQLState());
            String err = null;
            if ("P0001".equals(SQLEe.getSQLState())) {
                err = SQLEe.getMessage();
            } else {
                err = Language.getWord((String)"ERR_RS") + " " + this.sql + " " + SQLEe.getMessage();
                LogAdmin.setMessage((String)err, (int)0);
            }
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            SQLEe.printStackTrace();
        }
        catch (SQLBadArgumentsException QBAEe) {
            String err = QBAEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            QBAEe.printStackTrace();
        }
        finally {
            try {
                if (RSdatos != null) {
                    RSdatos.close();
                }
                if (st != null) {
                    st.close();
                }
                ConnectionsPool.freeMultiConnection(this.bd, conn);
                System.out.println("Fin de la transmision");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

