/*
 * Decompiled with CFR 0.152.
 */
package server.control;

import common.comunications.InfoSocket;
import common.misc.ZipHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import server.comunications.SocketWriterServer;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class ACPSender
extends Thread {
    private static final long serialVersionUID = -757058034217759942L;
    private Document docACPBegin;
    private String bd;
    private String[] Arrlogin;
    private ResultSet rs;
    private Statement st;
    private SocketChannel sock;
    private String jwt;
    private XMLOutputter xmlout = new XMLOutputter();
    private boolean allData = true;
    private boolean movilConnection;
    private static final boolean MOVIL = true;

    public ACPSender(SocketChannel sock, String jwt, String bd, String login, String code) {
        this.bd = bd;
        this.jwt = jwt;
        this.sock = sock;
        this.allData = false;
        this.Arrlogin = new String[]{login, code};
    }

    public ACPSender(SocketChannel sock, String jwt, String bd, String login, boolean movilConnection) {
        this.bd = bd;
        this.jwt = jwt;
        this.sock = sock;
        this.Arrlogin = new String[]{login};
        this.movilConnection = movilConnection;
        this.SendACPBegin();
    }

    public ACPSender(SocketChannel sock, String jwt, String bd, String login) {
        this.sock = sock;
        this.jwt = jwt;
        this.bd = bd;
        this.Arrlogin = new String[]{login};
        this.SendACPBegin();
    }

    private String validPass(String pass) {
        if (pass == null) {
            return "trust";
        }
        return "password";
    }

    public void SendACPBegin() {
        Element element = new Element("ACPBegin");
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            QueryRunner runquery = new QueryRunner(this.bd, "SCS0042", this.Arrlogin);
            this.rs = runquery.ejecutarSELECT();
            this.rs.next();
            String numTrans = this.rs.getString(1);
            runquery = new QueryRunner(this.bd, "SCS0043", this.Arrlogin);
            this.rs = runquery.ejecutarSELECT();
            this.rs.next();
            String numQuerys = this.rs.getString(1);
            String company = LinkingCache.getCompanyData(InfoSocket.getCompanyNameKey((SocketChannel)this.sock));
            String companyID = LinkingCache.getCompanyData(InfoSocket.getCompanyIDKey((SocketChannel)this.sock));
            System.out.println("user: " + InfoSocket.getLoging((SocketChannel)this.sock) + "ip: " + InfoSocket.getLoging((SocketChannel)this.sock));
            runquery = new QueryRunner(this.bd, "SCS0109", new String[]{InfoSocket.getLoging((SocketChannel)this.sock), InfoSocket.getIp((SocketChannel)this.sock)});
            this.rs = runquery.ejecutarSELECT();
            this.rs.next();
            String userName = this.rs.getString(1);
            String lockTime = this.rs.getString(2);
            String host = this.rs.getString(3);
            this.docACPBegin = new Document();
            this.docACPBegin.setRootElement(element);
            element.addContent((Content)new Element("jwt").setText(this.jwt));
            element.addContent((Content)new Element("companyName").setText(company));
            element.addContent((Content)new Element("companyID").setText(companyID));
            element.addContent((Content)new Element("userName").setText(userName));
            element.addContent((Content)new Element("lockTime").setText(lockTime));
            element.addContent((Content)new Element("host").setText(host));
            element.addContent((Content)new Element("transactions").setText(numTrans));
            element.addContent((Content)new Element("querys").setText(numQuerys));
            SocketWriterServer.writing(this.sock, this.docACPBegin);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        StatementsClosingHandler.close(this.rs);
        StatementsClosingHandler.close(this.st);
        this.rs = null;
        this.st = null;
    }

    @Override
    public void run() {
        try {
            this.st = ConnectionsPool.getConnection(this.bd).createStatement();
            Document cnx = new Document();
            Element selement = new Element("SACPData");
            if (this.movilConnection) {
                if (this.allData) {
                    this.loadTransactions(cnx, selement, "SCS0106", this.Arrlogin);
                } else {
                    this.loadTransactions(cnx, selement, "SCS0100", this.Arrlogin);
                }
            } else if (this.allData) {
                this.loadSentences(cnx, selement);
                this.loadTransactions(cnx, selement, "SCS0004", this.Arrlogin);
            } else {
                this.loadTransactions(cnx, selement, "SCS0100", this.Arrlogin);
            }
            Document doc = this.compressDocument(cnx);
            SocketWriterServer.writing(this.sock, doc);
            selement.removeContent();
            selement = null;
            doc = null;
            System.gc();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadSentences(Document cnx, Element selement) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        QueryRunner runquery = new QueryRunner(this.bd, "SCS0005", this.Arrlogin);
        ResultSet rs = runquery.ejecutarSELECT();
        Element qdata = new Element("ACPData");
        Element query = new Element("query");
        while (rs.next()) {
            Element sql = new Element("sql");
            sql.setText(rs.getString("codigo"));
            sql.setAttribute("type", this.validPass(rs.getString("password")));
            query.addContent((Content)sql);
        }
        qdata.addContent((Content)query);
        selement.addContent((Content)qdata);
        rs.close();
        rs = null;
    }

    private void loadTransactions(Document cnx, Element selement, String sql, String[] args) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        QueryRunner runquery = new QueryRunner(this.bd, sql, args);
        ResultSet rs = runquery.ejecutarSELECT();
        while (rs.next()) {
            Element element = new Element("ACPData");
            Element driver = new Element("driver");
            try {
                Element transaction = new Element("transaction");
                driver.setText(rs.getString("codigo").trim());
                driver.setAttribute("type", this.validPass(rs.getString("password")));
                ByteArrayInputStream bufferIn = new ByteArrayInputStream(rs.getString("perfil").getBytes());
                SAXBuilder builder = new SAXBuilder(false);
                Document form = builder.build((InputStream)bufferIn);
                transaction.addContent((Content)driver);
                transaction.addContent((Content)form.detachRootElement());
                element.addContent((Content)transaction);
                selement.addContent((Content)element);
                bufferIn.close();
                bufferIn = null;
                form = null;
            }
            catch (JDOMException e) {
                e.printStackTrace();
                System.out.println("codigo" + driver.getText() + "Buffer:" + rs.getString("perfil"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        cnx.setRootElement(selement);
        rs.close();
        rs = null;
    }

    private Document compressDocument(Document data) throws IOException {
        Document docZip = new Document();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.xmlout.output(data, (OutputStream)baos);
        baos.close();
        ZipHandler zip = new ZipHandler(baos, "data.xml");
        docZip.setRootElement(zip.getElementDataEncode("ACPZip"));
        return docZip;
    }
}

