/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.rndc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.ParseException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class ElementManifiestoCarga {
    private String bd;
    private double valorFlete;

    public ElementManifiestoCarga(String bd) {
        this.bd = bd;
    }

    public Element getManifiestoCarga(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String id_manifiesto = RSdata.getString("radicado_manifiesto");
            boolean estado = RSdata.getBoolean("estado");
            String numero = RSdata.getString("numero");
            String tipo_doc_conductor = RSdata.getString("tipo_doc_conductor");
            String doc_conductor = RSdata.getString("doc_conductor");
            String numplaca = RSdata.getString("numplaca");
            String municipio_origen = RSdata.getString("municipio_origen");
            String municipio_destino = RSdata.getString("municipio_destino");
            String observaciones = RSdata.getString("observaciones");
            String codoperaciontransporte = RSdata.getString("codoperaciontransporte");
            String fechaexpedicionmanifiesto = RSdata.getString("fechaexpedicionmanifiesto");
            String codtitularmanifiesto = RSdata.getString("codidtitularmanifiesto");
            String numidtitularmanifiesto = RSdata.getString("numidtitularmanifiesto");
            String codidconductor2 = RSdata.getString("codidconductor2");
            String numidconductor2 = RSdata.getString("numidconductor2");
            String retncionicamanifiestocarga = RSdata.getString("retencionicamanifiestocarga");
            String valoranticipomanifiesto = RSdata.getString("valoranticipomanifiesto");
            String codmunicipiopagosaldo = RSdata.getString("codmunicipiopagosaldo");
            String fechapagosaldomanifiesto = RSdata.getString("fechapagosaldomanifiesto");
            String codresponsablepagocargue = RSdata.getString("codresponsablepagocargue");
            String codresponsablepagodescargue = RSdata.getString("codresponsablepagodescargue");
            String aceptacionelectronica = RSdata.getString("aceptacionelectronica");
            RSdata.close();
            if (id_manifiesto != null) {
                System.out.println("La Informacion del Manifiesto de carga ya estaba exportada");
                return null;
            }
            if (!estado) {
                RSdata.close();
                throw new SQLException("El manifiesto " + numero + " se encuentra anulado por tanto no puede ser exportado");
            }
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("NUMMANIFIESTOCARGA", numero));
            variables.addContent((Content)this.addElement("CODOPERACIONTRANSPORTE", codoperaciontransporte));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            Date date = format.parse(fechaexpedicionmanifiesto);
            variables.addContent((Content)this.addElement("FECHAEXPEDICIONMANIFIESTO", formatter.format(date)));
            variables.addContent((Content)this.addElement("CODMUNICIPIOORIGENMANIFIESTO", municipio_origen));
            variables.addContent((Content)this.addElement("CODMUNICIPIODESTINOMANIFIESTO", municipio_destino));
            variables.addContent((Content)this.addElement("CODIDTITULARMANIFIESTO", codtitularmanifiesto));
            variables.addContent((Content)this.addElement("NUMIDTITULARMANIFIESTO", numidtitularmanifiesto));
            variables.addContent((Content)this.addElement("NUMPLACA", numplaca));
            variables.addContent((Content)this.addElement("CODIDCONDUCTOR", tipo_doc_conductor));
            variables.addContent((Content)this.addElement("NUMIDCONDUCTOR", doc_conductor));
            variables.addContent((Content)this.addElement("CODIDCONDUCTOR2", codidconductor2));
            variables.addContent((Content)this.addElement("NUMIDCONDUCTOR2", numidconductor2));
            variables.addContent((Content)this.addElement("RETENCIONICAMANIFIESTOCARGA", retncionicamanifiestocarga));
            variables.addContent((Content)this.addElement("VALORANTICIPOMANIFIESTO", valoranticipomanifiesto));
            variables.addContent((Content)this.addElement("CODMUNICIPIOPAGOSALDO", codmunicipiopagosaldo));
            date = format.parse(fechapagosaldomanifiesto);
            variables.addContent((Content)this.addElement("FECHAPAGOSALDOMANIFIESTO", formatter.format(date)));
            variables.addContent((Content)this.addElement("CODRESPONSABLEPAGOCARGUE", codresponsablepagocargue));
            variables.addContent((Content)this.addElement("CODRESPONSABLEPAGODESCARGUE", codresponsablepagodescargue));
            variables.addContent((Content)this.addElement("ACEPTACIONELECTRONICA", aceptacionelectronica));
            variables.addContent((Content)this.addElement("OBSERVACIONES", observaciones));
            Element remesas = this.getRemesas(ndocumento);
            if (this.valorFlete != 0.0) {
                variables.addContent((Content)this.addElement("CODOPERACIONTRANSPORTE", codoperaciontransporte));
                variables.addContent((Content)this.addElement("VALORFLETEPACTADOVIAJE", String.valueOf(this.valorFlete)));
                variables.addContent((Content)remesas);
            } else {
                variables.addContent((Content)this.addElement("CODOPERACIONTRANSPORTE", "W"));
            }
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    public Element getAnulaManifiestoCarga(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String radicado_anula_remesa = RSdata.getString("radicado_anula_manifiesto");
            String cumplido_manifiesto = RSdata.getString("cumplido_manifiesto");
            String numero = RSdata.getString("numero");
            boolean estado = RSdata.getBoolean("estado");
            RSdata.close();
            if (radicado_anula_remesa != null) {
                throw new SQLException("El manifiesto terrestre de carga numero " + numero + " ya se encontraba anulado");
            }
            if (cumplido_manifiesto != null) {
                throw new SQLException("El manifiesto numero " + numero + " ya se encontraba cumplido en RNDC, por tanto no puede ser anulado");
            }
            if (estado) {
                throw new SQLException("Primero debe anular el documento de forma local");
            }
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("NUMMANIFIESTOCARGA", numero));
            variables.addContent((Content)this.addElement("MOTIVOANULACIONMANIFIESTO", "D"));
            variables.addContent((Content)this.addElement("OBSERVACIONES", "Anulado por inconsistencia en remesas"));
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    public Element getCumplirManifiestoCarga(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String radicado_anula_remesa = RSdata.getString("radicado_anula_manifiesto");
            String cumplido_manifiesto = RSdata.getString("cumplido_manifiesto");
            String numero = RSdata.getString("numero");
            boolean estado = RSdata.getBoolean("estado");
            RSdata.close();
            if (radicado_anula_remesa != null) {
                throw new SQLException("El manifiesto terrestre de carga numero " + numero + " no se puede cumplir porque esta anulado en RNDC");
            }
            if (cumplido_manifiesto != null) {
                throw new SQLException("El manifiesto numero " + numero + " ya se encontraba cumplido en RNDC");
            }
            if (!estado) {
                throw new SQLException("No es posible generar cumplidos de documentos anulados");
            }
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("NUMMANIFIESTOCARGA", numero));
            variables.addContent((Content)this.addElement("TIPOCUMPLIDOMANIFIESTO", "C"));
            Date fechaCumplido = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            variables.addContent((Content)this.addElement("FECHAENTREGADOCUMENTOS", formatter.format(fechaCumplido)));
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    private Element getRemesas(String ndocumento) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Element remesas = new Element("REMESASMAN");
        Attribute procesoid = new Attribute("procesoid", "43");
        remesas.setAttribute(procesoid);
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0006", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        while (RSdata.next()) {
            Element manPreremesa = new Element("REMESA");
            this.valorFlete += RSdata.getDouble("valor_remesa");
            manPreremesa.addContent((Content)this.addElement("CONSECUTIVOREMESA", RSdata.getString("numero_remesa")));
            remesas.addContent((Content)manPreremesa);
        }
        return remesas;
    }

    public Element addElement(String nameElement, String value) {
        Element elm = new Element(nameElement);
        elm.setText(value);
        return elm;
    }
}

