/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODIconFactory;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class NimRODLookAndFeel
extends MetalLookAndFeel {
    public static Color brillo = new Color(255, 255, 255, 64);
    public static Color sombra = new Color(20, 20, 20, 50);
    public static Color negroOpaco = new Color(0, 0, 0, 64);
    public static Color negroTrans = new Color(0, 0, 0, 0);
    public static Color blancoOpaco = new Color(255, 255, 255, 128);
    public static Color blancoTrans = new Color(255, 255, 255, 0);

    public NimRODLookAndFeel() {
        NimRODTheme nimRODTheme = new NimRODTheme();
        try {
            String string = System.getProperty("nimrodlf.selection");
            String string2 = System.getProperty("nimrodlf.background");
            if (string != null) {
                nimRODTheme = string2 != null ? new NimRODTheme(Color.decode(string), Color.decode(string2)) : new NimRODTheme(Color.decode(string));
            } else {
                String string3 = System.getProperty("nimrodlf.p1");
                String string4 = System.getProperty("nimrodlf.p2");
                String string5 = System.getProperty("nimrodlf.p3");
                String string6 = System.getProperty("nimrodlf.s1");
                String string7 = System.getProperty("nimrodlf.s2");
                String string8 = System.getProperty("nimrodlf.s3");
                String string9 = System.getProperty("nimrodlf.w");
                String string10 = System.getProperty("nimrodlf.b");
                if (string3 != null) {
                    nimRODTheme.setPrimary1(Color.decode(string3));
                }
                if (string4 != null) {
                    nimRODTheme.setPrimary2(Color.decode(string4));
                }
                if (string5 != null) {
                    nimRODTheme.setPrimary3(Color.decode(string5));
                }
                if (string6 != null) {
                    nimRODTheme.setSecondary1(Color.decode(string6));
                }
                if (string7 != null) {
                    nimRODTheme.setSecondary2(Color.decode(string7));
                }
                if (string8 != null) {
                    nimRODTheme.setSecondary3(Color.decode(string8));
                }
                if (string9 != null) {
                    nimRODTheme.setWhite(Color.decode(string9));
                }
                if (string10 != null) {
                    nimRODTheme.setBlack(Color.decode(string10));
                }
            }
        }
        catch (Exception exception) {
            nimRODTheme = new NimRODTheme();
        }
        NimRODLookAndFeel.setCurrentTheme(nimRODTheme);
    }

    public String getID() {
        return "NimROD";
    }

    public String getName() {
        return "NimROD";
    }

    public String getDescription() {
        return "Look and Feel NimROD, 2005";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        uIDefaults.put("ButtonUI", "com.nilo.plaf.nimrod.NimRODButtonUI");
        uIDefaults.put("ToggleButtonUI", "com.nilo.plaf.nimrod.NimRODToggleButtonUI");
        uIDefaults.put("TextFieldUI", "com.nilo.plaf.nimrod.NimRODTextFieldUI");
        uIDefaults.put("PasswordFieldUI", "com.nilo.plaf.nimrod.NimRODPasswordFieldUI");
        uIDefaults.put("CheckBoxUI", "com.nilo.plaf.nimrod.NimRODCheckBoxUI");
        uIDefaults.put("RadioButtonUI", "com.nilo.plaf.nimrod.NimRODRadioButtonUI");
        uIDefaults.put("FormattedTextFieldUI", "com.nilo.plaf.nimrod.NimRODFormattedTextFieldUI");
        uIDefaults.put("SliderUI", "com.nilo.plaf.nimrod.NimRODSliderUI");
        uIDefaults.put("ListUI", "com.nilo.plaf.nimrod.NimRODListUI");
        uIDefaults.put("ScrollBarUI", "com.nilo.plaf.nimrod.NimRODScrollBarUI");
        uIDefaults.put("ToolBarUI", "com.nilo.plaf.nimrod.NimRODToolBarUI");
        uIDefaults.put("ProgressBarUI", "com.nilo.plaf.nimrod.NimRODProgressBarUI");
        uIDefaults.put("TabbedPaneUI", "com.nilo.plaf.nimrod.NimRODTabbedPaneUI");
        uIDefaults.put("TableHeaderUI", "com.nilo.plaf.nimrod.NimRODTableHeaderUI");
        uIDefaults.put("SplitPaneUI", "com.nilo.plaf.nimrod.NimRODSplitPaneUI");
        uIDefaults.put("MenuBarUI", "com.nilo.plaf.nimrod.NimRODMenuBarUI");
        uIDefaults.put("MenuUI", "com.nilo.plaf.nimrod.NimRODMenuUI");
        uIDefaults.put("PopupMenuUI", "com.nilo.plaf.nimrod.NimRODPopupMenuUI");
        uIDefaults.put("PopupMenuSeparatorUI", "com.nilo.plaf.nimrod.NimRODPopupMenuSeparatorUI");
        uIDefaults.put("MenuItemUI", "com.nilo.plaf.nimrod.NimRODMenuItemUI");
        uIDefaults.put("CheckBoxMenuItemUI", "com.nilo.plaf.nimrod.NimRODCheckBoxMenuItemUI");
        uIDefaults.put("RadioButtonMenuItemUI", "com.nilo.plaf.nimrod.NimRODRadioButtonMenuItemUI");
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        uIDefaults.put("textHighlight", NimRODLookAndFeel.getMenuSelectedBackground());
        uIDefaults.put("textInactiveText", NimRODLookAndFeel.getInactiveSystemTextColor().darker());
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        uIDefaults.put("Tree.collapsedIcon", NimRODIconFactory.getTreeCollapsedIcon());
        uIDefaults.put("Tree.expandedIcon", NimRODIconFactory.getTreeExpandedIcon());
        uIDefaults.put("Tree.closedIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeDirCerrado.png"));
        uIDefaults.put("Tree.openIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeDirAbierto.png"));
        uIDefaults.put("Tree.leafIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeFicheroIcon.png"));
        uIDefaults.put("Tree.EstructuraCollapsedIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeCollapsedIcon.png"));
        uIDefaults.put("Tree.EstructuraExpandedIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/TreeExpandedIcon.png"));
        uIDefaults.put("FileView.directoryIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogDirCerrado.png"));
        uIDefaults.put("FileView.fileIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogFicheroIcon.png"));
        uIDefaults.put("FileView.floppyDriveIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogFloppyIcon.png"));
        uIDefaults.put("FileView.hardDriveIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogHDIcon.png"));
        uIDefaults.put("FileChooser.newFolderIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogNewDir.png"));
        uIDefaults.put("FileChooser.homeFolderIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogHome.png"));
        uIDefaults.put("FileChooser.upFolderIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogDirParriba.png"));
        uIDefaults.put("FileChooser.detailsViewIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogDetails.png"));
        uIDefaults.put("FileChooser.listViewIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/DialogList.png"));
        uIDefaults.put("CheckBoxMenuItem.checkIcon", NimRODIconFactory.getCheckBoxMenuItemIcon());
        uIDefaults.put("RadioButtonMenuItem.checkIcon", NimRODIconFactory.getRadioButtonMenuItemIcon());
        uIDefaults.put("Menu.checkIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/bordeMenu.png"));
        uIDefaults.put("MenuItem.checkIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/bordeMenu.png"));
        uIDefaults.put("MenuCheckBox.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuCheckBoxBase.png"));
        uIDefaults.put("MenuCheckBox.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuCheckBoxTick.png"));
        uIDefaults.put("MenuRadioButton.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuRadioBase.png"));
        uIDefaults.put("MenuRadioButton.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/MenuRadioTick.png"));
        uIDefaults.put("CheckBox.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/CheckBoxBase.png"));
        uIDefaults.put("CheckBox.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/CheckBoxTick.png"));
        uIDefaults.put("RadioButton.iconBase", this.loadRes("/com/nilo/plaf/nimrod/icons/RadioButtonBase.png"));
        uIDefaults.put("RadioButton.iconTick", this.loadRes("/com/nilo/plaf/nimrod/icons/RadioButtonTick.png"));
        uIDefaults.put("OptionPane.errorIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Error.png"));
        uIDefaults.put("OptionPane.informationIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Inform.png"));
        uIDefaults.put("OptionPane.warningIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Warn.png"));
        uIDefaults.put("OptionPane.questionIcon", this.loadRes("/com/nilo/plaf/nimrod/icons/Question.png"));
        uIDefaults.put("Slider.horizontalThumbIcon", NimRODIconFactory.getSliderHorizontalIcon());
        uIDefaults.put("Slider.verticalThumbIcon", NimRODIconFactory.getSliderVerticalIcon());
        uIDefaults.put("Slider.horizontalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/HorizontalThumbIconImage.png"));
        uIDefaults.put("Slider.verticalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/VerticalThumbIconImage.png"));
        uIDefaults.put("ScrollBar.horizontalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/HorizontalScrollIconImage.png"));
        uIDefaults.put("ScrollBar.verticalThumbIconImage", this.loadRes("/com/nilo/plaf/nimrod/icons/VerticalScrollIconImage.png"));
        uIDefaults.put("Button.margin", new InsetsUIResource(5, 14, 5, 14));
        uIDefaults.put("ToggleButton.margin", new InsetsUIResource(5, 14, 5, 14));
    }

    private ImageIcon loadRes(String string) {
        try {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.readStream(this.getClass().getResourceAsStream(string))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("No se puede cargar el recurso " + string);
            return null;
        }
    }

    private byte[] readStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray, 0, 256)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void pintaBarraMenu(Graphics graphics, JMenuItem jMenuItem, Color color) {
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = jMenuItem.getWidth();
        int n2 = jMenuItem.getHeight();
        if (jMenuItem.isOpaque()) {
            graphics.setColor(jMenuItem.getBackground());
            graphics.fillRect(0, 0, n, n2);
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                RoundRectangle2D.Float float_ = new RoundRectangle2D.Float();
                float_.x = 1.0f;
                float_.y = 0.0f;
                float_.width = n - 3;
                float_.height = n2 - 1;
                float_.arcwidth = 8.0f;
                float_.archeight = 8.0f;
                GradientPaint gradientPaint = new GradientPaint(1.0f, 1.0f, brillo, 0.0f, n2, sombra);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics.setColor(color);
                graphics2D.fill(float_);
                graphics.setColor(color.darker());
                graphics2D.draw(float_);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fill(float_);
            }
            graphics.setColor(color2);
        }
    }
}

